/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class testTable
extends JPanel
implements ActionListener {
    String tableName;
    String prettyName;
    String buttonName;
    int maxRows;
    JTable table;
    Vector rows = new Vector();
    Vector columns = new Vector();
    DefaultTableModel tableModel;
    JScrollPane scrollPane;
    JButton buttonAdd;
    JButton buttonDelete;
    JPanel buttonPanel;

    public static void main(String[] args) {
        JFrame jf = new JFrame("Testframe");
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        testTable jsF = new testTable();
        jf.getContentPane().add((Component)jsF, "Center");
        jf.pack();
        jf.setVisible(true);
    }

    public testTable() {
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
        this.setFocusCycleRoot(true);
        this.maxRows = 10;
        String[] c = new String[]{"Col1", "Col2", "Col3"};
        this.addColumns(c);
        this.tableModel = new DefaultTableModel();
        this.tableModel.setDataVector(this.rows, this.columns);
        this.table = new JTable(this.tableModel){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (this.editCellAt(row, column)) {
                    this.getEditorComponent().requestFocusInWindow();
                }
            }
        };
        this.table.setSurrendersFocusOnKeystroke(true);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(2);
        this.setCellEditors();
        this.buttonPanel = new JPanel();
        this.buttonAdd = new JButton("Add New Row");
        this.buttonDelete = new JButton("Delete Row");
        this.buttonPanel.add(this.buttonAdd);
        this.buttonPanel.add(this.buttonDelete);
        this.buttonAdd.addActionListener(this);
        this.buttonDelete.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
        this.add("South", this.buttonPanel);
        this.addRow();
    }

    public void addColumns(String[] c) {
        int i = 0;
        while (i < c.length) {
            this.columns.addElement(c[i]);
            ++i;
        }
    }

    public void setCellEditors() {
        TableColumn col = this.table.getColumnModel().getColumn(1);
        Object[] vals = new Object[]{"", "Test1", "Test2", "Test3"};
        col.setCellEditor(new AutoCompletionComboBoxEditor(vals));
    }

    public void addRow() {
        if (this.table.getRowCount() < this.maxRows) {
            Vector r = this.createBlankElement();
            this.rows.addElement(r);
            this.table.addNotify();
        }
    }

    public Vector createBlankElement() {
        Vector<String> t = new Vector<String>();
        t.addElement("");
        t.addElement("");
        t.addElement("");
        return t;
    }

    public void deleteRow(int index) {
        if (index > -1) {
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            ((DefaultTableModel)this.table.getModel()).removeRow(index);
            this.table.addNotify();
        }
    }

    @Override
    public void actionPerformed(ActionEvent source) {
        if (source.getSource() == this.buttonAdd) {
            this.addRow();
        } else if (source.getSource() == this.buttonDelete) {
            this.deleteRow(this.table.getSelectedRow());
        }
    }

    public static class AutoCompletionComboBoxEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox cbx;

        public AutoCompletionComboBoxEditor(Object[] items) {
            this.cbx = new JComboBox<Object>(items);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.cbx;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cbx.getSelectedItem();
        }
    }
}

