/*
 * Decompiled with CFR 0.152.
 */
package schematron;

import com.topologi.schematron.SchtrnParams;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import schematron.GenerateExemptionLists;
import schematron.GenerateJigLists;
import schematron.GenerateMaterialGroupLists;
import schematron.GenerateQueryLists;
import schematron.MyFileFilter;
import schematron.SchtrnValidator;

public class MainJFrame
extends JFrame {
    private JButton jButtonBrowseSHC;
    private JButton jButtonBrowseXML;
    private JButton jButtonClear;
    private JButton jButtonValidate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField jTFFileName;
    private JTextField jTFSCHFileName;
    private JTextArea jTextAreaResults;

    public MainJFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTFFileName = new JTextField();
        this.jButtonBrowseXML = new JButton();
        this.jTFSCHFileName = new JTextField();
        this.jButtonBrowseSHC = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaResults = new JTextArea();
        this.jButtonClear = new JButton();
        this.jButtonValidate = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Validation");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("XML File :");
        this.jLabel1.setMaximumSize(new Dimension(150, 18));
        this.jLabel1.setMinimumSize(new Dimension(150, 18));
        this.jLabel1.setPreferredSize(new Dimension(150, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(33, 38, 0, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Schematron File :");
        this.jLabel2.setMaximumSize(new Dimension(150, 18));
        this.jLabel2.setMinimumSize(new Dimension(150, 18));
        this.jLabel2.setPreferredSize(new Dimension(150, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 38, 0, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jTFFileName.setMinimumSize(new Dimension(300, 19));
        this.jTFFileName.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(33, 10, 10, 0);
        this.jPanel1.add((Component)this.jTFFileName, gridBagConstraints);
        this.jButtonBrowseXML.setText("Browse...");
        this.jButtonBrowseXML.setMaximumSize(new Dimension(70, 23));
        this.jButtonBrowseXML.setMinimumSize(new Dimension(70, 23));
        this.jButtonBrowseXML.setPreferredSize(new Dimension(70, 23));
        this.jButtonBrowseXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonBrowseXMLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(33, 0, 10, 34);
        this.jPanel1.add((Component)this.jButtonBrowseXML, gridBagConstraints);
        this.jTFSCHFileName.setMinimumSize(new Dimension(300, 19));
        this.jTFSCHFileName.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel1.add((Component)this.jTFSCHFileName, gridBagConstraints);
        this.jButtonBrowseSHC.setText("Browse...");
        this.jButtonBrowseSHC.setMaximumSize(new Dimension(70, 23));
        this.jButtonBrowseSHC.setMinimumSize(new Dimension(70, 23));
        this.jButtonBrowseSHC.setPreferredSize(new Dimension(70, 23));
        this.jButtonBrowseSHC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonBrowseSHCActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 34);
        this.jPanel1.add((Component)this.jButtonBrowseSHC, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jPanel2.setMinimumSize(new Dimension(0, 300));
        this.jPanel2.setPreferredSize(new Dimension(564, 300));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jTextAreaResults.setColumns(20);
        this.jTextAreaResults.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaResults);
        this.jPanel2.add(this.jScrollPane1);
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButtonClear);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 38, 17, 32);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonValidate.setText("Validate");
        this.jButtonValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonValidateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        this.jPanel1.add((Component)this.jButtonValidate, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButtonBrowseXMLActionPerformed(ActionEvent evt) {
        JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
        MyFileFilter xmlFilter = new MyFileFilter("xml", "XML files *.xml");
        fileDlg.setFileFilter(xmlFilter);
        if (fileDlg.showOpenDialog(this) == 0) {
            this.jTFFileName.setText(fileDlg.getSelectedFile().getAbsolutePath());
        }
    }

    private void jButtonBrowseSHCActionPerformed(ActionEvent evt) {
        JFileChooser fileDlg = new JFileChooser(new File(".").getAbsolutePath());
        MyFileFilter xmlFilter = new MyFileFilter("sch", "SCHEMATRON files *.sch");
        fileDlg.setFileFilter(xmlFilter);
        if (fileDlg.showOpenDialog(this) == 0) {
            this.jTFSCHFileName.setText(fileDlg.getSelectedFile().getAbsolutePath());
        }
    }

    private void jButtonValidateActionPerformed(ActionEvent evt) {
        System.out.println("jButtonValidateActionPerformed");
        String xml = this.jTFFileName.getText();
        String schema = this.jTFSCHFileName.getText();
        SchtrnValidator validator = new SchtrnValidator();
        System.out.println("File.separator" + File.separator);
        validator.setEngineStylesheet("Scripts" + File.separator + "schematron-diagnose.xsl");
        SchtrnParams sp = new SchtrnParams();
        validator.setParams(sp);
        validator.setBaseXML(true);
        try {
            this.jTextAreaResults.append(validator.validate(xml, schema));
            System.out.println(validator.validate(xml, schema));
        }
        catch (TransformerConfigurationException tce) {
            this.jTextAreaResults.append("Configuration error: " + tce.getMessageAndLocation());
            System.out.println("Configuration error: " + tce.getMessageAndLocation());
        }
        catch (TransformerException te) {
            this.jTextAreaResults.append("Transformation error: " + te.getMessageAndLocation());
            System.out.println("Transformation error: " + te.getMessageAndLocation());
        }
        catch (Exception e) {
            this.jTextAreaResults.append("An error occurred: " + e.getMessage() + "\n" + e);
            System.out.println("An error occurred: " + e.getMessage() + "\n" + e);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextAreaResults.setText("");
    }

    public static void initSchematrn() {
        System.out.println("MainJFrame1111");
        GenerateExemptionLists.generate();
        GenerateMaterialGroupLists.generate();
        GenerateQueryLists.generate();
        GenerateJigLists.generate();
    }

    public static void main(String[] args) {
        MainJFrame.initSchematrn();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainJFrame().setVisible(true);
            }
        });
    }
}

