/*
 * Decompiled with CFR 0.152.
 */
package Sign;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class ImportCertificateFrame
extends JFrame {
    JFrame main;
    private JLabel AliasError;
    private JButton jButtonBrowse;
    private JButton jButtonImport;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField jTFAlias;
    private JTextField jTFFileName;
    private JTextPane jTextPane1;
    JFileChooser fileDlg;
    Vector<String> aliases = new Vector();

    public ImportCertificateFrame(JFrame main) {
        this.main = main;
        this.initComponents();
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        try {
            this.initAliases();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTFFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButtonBrowse = new JButton();
        this.jTextPane1 = new JTextPane();
        this.jTFAlias = new JTextField();
        this.jButtonImport = new JButton();
        this.AliasError = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("Sign/Bundle");
        this.setTitle(bundle.getString("ImportCertificateFrame.title"));
        this.jPanel1.setMinimumSize(new Dimension(500, 200));
        this.jPanel1.setPreferredSize(new Dimension(500, 200));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setText(bundle.getString("ImportCertificateFrame.jLabel2.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 1, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jTFFileName.setMinimumSize(new Dimension(300, 19));
        this.jTFFileName.setPreferredSize(new Dimension(300, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.jPanel1.add((Component)this.jTFFileName, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("ImportCertificateFrame.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 1, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jButtonBrowse.setText(bundle.getString("ImportCertificateFrame.jButtonBrowse.text"));
        this.jButtonBrowse.setMaximumSize(new Dimension(70, 23));
        this.jButtonBrowse.setMinimumSize(new Dimension(70, 23));
        this.jButtonBrowse.setPreferredSize(new Dimension(70, 23));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCertificateFrame.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 34);
        this.jPanel1.add((Component)this.jButtonBrowse, gridBagConstraints);
        this.jTextPane1.setText(bundle.getString("ImportCertificateFrame.jTextPane1.text"));
        this.jTextPane1.setMinimumSize(new Dimension(350, 40));
        this.jTextPane1.setOpaque(false);
        this.jTextPane1.setPreferredSize(new Dimension(350, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 34);
        this.jPanel1.add((Component)this.jTextPane1, gridBagConstraints);
        this.jTFAlias.setMinimumSize(new Dimension(150, 19));
        this.jTFAlias.setPreferredSize(new Dimension(150, 19));
        this.jTFAlias.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ImportCertificateFrame.this.jTFAliasKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 7, 0);
        this.jPanel1.add((Component)this.jTFAlias, gridBagConstraints);
        this.jButtonImport.setText(bundle.getString("ImportCertificateFrame.jButtonImport.text"));
        this.jButtonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportCertificateFrame.this.jButtonImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new Insets(7, 5, 7, 5);
        this.jPanel1.add((Component)this.jButtonImport, gridBagConstraints);
        this.AliasError.setForeground(new Color(255, 51, 51));
        this.AliasError.setMaximumSize(new Dimension(150, 19));
        this.AliasError.setMinimumSize(new Dimension(150, 19));
        this.AliasError.setPreferredSize(new Dimension(150, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.jPanel1.add((Component)this.AliasError, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        this.fileDlg = new JFileChooser(new File(".").getAbsolutePath());
        if (this.fileDlg.showOpenDialog(this) == 0) {
            this.jTFFileName.setText(this.fileDlg.getSelectedFile().getAbsolutePath());
        }
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        if (!this.jTFAlias.getText().equals("")) {
            try {
                this.addTrustedCert(this.jTFAlias.getText(), new FileInputStream(this.jTFFileName.getText()));
            }
            catch (Exception ex) {
                Logger.getLogger(ImportCertificateFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("Sign/Bundle").getString("ALIAS_IS_REQUIERED_TO_IMPORT_THE_CERTIFICATE_!"));
        }
    }

    private void jTFAliasKeyReleased(KeyEvent evt) {
        if (!this.checkAlias(this.jTFAlias.getText())) {
            this.AliasError.setText(ResourceBundle.getBundle("Sign/Bundle").getString("ALIAS_ALREADY_EXIST_!"));
        } else {
            this.AliasError.setText("");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImportCertificateFrame(null).setVisible(true);
            }
        });
    }

    private boolean checkAlias(String text) {
        return !this.aliases.contains(text);
    }

    private void initAliases() {
        FileInputStream fis = null;
        try {
            try {
                KeyStore ksout = KeyStore.getInstance(KeyStore.getDefaultType());
                fis = new FileInputStream(".keystore");
                ksout.load(fis, "scriba".toCharArray());
                fis.close();
                Enumeration<String> aliases = ksout.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    this.aliases.add(alias);
                }
            }
            catch (IOException iOException) {
                try {
                    fis.close();
                }
                catch (IOException iOException2) {
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (CertificateException certificateException) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (KeyStoreException keyStoreException) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean addTrustedCert(String alias, InputStream in) throws Exception {
        X509Certificate cert;
        KeyStore ks;
        block5: {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(".keystore");
            ks.load(fis, "scriba".toCharArray());
            fis.close();
            if (ks.containsAlias(alias)) {
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_NOT_IMPORTED,_ALIAS__ALREADY_EXISTS"));
                return false;
            }
            cert = null;
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            cert = (X509Certificate)cf.generateCertificate(in);
            String aliasCert = ks.getCertificateAlias(cert);
            if (aliasCert == null) break block5;
            JOptionPane.showMessageDialog(null, String.valueOf(ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_ALREADY_EXISTS_IN_YOUR_STORE_\"")) + aliasCert + "\"!");
            return false;
        }
        try {
            ks.setCertificateEntry(alias, cert);
            FileOutputStream fout = new FileOutputStream(".keystore");
            ks.store(fout, "scriba".toCharArray());
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("CERTIFICATE_IMPORTED"));
            this.main.setVisible(true);
            this.dispose();
            return true;
        }
        catch (ClassCastException cce) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("INPUT_NOT_AN_X.509_CERTIFICATE"));
            cce.printStackTrace();
        }
        catch (CertificateException ce) {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("Sign/Bundle").getString("INPUT_NOT_AN_X.509_CERTIFICATE"));
            ce.printStackTrace();
        }
        return false;
    }
}

