/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import RepeateTables.ButtonColumn;
import RepeateTables.ButtonEditor;
import RepeateTables.RepeatTableCellRenderer;
import RepeateTables.XMLTable;
import Util.CFloatEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public abstract class RepeatTable
implements ActionListener,
TableModelListener {
    public DefaultTableModel model;
    public XMLTable table;
    public ButtonEditor addButton = new ButtonEditor(this, "+");
    public ButtonEditor delButton = new ButtonEditor(this, "-");
    public static CFloatEditor floatEditor = new CFloatEditor();
    RepeatTableCellRenderer repeatTableCellRenderer = new RepeatTableCellRenderer();

    public RepeatTable() {
        this.model = new MyModel();
        this.table = new XMLTable(this.model);
        this.table.setDefaultRenderer(this.table.getModel().getColumnClass(0), this.repeatTableCellRenderer);
        this.init();
        this.addRow(null);
    }

    public void removeAll() {
        int rows = this.model.getRowCount();
        int j = 0;
        while (j < rows) {
            this.model.removeRow(0);
            ++j;
        }
        this.addRow(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setColDimension(int[] width) {
        int i = 0;
        while (i < width.length) {
            this.table.getColumnModel().getColumn(i).setMaxWidth(width[i]);
            ++i;
        }
    }

    @Override
    public void tableChanged(TableModelEvent source) {
        DefaultTableModel tabMod = (DefaultTableModel)source.getSource();
    }

    public abstract void init();

    public void addColumns(String[] colName) {
        int i = 0;
        while (i < colName.length) {
            this.model.addColumn(colName[i]);
            ++i;
        }
    }

    public void insertRow(int index, Object[] row) {
        this.model.insertRow(index, row);
    }

    public void insertRow(int index, int col) {
        Vector<Object> row = new Vector<Object>();
        int i = 0;
        while (i < col) {
            row.addElement(null);
            ++i;
        }
        this.addEmptyCell(col, row);
        this.model.insertRow(index, row);
    }

    public abstract void addEmptyCell(int var1, Vector var2);

    public abstract String getValueOfRow(int var1);

    public void addInserRemoveCol(int col) {
        ButtonColumn buttonColumn = new ButtonColumn(this.table, col);
    }

    public void addRow(Object[] row) {
        this.addRow(0);
    }

    public void addRow(int col) {
        Vector<Object> row = new Vector<Object>();
        int i = 0;
        while (i < col) {
            row.addElement(null);
            ++i;
        }
        this.addEmptyCell(col, row);
        this.model.addRow(row);
    }

    public void clear() {
        int rowNbr = this.table.getRowCount();
        int i = 0;
        while (i < rowNbr) {
            this.model.removeRow(0);
            ++i;
        }
        this.addRow(0);
    }

    public void deleteRow(int index) {
        this.model.removeRow(index);
    }

    public void setCellValue(int row, int col, String value) {
        this.model.setValueAt(value, row, col);
    }

    public void setCellValue(int col, String value) {
        this.model.setValueAt(value, this.model.getRowCount() - 1, col);
    }

    public class MyModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return RepeatTable.this.table.getValueAt(row, column) != null;
        }

        public Vector getColumnIdentifiers() {
            return this.columnIdentifiers;
        }
    }
}

