/*
 * Decompiled with CFR 0.152.
 */
package RepeateTables;

import Parse.ParseSaveXML;
import ReadConf.SubProduct;
import RepeateTables.ComboBoxMapXML;
import RepeateTables.RepeatTable;
import RepeateTables.XMLTable;
import View.FileWarning;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ExemptTable
extends RepeatTable {
    private String version;
    static int[] columnDim3 = new int[]{15, 15, 1000};
    SubProduct subProduct;

    public ExemptTable(String version, SubProduct subProduct) {
        this.subProduct = subProduct;
        this.setVersion(version);
    }

    @Override
    public void addEmptyCell(int col, Vector row) {
        row.addElement("+");
        row.addElement("-");
        row.addElement("");
    }

    public void createExempt(String version) {
        this.subProduct.setExemptVersion(version);
        this.model.fireTableStructureChanged();
        this.setColDimension(columnDim3);
    }

    @Override
    public void setCellValue(int col, String value) {
        String[] list = this.subProduct.getListExempt();
        if (this.subProduct.getExemptVersion().equals("") || list == null) {
            this.model.setValueAt(value, this.model.getRowCount() - 1, col);
            return;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i] == null) {
                list[i] = "";
            }
            if (list[i].length() > 0 && list[i].equals(value)) {
                this.model.setValueAt(list[i], this.model.getRowCount() - 1, col);
                break;
            }
            this.model.setValueAt("", this.model.getRowCount() - 1, col);
            ++i;
        }
    }

    @Override
    public String getValueOfRow(int row) {
        String value = "";
        if (row == 0) {
            value = String.valueOf(value) + "\n";
            int i = 0;
            while (i < ParseSaveXML.indent + 1) {
                value = String.valueOf(value) + "    ";
                ++i;
            }
            value = String.valueOf(value) + "<ExemptionList>";
            if (!this.isEmpty()) {
                value = String.valueOf(value) + "\n";
                i = 0;
                while (i < ParseSaveXML.indent + 2) {
                    value = String.valueOf(value) + "    ";
                    ++i;
                }
                value = String.valueOf(value) + "<ExemptionListID ";
                value = !this.subProduct.getExemptVersion().equals("") ? String.valueOf(value) + "authority=\"IPC\" identity=\"" + this.subProduct.getExemptVersion() + "\"/>" : String.valueOf(value) + "authority=\"NONE\" />";
            }
        }
        if (!((String)this.table.getXMLValueAt(row, 2)).trim().equals("")) {
            String token = (String)this.table.getXMLValueAt(row, 2);
            String tempdesc = "";
            String tempid = "";
            if (token.indexOf(" - ") != -1) {
                int index = token.indexOf(" - ") + 3;
                tempdesc = token.substring(index, token.length());
                tempid = token.split(" - ")[0];
            } else {
                tempid = token.trim();
                tempdesc = " ";
            }
            value = String.valueOf(value) + "\n";
            int i = 0;
            while (i < ParseSaveXML.indent + 1) {
                value = String.valueOf(value) + "    ";
                ++i;
            }
            value = String.valueOf(value) + "<Exemption description=\"" + tempdesc + "\" identity=\"" + tempid + "\"/>";
        }
        if (row == this.table.getRowCount() - 1) {
            value = String.valueOf(value) + "\n";
            int i = 0;
            while (i < ParseSaveXML.indent + 2) {
                value = String.valueOf(value) + "    ";
                ++i;
            }
            value = String.valueOf(value) + " </ExemptionList>";
        }
        return value;
    }

    @Override
    public void init() {
        this.table = new MyJTable(this.model);
        String[] columnNames3 = new String[]{"+", "-", ResourceBundle.getBundle("RepeateTables/Bundle").getString("EXEMPTION")};
        this.addColumns(columnNames3);
        this.setColDimension(columnDim3);
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (!ComboBoxMapXML.isExeptionVersion(version) && !version.equals("")) {
            String versions = "[";
            int i = 0;
            while (i < ComboBoxMapXML.getExemptionVersions().length) {
                versions = String.valueOf(versions) + ComboBoxMapXML.getExemptionVersions()[i] + "; ";
                ++i;
            }
            versions = String.valueOf(versions) + "]";
            FileWarning.log.append("\n Wrong ExemptionList  version : " + version + " should be one of " + versions);
        }
        this.version = version;
        this.createExempt(version);
    }

    private boolean isEmpty() {
        int rowNbr = this.table.getRowCount();
        int i = 0;
        while (i < rowNbr) {
            if (!((String)this.table.getXMLValueAt(i, 2)).trim().equals("")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public class MyJTable
    extends XMLTable {
        MyJTable(DefaultTableModel model) {
            super(model);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            switch (column) {
                case 0: {
                    if (this.getValueAt(row, column) != null) {
                        return ExemptTable.this.addButton;
                    }
                }
                case 1: {
                    if (this.getValueAt(row, column) != null) {
                        return ExemptTable.this.delButton;
                    }
                }
                case 2: {
                    if (ExemptTable.this.subProduct.getExempt() != null) {
                        return ExemptTable.this.subProduct.getExempt();
                    }
                    return super.getCellEditor(row, column);
                }
            }
            return super.getCellEditor(row, column);
        }
    }
}

