/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Pdf.CreatePdf;
import Pdf.EditPdf;
import View.ScribaView;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Security;
import java.util.Locale;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Main {
    public static void main(String[] args) {
        try {
            FileOutputStream los = new FileOutputStream(new File("Scriba.log"));
            System.setOut(new PrintStream(los, true));
            System.setErr(new PrintStream(los, true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Preferences prefs = Preferences.userNodeForPackage(Main.class);
        String pref = prefs.get("Locale", Locale.getDefault().toString());
        Main.changeLocale(pref);
        Security.addProvider(new BouncyCastleProvider());
        Init.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScribaView object = new ScribaView();
                object.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                object.setVisible(true);
            }
        });
    }

    private static void changeLocale(String pref) {
        if (pref.equals("zh_CN")) {
            Locale.setDefault(new Locale("zh", "CN"));
            Font defaultFont = new Font("Arial Unicode Ms", 0, 12);
            Main.changeFont(defaultFont);
        } else {
            Locale.setDefault(new Locale("en", "US"));
            CreatePdf.pdfFont = new com.lowagie.text.Font(2, 10.0f);
            CreatePdf.pdfFontBold = new com.lowagie.text.Font(2, 10.0f, 1);
            EditPdf.pdfFont = new com.lowagie.text.Font(2, 10.0f);
            EditPdf.pdfFontBold = new com.lowagie.text.Font(2, 10.0f, 1);
        }
    }

    public static void changeFont(Font font) {
        UIManager.put("Button.font", font);
        UIManager.put("ToggleButton.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ColorChooser.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("MenuBar.font", font);
        UIManager.put("MenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("Menu.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("OptionPane.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("Frame.font", font);
        UIManager.put("ProgressBar.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("InternalFrame.titleFon", font);
        try {
            BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            CreatePdf.pdfFont = new com.lowagie.text.Font(bfChinese, 10.0f);
            CreatePdf.pdfFontBold = new com.lowagie.text.Font(bfChinese, 10.0f, 1);
            EditPdf.pdfFont = new com.lowagie.text.Font(bfChinese, 10.0f);
            EditPdf.pdfFontBold = new com.lowagie.text.Font(bfChinese, 10.0f, 1);
        }
        catch (DocumentException ex) {
            System.err.println((Object)ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }
}

