/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.MemUtil;
import java.awt.SystemColor;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class EmbossFilter
extends ImageFilter {
    public static final EmbossFilter theFilter = new EmbossFilter();
    private int width;
    private int height;
    private int[] pixels;
    private static final int DARK = SystemColor.menu.darker().getRGB();
    private static final int LIGHT = SystemColor.menu.brighter().getRGB();

    protected void deliverPixels() {
        this.consumer.setPixels(0, 0, this.width, this.height, ColorModel.getRGBdefault(), this.pixels, 0, this.width);
    }

    public void imageComplete(int n) {
        if (n == 2 || n == 3) {
            this.performEffect();
            this.deliverPixels();
        }
        super.imageComplete(n);
    }

    public void performEffect() {
        int n = this.width * this.height;
        int[] nArray = MemUtil.allocInt(n);
        boolean bl = (this.pixels[0] >>> 24 & 0xFF) == 255 || (this.pixels[n - 1] >>> 24 & 0xFF) == 255;
        int n2 = 0;
        while (n2 < this.height) {
            int n3 = n2 * this.width;
            int n4 = 0;
            while (n4 < this.width) {
                int n5 = n3 + n4;
                int n6 = this.pixels[n5];
                int n7 = n6 >>> 24 & 0xFF;
                int n8 = n6 >>> 8 & 0xFF;
                if (bl) {
                    nArray[n5] = n8 < 150 ? DARK : 0;
                } else if (n6 != DARK) {
                    if (n8 < 150) {
                        nArray[n5] = LIGHT;
                        int n9 = (n2 - 1) * this.width + (n4 - 1);
                        if (n9 > 0 && n9 < n) {
                            nArray[n9] = DARK;
                        }
                    } else {
                        nArray[n5] = 0;
                    }
                } else {
                    nArray[n5] = n6;
                }
                ++n4;
            }
            ++n2;
        }
        this.pixels = nArray;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.pixels = MemUtil.allocInt(n * n2);
        this.consumer.setDimensions(n, n2);
    }

    public void setHints(int n) {
        this.consumer.setHints(n & 0xFFFFFFFB);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < n4) {
            int n8 = (n2 + n7) * n3;
            int n9 = n7 * n6 + n5;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = byArray[n9 + n10] & 0xFF;
                this.pixels[n8 + n + n10] = colorModel.getRGB(n11);
                ++n10;
            }
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < n4) {
            int n8 = (n2 + n7) * n3;
            int n9 = n7 * n6 + n5;
            int n10 = 0;
            while (n10 < n3) {
                int n11 = nArray[n9 + n10];
                this.pixels[n8 + n + n10] = colorModel.getRGB(n11);
                ++n10;
            }
            ++n7;
        }
    }
}

