/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.notify;

import com.adobe.pe.notify.DependencyInspectorFriend;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import java.io.InterruptedIOException;
import java.util.Vector;

public abstract class VValue
implements DependencyInspectorFriend {
    private Requester computationRequester = null;
    private Vector oldNotifiers = null;
    private boolean settable = false;
    private Throwable exception = null;
    private boolean dirty = true;
    private boolean computing = false;
    private Vector requesters = new Vector();
    private Transaction ownerTransaction = null;
    private int ownerTransactionWriteCycle = 0;
    private boolean purging = false;

    synchronized void addRequester(Requester requester) throws WriteLockException {
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.requesters.size()) {
            Requester requester2 = (Requester)this.requesters.elementAt(n2);
            if (requester2 == requester) {
                bl = true;
            } else if (requester2.isInterrupted()) {
                if (n == -1) {
                    n = n2;
                } else {
                    this.requesters.removeElementAt(n2);
                    --n2;
                }
            }
            ++n2;
        }
        if (!bl) {
            if (n != -1) {
                this.requesters.setElementAt(requester, n);
            } else {
                this.requesters.addElement(requester);
            }
        }
    }

    private synchronized void becomeOwnedBy(Transaction transaction) throws WriteLockException {
        if (this.ownerTransaction != null && this.ownerTransaction != transaction && !this.ownerTransaction.isDoneChanging()) {
            throw new WriteLockException(this.ownerTransaction);
        }
        this.ownerTransaction = transaction;
        this.ownerTransactionWriteCycle = transaction.writeCycle;
    }

    protected abstract void compute(Requester var1) throws Exception;

    protected int countObservers(Vector vector) {
        int n = 0;
        if (!vector.contains(this)) {
            Vector vector2 = this.requesters;
            vector.addElement(this);
            ++n;
            if (vector2 != null) {
                int n2 = 0;
                while (n2 < vector2.size()) {
                    Requester requester = (Requester)vector2.elementAt(n2);
                    n += requester.countObservers(vector);
                    ++n2;
                }
            }
        }
        return n;
    }

    public int countObservers(boolean bl) {
        if (bl) {
            Vector vector = new Vector();
            return this.countObservers(vector);
        }
        return this.requesters.size();
    }

    public void finalize() {
        this.purgeDependencies(true, true);
    }

    public String getInfo(int n) {
        switch (n) {
            case 1: {
                String string = this.toString();
                int n2 = string.indexOf("@");
                string = n2 != -1 ? "<0x" + string.substring(n2 + 1) + "> " : "";
                String string2 = this.getClass().getName();
                int n3 = string2.lastIndexOf(46);
                if (n3 != -1) {
                    string2 = string2.substring(n3 + 1);
                }
                return String.valueOf(string) + string2;
            }
        }
        return null;
    }

    public Transaction getLastOwnerTransaction() {
        return this.ownerTransaction;
    }

    public Vector getNotifiers() {
        if (this.computationRequester == null) {
            return null;
        }
        return this.computationRequester.requestees;
    }

    public Vector getObservers() {
        return this.requesters;
    }

    public Transaction getOwnerTransaction() {
        if (this.ownerTransaction == null || this.ownerTransaction.isDoneChanging()) {
            return null;
        }
        return this.ownerTransaction;
    }

    protected void handleRequest(Requester requester) throws Exception {
        Object object;
        boolean bl = false;
        VValue vValue = this;
        synchronized (vValue) {
            object = this.getOwnerTransaction();
            if (object != null) {
                Transaction transaction;
                Transaction transaction2 = transaction = requester == null ? null : requester.getOwnerTransaction();
                if (transaction != null && transaction != object) {
                    throw new WriteLockException((Transaction)object);
                }
            }
            if (!this.settable) {
                while (this.computing || this.purging) {
                    this.wait();
                }
                if (this.isDirty()) {
                    bl = true;
                    this.computing = true;
                }
            }
        }
        if (bl) {
            try {
                try {
                    if (this.computationRequester == null) {
                        this.computationRequester = new ComputationRequester(this.getOwnerTransaction(), this.ownerTransactionWriteCycle);
                    }
                    this.compute(this.computationRequester);
                    this.setDirty(false);
                    this.exception = null;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof WriteLockException || throwable instanceof InterruptedException || throwable instanceof InterruptedIOException) {
                        if (this.computationRequester != null) {
                            this.computationRequester.interrupt(null);
                            this.computationRequester = null;
                        }
                        this.setDirty(true);
                        PEUtil.throwThrowable(throwable);
                    }
                    this.setDirty(false);
                    this.exception = throwable;
                }
                Object var4_8 = null;
                object = this;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                object = this;
                synchronized (object) {
                    this.computing = false;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (object) {
                this.computing = false;
                this.notifyAll();
            }
        }
        if (requester != null) {
            requester.addRequestee(this);
        }
        this.throwAssociatedException();
    }

    protected void initializeSettable() {
        this.settable = true;
    }

    public boolean isDirty() {
        return this.dirty && !this.settable;
    }

    private void mergeDependees() {
        Vector vector = this.computationRequester.requestees;
        if (this.oldNotifiers == null) {
            this.oldNotifiers = vector;
        } else {
            int n = 0;
            while (n < vector.size()) {
                VValue vValue = (VValue)vector.elementAt(n);
                if (!this.oldNotifiers.contains(vValue)) {
                    this.oldNotifiers.addElement(vValue);
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void prepareWrite(Transaction transaction) throws WriteLockException {
        Object object;
        this.becomeOwnedBy(transaction);
        if (this.computationRequester != null) {
            this.computationRequester.interrupt(null);
            this.mergeDependees();
            this.computationRequester = null;
        }
        while (true) {
            VValue vValue;
            block18: {
                vValue = this;
                synchronized (vValue) {
                    block17: {
                        if (this.requesters.size() == 0) {
                            Object var4_4 = null;
                            break block17;
                        }
                        object = (Requester)this.requesters.lastElement();
                        break block18;
                    }
                    break;
                }
            }
            if (object == transaction) {
                vValue = this;
                synchronized (vValue) {
                    this.requesters.removeElementAt(this.requesters.size() - 1);
                }
            }
            ((Requester)object).interrupt(transaction);
        }
        this.requesters.setSize(0);
        object = this;
        synchronized (object) {
            while (this.computing) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.setDirty(true);
    }

    protected void purge() {
    }

    protected void purgeDependencies(boolean bl, boolean bl2) {
        Object object;
        block16: {
            if (this.settable) {
                return;
            }
            VValue vValue = this;
            synchronized (vValue) {
                if (this.purging || this.computing && !bl2) {
                    Object var4_5 = null;
                    return;
                }
                this.purging = true;
                bl = bl && this.unobserved();
            }
            try {
                if (bl) {
                    this.purgeMemory(bl2);
                    if (this.computationRequester != null) {
                        this.computationRequester.releaseRequestees();
                        object = this.computationRequester.requestees;
                        int n = 0;
                        while (n < ((Vector)object).size()) {
                            VValue vValue2 = (VValue)((Vector)object).elementAt(n);
                            vValue2.purgeDependencies(bl, false);
                            ++n;
                        }
                        this.computationRequester = null;
                    }
                }
                if (this.oldNotifiers == null) break block16;
                int n = 0;
                while (n < this.oldNotifiers.size()) {
                    VValue vValue3 = (VValue)this.oldNotifiers.elementAt(n);
                    vValue3.purgeDependencies(bl, false);
                    ++n;
                }
                this.oldNotifiers = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                VValue vValue4 = this;
                synchronized (vValue4) {
                    this.purging = false;
                    this.notifyAll();
                }
                throw throwable;
            }
        }
        Object var4_6 = null;
        object = this;
        synchronized (object) {
            this.purging = false;
            this.notifyAll();
        }
    }

    protected void purgeMemory(boolean bl) {
        if (!this.computing || bl) {
            this.setDirty(true);
            this.purge();
        }
    }

    void removeRequester(Requester requester) {
        this.requesters.removeElement(requester);
    }

    void setDirty(boolean bl) {
        this.dirty = bl;
    }

    private void throwAssociatedException() throws Exception {
        if (this.exception != null) {
            PEUtil.throwThrowable(this.exception);
        }
    }

    protected boolean unobserved() {
        return this.requesters.size() == 0;
    }

    public class ComputationRequester
    extends Requester {
        private Transaction crOwnerTransaction;
        private int crOwnerTransactionWriteCycle;

        ComputationRequester(Transaction transaction, int n) {
            this.crOwnerTransaction = transaction;
            this.crOwnerTransactionWriteCycle = n;
        }

        protected int countObservers(Vector vector) {
            return VValue.this.countObservers(vector);
        }

        final Transaction getOwnerTransaction() {
            return this.crOwnerTransaction;
        }

        final int getOwnerTransactionWriteCycle() {
            return this.crOwnerTransactionWriteCycle;
        }

        public VValue getVValue() {
            return VValue.this;
        }

        protected void interruptThis(Transaction transaction) throws WriteLockException {
            if (transaction != null) {
                VValue.this.prepareWrite(transaction);
            }
        }
    }
}

