/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.pe.util.PEUtil;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public abstract class BaseDialog
extends Dialog
implements ActionListener,
WindowListener,
MouseListener,
KeyListener {
    protected Button ok;
    protected Frame frame;
    protected String actionCmd;
    protected boolean wasCanceled = false;
    private boolean restoreLocation = false;
    private boolean centerIt = true;

    public BaseDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.frame = frame;
        this.addWindowListener(this);
        this.ok = new Button(PEUtil.getString("General:OK"));
        this.ok.setActionCommand("General:OK");
        this.ok.addActionListener(this);
        this.ok.addKeyListener(this);
        ((Component)this).setBackground(SystemColor.menu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.actionCmd = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.ok) {
            this.ok();
        }
    }

    protected void cancel() {
        this.wasCanceled = true;
        this.setVisible(false);
    }

    public boolean didUserCancel() {
        return this.wasCanceled;
    }

    public String getActionCommand() {
        return this.actionCmd;
    }

    public Insets getInsets() {
        return new Insets(10 + super.getInsets().top, 10, 10 + super.getInsets().bottom, 10);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension.width, dimension2.width - 40);
        int n2 = Math.min(dimension.height, dimension2.height - 40);
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension.width, dimension2.width - 40);
        int n2 = Math.min(dimension.height, dimension2.height - 40);
        return new Dimension(n, n2);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.cancel();
        } else if (keyEvent.getSource() == this.ok && (n == 10 || n == 32)) {
            this.ok();
        }
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void ok() {
        this.wasCanceled = false;
        this.setVisible(false);
    }

    protected void restoreLocation() {
        this.restoreLocation = true;
    }

    public void setVisible(boolean bl) {
        if (this.frame == null || this.frame.getSize().width == 0) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension2.width / 2 - dimension.width / 2;
            int n2 = dimension2.height / 2 - dimension.height / 2;
            ((Component)this).setLocation(n, n2);
        } else if (bl && this.centerIt) {
            Point point = this.frame.getLocation();
            Dimension dimension = this.getSize();
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + this.frame.getSize().width / 2 - dimension.width / 2;
            int n3 = point.y + this.frame.getSize().height / 2 - dimension.height / 2;
            if (n < 0) {
                n = 0;
            } else if (n + dimension.width > dimension3.width) {
                n = dimension3.width - dimension.width;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 + dimension.height > dimension3.height) {
                n3 = dimension3.height - dimension.height;
            }
            ((Component)this).setLocation(n, n3);
            this.centerIt = this.restoreLocation ^ true;
        }
        super.setVisible(bl);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.ok.requestFocus();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.cancel();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

