/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.DeviceRGBColorModel;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.FastPixelGrabber;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.FontADV;
import com.adobe.acrobat.sidecar.FontException;
import com.adobe.acrobat.sidecar.GlyphCache;
import com.adobe.acrobat.sidecar.GraphicsUtils;
import com.adobe.acrobat.sidecar.ImageGraphics;
import com.adobe.acrobat.sidecar.MutableAffineTransform;
import com.adobe.acrobat.sidecar.PathStroker;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.sidecar.Stroke;
import com.adobe.acrobat.util.Log;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class TextCache
implements ImageObserver {
    static final boolean debug = false;
    Vector text = null;
    FloatRect bbox = null;
    boolean doingRenderText = false;
    Color color;
    int[] offScreenPix;
    int[] clipPix;
    ColorModel srcColorModel = null;
    Point origin;
    Point compositeOrigin = new Point(0, 0);
    int theCount = 0;
    Rectangle clipRect = null;
    private boolean busy = false;
    private boolean drawFinished;
    boolean isClip = false;
    boolean complexColor = false;
    static int count = 0;

    public TextCache(Color color) {
        this.color = color;
    }

    synchronized void addText(String string, double[] dArray, AffineTransform affineTransform, Color color, FloatRect floatRect, FontADV fontADV, int n, Stroke stroke) {
        if (this.text == null) {
            this.text = new Vector(200, 200);
            this.bbox = floatRect;
        } else {
            this.bbox = this.bbox.union(floatRect);
        }
        this.text.addElement(string);
        this.text.addElement(dArray);
        this.text.addElement(affineTransform);
        this.text.addElement(fontADV);
        this.text.addElement(color);
        this.text.addElement(new Integer(n));
        if (stroke != null) {
            this.text.addElement(stroke);
        }
        this.isClip = (n & 4) != 0;
    }

    int countCharsTillNextSpace(String string, int n) {
        int n2 = 0;
        if (string.length() > 0) {
            while (n < string.length() && string.charAt(n) != ' ') {
                ++n2;
                ++n;
            }
        }
        return n2;
    }

    void fillBBox(Graphics graphics, Rectangle rectangle, Color color, int n) {
        graphics.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width, rectangle.height);
    }

    public FloatRect getBBox() {
        return this.bbox;
    }

    private synchronized void getTextCache() throws InterruptedException {
        while (this.busy) {
            this.wait();
        }
        this.busy = true;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        int n6 = 240;
        if ((n & n6) != 0) {
            this.drawFinished = true;
            this.notifyAll();
        }
        return this.drawFinished ^ true;
    }

    public boolean isClip() {
        return this.isClip;
    }

    private void makeTextImage(ImageGraphics imageGraphics, boolean bl) throws FontException {
        Color color = null;
        Stroke stroke = null;
        int n = 0;
        while (n < this.text.size() && !Thread.interrupted()) {
            String string = (String)this.text.elementAt(n++);
            double[] dArray = (double[])this.text.elementAt(n++);
            MutableAffineTransform mutableAffineTransform = new MutableAffineTransform((AffineTransform)this.text.elementAt(n++));
            FontADV fontADV = (FontADV)this.text.elementAt(n++);
            color = (Color)this.text.elementAt(n++);
            int n2 = (Integer)this.text.elementAt(n++);
            boolean bl2 = fontADV.isCIDFont();
            double d = mutableAffineTransform.getx();
            double d2 = mutableAffineTransform.gety();
            GlyphCache glyphCache = fontADV.getGlyphCache();
            try {
                int n3;
                boolean bl3;
                if (n < this.text.size() && this.text.elementAt(n) instanceof Stroke) {
                    stroke = (Stroke)this.text.elementAt(n++);
                    BezierPath bezierPath = null;
                    glyphCache.setPathStroker(new PathStroker(stroke, bezierPath, AffineTransform.getIdentityMatrix()));
                } else {
                    stroke = null;
                    glyphCache.setPathStroker(null);
                }
                if (this.isClip || this.complexColor) {
                    imageGraphics.setColor(Color.white);
                } else {
                    imageGraphics.setColor(color);
                }
                int n4 = fontADV.getwMode();
                int n5 = bl2 ? 4 : 1;
                boolean bl4 = bl3 = Math.abs(mutableAffineTransform.geta()) < (double)GlyphCache.getHorizontalSpacingCrossover() && Math.abs(mutableAffineTransform.getd()) < (double)GlyphCache.getHorizontalSpacingCrossover();
                if (bl3 && mutableAffineTransform.getb() == 0.0 && mutableAffineTransform.getc() == 0.0) {
                    n3 = this.countCharsTillNextSpace(string, 0);
                    double d3 = d = (double)((int)(d + 0.5));
                    int n6 = 0;
                    while (n6 < string.length()) {
                        double d4;
                        if (bl2) {
                            double d5 = dArray[2];
                            d4 = dArray[3];
                            mutableAffineTransform.preTranslateInPlace(d5 /= 1000.0, d4 /= 1000.0);
                        }
                        int n7 = glyphCache.produceGlyph(imageGraphics, string.charAt(n6), mutableAffineTransform, this.clipRect, true, bl);
                        if (n6 < string.length() - 1) {
                            d3 = mutableAffineTransform.getx();
                            if (!bl3 || bl2 || string.charAt(n6) == ' ' || n3 > 10) {
                                mutableAffineTransform.setx(d);
                                mutableAffineTransform.sety(d2);
                                if (bl2) {
                                    int n8 = n6 * 4;
                                    d4 = dArray[n8];
                                    double d6 = -dArray[n8 + 1];
                                    mutableAffineTransform.preTranslateInPlace(d4 /= 1000.0, d6 /= 1000.0);
                                    mutableAffineTransform.setx((int)(mutableAffineTransform.getx() + 0.5));
                                    mutableAffineTransform.sety((int)(mutableAffineTransform.gety() + 0.5));
                                } else {
                                    mutableAffineTransform.preTranslateInPlace(n4 == 0 ? dArray[n6] / 1000.0 : 0.0, n4 != 0 ? dArray[n6] / 1000.0 : 0.0);
                                    mutableAffineTransform.setx((int)(mutableAffineTransform.getx() + 0.5));
                                }
                                if (bl3) {
                                    n3 = this.countCharsTillNextSpace(string, n6 + 1);
                                }
                            } else {
                                double d7 = n6 == 0 ? mutableAffineTransform.geta() * dArray[n6] / 1000.0 * GlyphCache.getHorizontalSpacing() : mutableAffineTransform.geta() * (dArray[n6] - dArray[n6 - 1]) / 1000.0 * GlyphCache.getHorizontalSpacing();
                                int n9 = (int)(d7 + 0.5);
                                mutableAffineTransform.setx(mutableAffineTransform.getx() + (double)n9);
                            }
                        }
                        ++n6;
                    }
                } else {
                    n3 = 0;
                    while (n3 < string.length()) {
                        if (bl2) {
                            double d8 = dArray[2];
                            double d9 = dArray[3];
                            mutableAffineTransform.preTranslateInPlace(d8 /= 1000.0, d9 /= 1000.0);
                        }
                        glyphCache.produceGlyph(imageGraphics, string.charAt(n3), mutableAffineTransform, this.clipRect, false, bl);
                        if (n3 < string.length() - 1) {
                            mutableAffineTransform.setx(d);
                            mutableAffineTransform.sety(d2);
                            if (bl2) {
                                int n10 = n3 * 4;
                                double d10 = dArray[n10];
                                double d11 = -dArray[n10 + 1];
                                mutableAffineTransform.preTranslateInPlace(d10 /= 1000.0, d11 /= 1000.0);
                            } else {
                                mutableAffineTransform.preTranslateInPlace(n4 == 0 ? dArray[n3] / 1000.0 : 0.0, n4 != 0 ? dArray[n3] / 1000.0 : 0.0);
                            }
                        }
                        ++n3;
                    }
                }
                GlyphCache.debugEnd();
                mutableAffineTransform.setx(d);
                mutableAffineTransform.sety(d2);
            }
            finally {
                Object var18_15 = null;
                fontADV.releaseGlyphCache();
            }
        }
    }

    private synchronized void releaseTextCache() {
        this.busy = false;
        this.notifyAll();
    }

    public synchronized void renderText(AWTGraphics aWTGraphics) throws InterruptedException, FontException {
        Graphics graphics = aWTGraphics.getGraphics();
        Image image = aWTGraphics.getImage();
        ClipShape clipShape = aWTGraphics.getClipShape();
        ColorValue colorValue = aWTGraphics.getFillColor();
        SidecarImage sidecarImage = null;
        FastPixelGrabber fastPixelGrabber = null;
        if (this.text == null || this.text.size() < 1 || this.doingRenderText) {
            return;
        }
        try {
            try {
                Object object;
                this.getTextCache();
                this.doingRenderText = true;
                boolean bl = false;
                this.complexColor = colorValue.paintIsComplex();
                boolean bl2 = clipShape != null && !clipShape.isRectangular();
                bl2 = bl2 || image == null;
                Rectangle rectangle = this.bbox.toEnclosingRect();
                this.origin = aWTGraphics.getOrigin();
                this.clipRect = rectangle.intersection(clipShape.getClipBounds());
                Rectangle rectangle2 = aWTGraphics.getClipBounds();
                if (rectangle2 != null) {
                    this.clipRect = this.clipRect.intersection(rectangle2);
                }
                if (this.clipRect.isEmpty()) {
                    this.doingRenderText = false;
                    Object var13_13 = null;
                    if (fastPixelGrabber != null) {
                        fastPixelGrabber.doFinalize();
                    }
                    this.releaseTextCache();
                    return;
                }
                this.compositeOrigin.x = -this.clipRect.x;
                this.compositeOrigin.y = -this.clipRect.y;
                ImageGraphics imageGraphics = null;
                if (this.isClip || this.complexColor) {
                    sidecarImage = (SidecarImage)GraphicsUtils.createClipImage(this.clipRect.width, this.clipRect.height);
                    sidecarImage.setOrigin(this.clipRect.x, this.clipRect.y);
                    imageGraphics = (ImageGraphics)sidecarImage.getGraphics();
                } else if (bl2) {
                    sidecarImage = (SidecarImage)GraphicsUtils.createImage(this.clipRect.width, this.clipRect.height);
                    sidecarImage.setOrigin(this.clipRect.x, this.clipRect.y);
                    imageGraphics = (ImageGraphics)sidecarImage.getGraphics();
                } else if (image instanceof SidecarImage) {
                    sidecarImage = (SidecarImage)image;
                    imageGraphics = (ImageGraphics)sidecarImage.getGraphics();
                    object = ((ImageGraphics)graphics).getOrigin();
                    imageGraphics.translate(((Point)object).x, ((Point)object).y);
                    imageGraphics.setClip(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
                } else {
                    object = GraphicsUtils.subImage(image, this.clipRect.x + this.origin.x, this.clipRect.y + this.origin.y, this.clipRect.width, this.clipRect.height);
                    sidecarImage = new SidecarImage(((Image)object).getSource(), (ColorModel)DeviceRGBColorModel.DefaultColorModel);
                    sidecarImage.setOrigin(this.clipRect.x, this.clipRect.y);
                    imageGraphics = (ImageGraphics)sidecarImage.getGraphics();
                }
                this.makeTextImage(imageGraphics, aWTGraphics.getPrinting());
                if (this.isClip || this.complexColor) {
                    if (this.isClip) {
                        clipShape.setClip(sidecarImage);
                    } else {
                        object = (ClipShape)clipShape.clone();
                        ((ClipShape)object).setClip(sidecarImage);
                        try {
                            SidecarImage sidecarImage2 = colorValue.patternImage(aWTGraphics.getInitialTransform(), this.clipRect);
                            aWTGraphics.drawImage(sidecarImage2, null, (ClipShape)object, false);
                        }
                        catch (Exception exception) {}
                    }
                } else if (bl2) {
                    aWTGraphics.drawImage(sidecarImage, null, clipShape, false);
                } else if (!(image instanceof SidecarImage)) {
                    object = sidecarImage.getOrigin();
                    GraphicsUtils.drawToNative(graphics, sidecarImage, ((Point)object).x, ((Point)object).y);
                }
                this.text = null;
                this.bbox = null;
                this.doingRenderText = false;
            }
            catch (Exception exception) {
                Log.logStackTrace(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (fastPixelGrabber != null) {
                fastPixelGrabber.doFinalize();
            }
            this.releaseTextCache();
            throw throwable;
        }
        Object var13_14 = null;
        if (fastPixelGrabber != null) {
            fastPixelGrabber.doFinalize();
        }
        this.releaseTextCache();
    }
}

