/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.PolygonADV;
import com.adobe.util.MemUtil;
import java.awt.Graphics;

public class MultiPath
implements Cloneable {
    private Store store;
    private int numEdges;
    private int[] LRstack = new int[32];
    private int numPath;
    private FloatRect bounds;
    private int[] polyX = new int[4];
    private int[] polyY = new int[4];

    public MultiPath() {
        this.store = new Store();
        this.reset();
    }

    public MultiPath(ComplexPolygon complexPolygon, int n) {
        this();
        this.addPath(complexPolygon, n);
    }

    public MultiPath(FloatRect floatRect) {
        this();
        this.addPath(floatRect);
    }

    public MultiPath(PolygonADV polygonADV, int n) {
        this();
        this.addPath(polygonADV, n);
    }

    private void addCxPoly(ComplexPolygon complexPolygon) {
        if (complexPolygon != null) {
            int n = complexPolygon.size();
            int n2 = 4 * n;
            int n3 = 0;
            while (n3 < n) {
                n2 += ((PolygonADV)complexPolygon.elementAt((int)n3)).npoints;
                ++n3;
            }
            this.store.moreEdges(this.numEdges + n2);
            int n4 = 0;
            while (n4 < n) {
                this.addPoly((PolygonADV)complexPolygon.elementAt(n4));
                ++n4;
            }
        }
    }

    private void addEdge(double d, double d2, double d3, double d4) {
        this.store.moreEdges(this.numEdges + 2);
        if (d2 != d4) {
            double d5 = this.bounds.getyMin();
            double d6 = this.bounds.getyMax();
            if (d2 < d6 && d4 >= d5 || d4 < d6 && d2 >= d5) {
                this.newEdge(d, d2, d3, d4, this.numPath - 1);
            }
        } else if (d < d3) {
            if (d2 - Math.floor(d2) <= 0.5) {
                this.addEdge(d, d2 - (double)0.001f, d, d2 + (double)0.002f);
                this.addEdge(d3, d2 + (double)0.002f, d3, d2 - (double)0.001f);
            } else if (d > d3) {
                this.addEdge(d, d2 + (double)0.001f, d, d2 - (double)0.002f);
                this.addEdge(d3, d2 - (double)0.002f, d3, d2 + (double)0.001f);
            }
        }
    }

    public void addPath(ComplexPolygon complexPolygon, int n) {
        if (complexPolygon != null) {
            FloatRect floatRect = complexPolygon.getBoundingBox();
            FloatRect floatRect2 = this.bounds = this.bounds == null ? floatRect : this.bounds.intersect(floatRect);
            if (!this.bounds.isEmpty()) {
                this.newPath(n);
                this.addCxPoly(complexPolygon);
            }
        }
    }

    public void addPath(FloatRect floatRect) {
        if (!(floatRect == null || this.bounds != null && this.bounds.inFloatRect(floatRect))) {
            FloatRect floatRect2 = this.bounds = this.bounds == null ? floatRect : this.bounds.intersect(floatRect);
            if (!this.bounds.isEmpty()) {
                this.store.moreEdges(this.numEdges + 2 + 2);
                this.newPath(1);
                this.addEdge(floatRect.getxMin(), floatRect.getyMin(), floatRect.getxMin(), floatRect.getyMax());
                this.addEdge(floatRect.getxMax(), floatRect.getyMax(), floatRect.getxMax(), floatRect.getyMin());
            }
        }
    }

    public void addPath(MultiPath multiPath) {
        if (multiPath != null && multiPath != this && !multiPath.isNull()) {
            int n = this.numPath;
            int n2 = multiPath.numPath;
            this.bounds = this.bounds == null ? multiPath.bounds : this.bounds.intersect(multiPath.bounds);
            int n3 = 0;
            while (n3 < n2) {
                this.newPath(multiPath.store.windingType[n3]);
                ++n3;
            }
            this.store.moreEdges(this.numEdges + multiPath.numEdges);
            System.arraycopy(multiPath.store.yMin, 1, this.store.yMin, this.numEdges, multiPath.numEdges - 1);
            System.arraycopy(multiPath.store.yMax, 1, this.store.yMax, this.numEdges, multiPath.numEdges - 1);
            System.arraycopy(multiPath.store.x0, 1, this.store.x0, this.numEdges, multiPath.numEdges - 1);
            System.arraycopy(multiPath.store.slope, 1, this.store.slope, this.numEdges, multiPath.numEdges - 1);
            System.arraycopy(multiPath.store.winding, 1, this.store.winding, this.numEdges, multiPath.numEdges - 1);
            if (n == 0) {
                System.arraycopy(multiPath.store.pathnum, 1, this.store.pathnum, this.numEdges, multiPath.numEdges - 1);
            } else {
                n3 = 1;
                while (n3 < multiPath.numEdges) {
                    this.store.pathnum[this.numEdges + n3 - 1] = multiPath.store.pathnum[n3] + n;
                    ++n3;
                }
            }
            this.numEdges += multiPath.numEdges - 1;
        }
    }

    public void addPath(PolygonADV polygonADV, int n) {
        if (polygonADV != null) {
            FloatRect floatRect = polygonADV.getBoundingBox();
            FloatRect floatRect2 = this.bounds = this.bounds == null ? floatRect : this.bounds.intersect(floatRect);
            if (!this.bounds.isEmpty()) {
                this.newPath(n);
                this.addPoly(polygonADV);
            }
        }
    }

    private void addPoly(PolygonADV polygonADV) {
        if (polygonADV != null) {
            int n = polygonADV.npoints;
            if (n < 2) {
                return;
            }
            this.store.moreEdges(this.numEdges + n + 4);
            int n2 = 1;
            while (n2 < n) {
                this.addEdge(polygonADV.xpoints[n2 - 1], polygonADV.ypoints[n2 - 1], polygonADV.xpoints[n2], polygonADV.ypoints[n2]);
                ++n2;
            }
            if (polygonADV.xpoints[n - 1] != polygonADV.xpoints[0] || polygonADV.ypoints[n - 1] != polygonADV.ypoints[0]) {
                this.addEdge(polygonADV.xpoints[n - 1], polygonADV.ypoints[n - 1], polygonADV.xpoints[0], polygonADV.ypoints[0]);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void fillPath(Graphics graphics, boolean bl) {
        double[] dArray = this.store.yMin;
        double[] dArray2 = this.store.yMax;
        double[] dArray3 = this.store.x0;
        double[] dArray4 = this.store.slope;
        double[] dArray5 = this.store.val0;
        double[] dArray6 = this.store.val1;
        int[] nArray = this.store.winding;
        int[] nArray2 = this.store.pathnum;
        int[] nArray3 = this.store.windingType;
        int[] nArray4 = new int[this.numPath];
        boolean[] blArray = new boolean[this.numPath];
        bl = true;
        if (this.bounds.isEmpty()) {
            return;
        }
        double d = this.bounds.getyMin();
        double d2 = this.bounds.getyMax();
        int n = 1;
        int n2 = 1;
        int n3 = this.numEdges - 1;
        this.sortY(n2, n3);
        while (d < d2) {
            int n4;
            double d3;
            int n5 = n;
            while (n5 <= n3 && dArray[n5] <= d) {
                ++n5;
            }
            double d4 = d2;
            if (n5 <= n3 && d4 > (d3 = dArray[n5])) {
                d4 = d3;
            }
            n = n5;
            while (n2 < n && dArray2[n2] <= d) {
                ++n2;
            }
            if (n2 < n) {
                d3 = dArray2[n2];
                if (d4 > d3) {
                    d4 = d3;
                }
                n5 = n2 + 1;
                while (n5 < n) {
                    d3 = dArray2[n5];
                    if (d3 <= d) {
                        d3 = dArray[n5];
                        dArray[n5] = dArray[n2];
                        dArray[n2] = d3;
                        d3 = dArray2[n5];
                        dArray2[n5] = dArray2[n2];
                        dArray2[n2] = d3;
                        d3 = dArray3[n5];
                        dArray3[n5] = dArray3[n2];
                        dArray3[n2] = d3;
                        d3 = dArray4[n5];
                        dArray4[n5] = dArray4[n2];
                        dArray4[n2] = d3;
                        n4 = nArray[n5];
                        nArray[n5] = nArray[n2];
                        nArray[n2] = n4;
                        n4 = nArray2[n5];
                        nArray2[n5] = nArray2[n2];
                        nArray2[n2] = n4;
                        ++n2;
                    } else if (d4 > d3) {
                        d4 = d3;
                    }
                    ++n5;
                }
            } else {
                d = d4;
                continue;
            }
            n4 = n2;
            while (n4 < n) {
                dArray5[n4] = dArray3[n4] + (d - dArray[n4]) * dArray4[n4];
                ++n4;
            }
            dArray5[n2 - 1] = Double.NEGATIVE_INFINITY;
            dArray5[n] = Double.POSITIVE_INFINITY;
            boolean bl2 = true;
            boolean bl3 = true;
            while (bl2) {
                this.sortX(n2, n - 1);
                d3 = d4 - d;
                n4 = n2;
                while (n4 < n) {
                    dArray6[n4] = dArray5[n4] + d3 * dArray4[n4];
                    ++n4;
                }
                bl2 = false;
                bl3 = false;
                n5 = n2;
                while (n5 < n - 1) {
                    double d5;
                    if (dArray6[n5] > dArray6[n5 + 1] && (d5 = d - (dArray5[n5 + 1] - dArray5[n5]) / (dArray4[n5 + 1] - dArray4[n5])) < d4) {
                        if (d5 <= d) {
                            double d6 = (dArray5[n5] + dArray5[n5 + 1]) / 2.0;
                            dArray5[n5 + 1] = d6;
                            dArray5[n5] = d6;
                            bl2 = true;
                        } else {
                            d4 = d5;
                            bl3 = true;
                        }
                    }
                    ++n5;
                }
            }
            if (bl3) {
                d3 = d4 - d;
                n4 = n2;
                while (n4 < n) {
                    dArray6[n4] = dArray5[n4] + d3 * dArray4[n4];
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < this.numPath) {
                nArray4[n4] = 0;
                blArray[n4] = false;
                ++n4;
            }
            boolean bl4 = false;
            boolean bl5 = false;
            int n6 = 0;
            int n7 = 0;
            int n8 = (int)Math.floor(d);
            int n9 = (int)Math.ceil(d4);
            n5 = n2;
            while (n5 < n) {
                int n10 = nArray2[n5];
                if (nArray3[n10] == 1) {
                    int n11 = n10;
                    nArray4[n11] = nArray4[n11] + nArray[n5];
                } else {
                    nArray4[n10] = 1 - nArray4[n10];
                }
                if (nArray4[n10] != 0) {
                    if (!blArray[n10]) {
                        blArray[n10] = true;
                        bl4 = blArray[0];
                        n4 = 1;
                        while (bl4 && n4 < this.numPath) {
                            bl4 = blArray[n4];
                            ++n4;
                        }
                    }
                } else {
                    blArray[n10] = false;
                    bl4 = false;
                }
                if (!bl5 && bl4) {
                    n6 = n5;
                } else if (bl5 && !bl4) {
                    n7 = n5;
                    if (!bl) {
                        this.polyX[0] = (int)Math.floor(dArray5[n6]);
                        this.polyY[0] = n8;
                        this.polyX[1] = (int)Math.ceil(dArray5[n7]);
                        this.polyY[1] = n8;
                        this.polyX[2] = (int)Math.ceil(dArray6[n7]);
                        this.polyY[2] = n9;
                        this.polyX[3] = (int)Math.floor(dArray6[n6]);
                        this.polyY[3] = n9;
                        graphics.fillPolygon(this.polyX, this.polyY, 4);
                    } else {
                        double d7 = dArray4[n6];
                        double d8 = dArray4[n7];
                        double d9 = dArray5[n6];
                        double d10 = dArray5[n7];
                        int n12 = n8;
                        double d11 = n12 + 1;
                        if (d11 > d4) {
                            d11 = d4;
                        }
                        double d12 = d11 - d;
                        double d13 = d9 + d7 * d12;
                        double d14 = d10 + d8 * d12;
                        if (d9 > d13) {
                            d9 = d13;
                        }
                        if (d10 < d14) {
                            d10 = d14;
                        }
                        int n13 = (int)Math.floor(d9);
                        int n14 = (int)Math.ceil(d10);
                        int n15 = n14 - n13;
                        int n16 = n13;
                        int n17 = n12;
                        int n18 = n15;
                        int n19 = 1;
                        while (d11 < d4) {
                            d9 = d13;
                            d10 = d14;
                            if ((d11 += 1.0) > d4) {
                                d12 = d4 - d11 + 1.0;
                                d13 += d7 * d12;
                                d14 += d8 * d12;
                                d11 = d4;
                            } else {
                                d13 += d7;
                                d14 += d8;
                            }
                            if (d9 > d13) {
                                d9 = d13;
                            }
                            if (d10 < d14) {
                                d10 = d14;
                            }
                            n13 = (int)Math.floor(d9);
                            n14 = (int)Math.ceil(d10);
                            n15 = n14 - n13;
                            ++n12;
                            if (n13 == n16 && n15 == n18) {
                                ++n19;
                                continue;
                            }
                            graphics.fillRect(n16, n17, n18, n19);
                            n16 = n13;
                            n17 = n12;
                            n18 = n15;
                            n19 = 1;
                        }
                        graphics.fillRect(n16, n17, n18, n19);
                    }
                }
                bl5 = bl4;
                ++n5;
            }
            d = d4;
        }
        this.sortPathnum();
    }

    public FloatRect getBoundingBox() {
        return this.bounds;
    }

    public boolean isNull() {
        return this.numPath == 0;
    }

    private void newEdge(double d, double d2, double d3, double d4, int n) {
        this.store.moreEdges(this.numEdges + 1);
        if (d2 < d4) {
            this.store.yMin[this.numEdges] = d2;
            this.store.yMax[this.numEdges] = d4;
            this.store.x0[this.numEdges] = d;
            this.store.slope[this.numEdges] = (d3 - d) / (d4 - d2);
            this.store.winding[this.numEdges] = 1;
        } else if (d2 > d4) {
            this.store.yMin[this.numEdges] = d4;
            this.store.yMax[this.numEdges] = d2;
            this.store.x0[this.numEdges] = d3;
            this.store.slope[this.numEdges] = (d - d3) / (d2 - d4);
            this.store.winding[this.numEdges] = -1;
        } else {
            this.store.yMin[this.numEdges] = this.store.yMax[this.numEdges] = d2;
            this.store.slope[this.numEdges] = 0.0;
            this.store.winding[this.numEdges] = 0;
        }
        this.store.pathnum[this.numEdges++] = n;
    }

    private void newPath(int n) {
        this.store.moreWinding(this.numPath + 1);
        this.store.windingType[this.numPath++] = n;
    }

    public void reset() {
        this.numPath = 0;
        this.numEdges = 1;
        this.bounds = null;
    }

    /*
     * Unable to fully structure code
     */
    private void sortPathnum() {
        var1_1 = this.store.yMin;
        var2_2 = this.store.yMax;
        var3_3 = this.store.x0;
        var4_4 = this.store.slope;
        var5_5 = this.store.winding;
        var6_6 = this.store.pathnum;
        var7_7 = this.store.LRstack;
        var8_8 = 1;
        var10_9 = 0;
        while (var10_9 < this.numPath - 1) {
            var9_10 = this.numEdges - 1;
            ** GOTO lbl40
            {
                ++var8_8;
                do {
                    if (var6_6[var8_8] == var10_9) continue block1;
                    while (var6_6[var9_10] != var10_9) {
                        --var9_10;
                    }
                    if (var8_8 >= var9_10) continue;
                    var11_11 = var1_1[var9_10];
                    var1_1[var9_10] = var1_1[var8_8];
                    var1_1[var8_8] = var11_11;
                    var11_11 = var2_2[var9_10];
                    var2_2[var9_10] = var2_2[var8_8];
                    var2_2[var8_8] = var11_11;
                    var11_11 = var3_3[var9_10];
                    var3_3[var9_10] = var3_3[var8_8];
                    var3_3[var8_8] = var11_11;
                    var11_11 = var4_4[var9_10];
                    var4_4[var9_10] = var4_4[var8_8];
                    var4_4[var8_8] = var11_11;
                    var13_12 = var5_5[var9_10];
                    var5_5[var9_10] = var5_5[var8_8];
                    var5_5[var8_8] = var13_12;
                    var13_12 = var6_6[var9_10];
                    var6_6[var9_10] = var6_6[var8_8];
                    var6_6[var8_8] = var13_12;
                    ++var8_8;
                    --var9_10;
lbl40:
                    // 3 sources

                } while (var8_8 < var9_10);
            }
            if (var6_6[var8_8] == var10_9) {
                ++var8_8;
            }
            ++var10_9;
        }
    }

    private void sortX(int n, int n2) {
        double[] dArray = this.store.yMin;
        double[] dArray2 = this.store.yMax;
        double[] dArray3 = this.store.x0;
        double[] dArray4 = this.store.slope;
        double[] dArray5 = this.store.val0;
        int[] nArray = this.store.winding;
        int[] nArray2 = this.store.pathnum;
        int[] nArray3 = this.store.LRstack;
        int n3 = 0;
        while (n < n2 || n3 != 0) {
            double d;
            int n4;
            int n5;
            int n6;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            int n7;
            if (n2 - n < 9) {
                n7 = n + 1;
                while (n7 <= n2) {
                    d8 = dArray[n7];
                    d7 = dArray2[n7];
                    d6 = dArray3[n7];
                    d4 = d5 = dArray4[n7];
                    d2 = d3 = dArray5[n7];
                    n6 = nArray[n7];
                    n5 = nArray2[n7];
                    n4 = n7 - 1;
                    d = dArray5[n4];
                    while (d > d2 || d == d2 && dArray4[n4] > d4) {
                        dArray[n4 + 1] = dArray[n4];
                        dArray2[n4 + 1] = dArray2[n4];
                        dArray3[n4 + 1] = dArray3[n4];
                        dArray4[n4 + 1] = dArray4[n4];
                        dArray5[n4 + 1] = d;
                        nArray[n4 + 1] = nArray[n4];
                        nArray2[n4 + 1] = nArray2[n4];
                        d = dArray5[--n4];
                    }
                    if (++n4 != n7) {
                        dArray[n4] = d8;
                        dArray2[n4] = d7;
                        dArray3[n4] = d6;
                        dArray4[n4] = d5;
                        dArray5[n4] = d3;
                        nArray[n4] = n6;
                        nArray2[n4] = n5;
                    }
                    ++n7;
                }
                if (n3 == 0) break;
                n2 = nArray3[--n3];
                n = nArray3[--n3];
                continue;
            }
            n4 = n;
            n7 = n2;
            d8 = dArray[n];
            d7 = dArray2[n];
            d6 = dArray3[n];
            d4 = d5 = dArray4[n];
            d2 = d3 = dArray5[n];
            n6 = nArray[n4];
            n5 = nArray2[n4];
            while (true) {
                d = dArray5[n7];
                while (d2 < d || d2 == d && d4 < dArray4[n7]) {
                    d = dArray5[--n7];
                }
                if (n7 <= n4) {
                    if (n == n4) break;
                    dArray[n4] = d8;
                    dArray2[n4] = d7;
                    dArray3[n4] = d6;
                    dArray4[n4] = d5;
                    dArray5[n4] = d3;
                    nArray[n4] = n6;
                    nArray2[n4] = n5;
                    break;
                }
                dArray[n4] = dArray[n7];
                dArray2[n4] = dArray2[n7];
                dArray3[n4] = dArray3[n7];
                dArray4[n4] = dArray4[n7];
                dArray5[n4] = dArray5[n7];
                nArray[n4] = nArray[n7];
                nArray2[n4] = nArray2[n7];
                d = dArray5[++n4];
                while (d < d2 || d == d2 && dArray4[n4] < d4) {
                    d = dArray5[++n4];
                }
                if (n7 <= n4) {
                    if (n == n7) break;
                    dArray[n7] = d8;
                    dArray2[n7] = d7;
                    dArray3[n7] = d6;
                    dArray4[n7] = d5;
                    dArray5[n7] = d3;
                    nArray[n7] = n6;
                    nArray2[n7] = n5;
                    n4 = n7;
                    break;
                }
                dArray[n7] = dArray[n4];
                dArray2[n7] = dArray2[n4];
                dArray3[n7] = dArray3[n4];
                dArray4[n7] = dArray4[n4];
                dArray5[n7] = dArray5[n4];
                nArray[n7] = nArray[n4];
                nArray2[n7] = nArray2[n4];
                --n7;
            }
            if (n2 - n4 >= n4 - n) {
                nArray3[n3++] = n4 + 1;
                nArray3[n3++] = n2;
                n2 = n4 - 1;
                continue;
            }
            nArray3[n3++] = n;
            nArray3[n3++] = n4 - 1;
            n = n4 + 1;
        }
    }

    private void sortY(int n, int n2) {
        this.store.moreEdges(this.numEdges + 1);
        double[] dArray = this.store.yMin;
        double[] dArray2 = this.store.yMax;
        double[] dArray3 = this.store.x0;
        double[] dArray4 = this.store.slope;
        int[] nArray = this.store.winding;
        int[] nArray2 = this.store.pathnum;
        int[] nArray3 = this.store.LRstack;
        int n3 = 0;
        dArray[n - 1] = Double.NEGATIVE_INFINITY;
        dArray[n2 + 1] = Double.POSITIVE_INFINITY;
        while (n < n2 || n3 != 0) {
            int n4;
            int n5;
            int n6;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            int n7;
            if (n2 - n < 9) {
                n7 = n + 1;
                while (n7 <= n2) {
                    d4 = d5 = dArray[n7];
                    d3 = dArray2[n7];
                    d2 = dArray3[n7];
                    d = dArray4[n7];
                    n6 = nArray[n7];
                    n5 = nArray2[n7];
                    n4 = n7 - 1;
                    double d6 = dArray[n4];
                    while (d6 > d4) {
                        dArray[n4 + 1] = d6;
                        dArray2[n4 + 1] = dArray2[n4];
                        dArray3[n4 + 1] = dArray3[n4];
                        dArray4[n4 + 1] = dArray4[n4];
                        nArray[n4 + 1] = nArray[n4];
                        nArray2[n4 + 1] = nArray2[n4];
                        d6 = dArray[--n4];
                    }
                    if (++n4 != n7) {
                        dArray[n4] = d5;
                        dArray2[n4] = d3;
                        dArray3[n4] = d2;
                        dArray4[n4] = d;
                        nArray[n4] = n6;
                        nArray2[n4] = n5;
                    }
                    ++n7;
                }
                if (n3 == 0) break;
                n2 = nArray3[--n3];
                n = nArray3[--n3];
                continue;
            }
            n4 = n;
            n7 = n2;
            d4 = d5 = dArray[n4];
            d3 = dArray2[n4];
            d2 = dArray3[n4];
            d = dArray4[n4];
            n6 = nArray[n4];
            n5 = nArray2[n4];
            while (true) {
                if (d4 < dArray[n7]) {
                    --n7;
                    continue;
                }
                if (n7 <= n4) {
                    if (n == n4) break;
                    dArray[n4] = d5;
                    dArray2[n4] = d3;
                    dArray3[n4] = d2;
                    dArray4[n4] = d;
                    nArray[n4] = n6;
                    nArray2[n4] = n5;
                    break;
                }
                dArray[n4] = dArray[n7];
                dArray2[n4] = dArray2[n7];
                dArray3[n4] = dArray3[n7];
                dArray4[n4] = dArray4[n7];
                nArray[n4] = nArray[n7];
                nArray2[n4] = nArray2[n7];
                ++n4;
                while (dArray[n4] < d4) {
                    ++n4;
                }
                if (n7 <= n4) {
                    if (n == n7) break;
                    dArray[n7] = d5;
                    dArray2[n7] = d3;
                    dArray3[n7] = d2;
                    dArray4[n7] = d;
                    nArray[n7] = n6;
                    nArray2[n7] = n5;
                    n4 = n7;
                    break;
                }
                dArray[n7] = dArray[n4];
                dArray2[n7] = dArray2[n4];
                dArray3[n7] = dArray3[n4];
                dArray4[n7] = dArray4[n4];
                nArray[n7] = nArray[n4];
                nArray2[n7] = nArray2[n4];
                --n7;
            }
            if (n2 - n4 >= n4 - n) {
                nArray3[n3++] = n4 + 1;
                nArray3[n3++] = n2;
                n2 = n4 - 1;
                continue;
            }
            nArray3[n3++] = n;
            nArray3[n3++] = n4 - 1;
            n = n4 + 1;
        }
    }

    class Store {
        double[] yMin;
        double[] yMax;
        double[] x0;
        double[] slope;
        double[] val0;
        double[] val1;
        int[] winding;
        int[] pathnum;
        int[] windingType = new int[5];
        int[] LRstack = new int[32];

        Store() {
        }

        void moreEdges(int n) {
            if (this.yMin == null) {
                this.yMin = MemUtil.allocDouble(n += 16);
                this.yMax = MemUtil.allocDouble(n);
                this.x0 = MemUtil.allocDouble(n);
                this.slope = MemUtil.allocDouble(n);
                this.val0 = MemUtil.allocDouble(n);
                this.val1 = MemUtil.allocDouble(n);
                this.winding = MemUtil.allocInt(n);
                this.pathnum = MemUtil.allocInt(n);
            } else if (n > this.yMin.length) {
                int n2 = this.yMin.length;
                double[] dArray = MemUtil.allocDouble(n += 16);
                System.arraycopy(this.yMin, 0, dArray, 0, n2);
                this.yMin = dArray;
                dArray = MemUtil.allocDouble(n);
                System.arraycopy(this.yMax, 0, dArray, 0, n2);
                this.yMax = dArray;
                dArray = MemUtil.allocDouble(n);
                System.arraycopy(this.x0, 0, dArray, 0, n2);
                this.x0 = dArray;
                dArray = MemUtil.allocDouble(n);
                System.arraycopy(this.slope, 0, dArray, 0, n2);
                this.slope = dArray;
                this.val0 = MemUtil.allocDouble(n);
                this.val1 = MemUtil.allocDouble(n);
                int[] nArray = MemUtil.allocInt(n);
                System.arraycopy(this.winding, 0, nArray, 0, n2);
                this.winding = nArray;
                nArray = MemUtil.allocInt(n);
                System.arraycopy(this.pathnum, 0, nArray, 0, n2);
                this.pathnum = nArray;
            }
        }

        void moreWinding(int n) {
            if (n > this.windingType.length) {
                int[] nArray = MemUtil.allocInt(n += 5);
                System.arraycopy(this.windingType, 0, nArray, 0, this.windingType.length);
            }
        }
    }
}

