/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.util.MemUtil;
import java.io.IOException;
import java.io.OutputStream;

class AWTByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected int allocSize;

    public AWTByteArrayOutputStream() {
        this(32);
    }

    public AWTByteArrayOutputStream(int n) {
        this.allocSize = n;
        this.buf = MemUtil.allocByte(n);
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        return this.buf;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public synchronized void write(int n) {
        int n2 = this.count + 1;
        if (n2 > this.buf.length) {
            byte[] byArray = MemUtil.allocByte(Math.max(this.buf.length + this.allocSize, n2));
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n;
        this.count = n2;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = MemUtil.allocByte(Math.max(this.buf.length + this.allocSize, n3));
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }
}

