/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.SidecarImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

class AAPixelGrabber
implements ImageConsumer {
    int width;
    int height;
    byte[][] pixArray;
    int currRowCount = 0;
    int xsampling;
    int ysampling;
    int shift;
    int aaWidth;
    int aaHeight;
    int inc;
    byte[] pix0;
    byte[] pix1;
    byte[] pix2;
    byte[] pix3;
    boolean allDone;
    ImageProducer ip;

    public AAPixelGrabber(SidecarImage sidecarImage, int n, int n2, byte[][] byArray, int n3, int n4, int n5) {
        this.ip = sidecarImage.getSource();
        this.pixArray = byArray;
        this.xsampling = n3;
        this.ysampling = n4;
        this.shift = n5;
        this.aaWidth = n / n3;
        this.aaHeight = n2 / n4;
        this.width = n;
        this.height = n2;
        this.inc = 256 / (n3 * n4);
        this.pix0 = byArray[0];
        if (byArray.length > 1) {
            this.pix1 = byArray[1];
        }
        if (byArray.length > 2) {
            this.pix2 = byArray[2];
            this.pix3 = byArray[3];
        }
    }

    public void grabPixels() {
        this.allDone = false;
        this.ip.startProduction(this);
        try {
            while (!this.allDone) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized void imageComplete(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.allDone = true;
                this.notifyAll();
                break;
            }
        }
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setDimensions(int n, int n2) {
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = n4;
        if (n2 >= this.height) {
            return;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        if (this.pixArray.length == 4) {
            int n8 = n5;
            int n9 = n6 - this.width;
            int n10 = 0;
            while (n10 < n4) {
                int n11 = this.width + this.xsampling;
                int n12 = 0;
                while (n12 < n11) {
                    byArray[n12] = (byte)(byArray[n12] == 0 ? this.inc : 0);
                    ++n12;
                }
                int n13 = (n2 + n10) / this.ysampling * this.aaWidth;
                n12 = 0;
                while (n12 < this.aaWidth) {
                    int n14 = this.pix0[n13] & 0xFF;
                    int n15 = this.pix1[n13] & 0xFF;
                    int n16 = this.pix2[n13] & 0xFF;
                    int n17 = this.pix3[n13] & 0xFF;
                    int n18 = 0;
                    while (n18 < this.xsampling) {
                        n14 += byArray[n8 + 8];
                        n15 += byArray[n8 + 6];
                        n16 += byArray[n8 + 4];
                        n17 += byArray[n8 + 2];
                        ++n8;
                        ++n18;
                    }
                    this.pix0[n13] = (byte)(n14 == 256 ? 255 : n14);
                    this.pix1[n13] = (byte)(n15 == 256 ? 255 : n15);
                    this.pix2[n13] = (byte)(n16 == 256 ? 255 : n16);
                    this.pix3[n13] = (byte)(n17 == 256 ? 255 : n17);
                    ++n13;
                    ++n12;
                }
                n8 += n9;
                ++n10;
            }
        } else if (this.pixArray.length == 2) {
            int n19 = n5;
            int n20 = n6 - this.width;
            int n21 = 0;
            while (n21 < n4) {
                int n22 = 0;
                while (n22 < this.width) {
                    byArray[n22] = (byte)(byArray[n22] == 0 ? this.inc : 0);
                    ++n22;
                }
                int n23 = (n2 + n21) / this.ysampling * this.aaWidth;
                n22 = 0;
                while (n22 < this.aaWidth) {
                    int n24 = this.pix0[n23] & 0xFF;
                    int n25 = this.pix1[n23] & 0xFF;
                    int n26 = 0;
                    while (n26 < this.xsampling) {
                        n24 += byArray[n19 + 4];
                        n25 += byArray[n19 + 2];
                        ++n19;
                        ++n26;
                    }
                    this.pix0[n23] = (byte)(n24 == 256 ? 255 : n24);
                    this.pix1[n23] = (byte)(n25 == 256 ? 255 : n25);
                    ++n23;
                    ++n22;
                }
                n19 += n20;
                ++n21;
            }
        } else {
            this.pix0 = this.pixArray[0];
            int n27 = 0;
            while (n27 < n4) {
                int n28 = n27 * n6 + n5;
                int n29 = (n2 + n27) / this.ysampling * this.aaWidth;
                int n30 = 0;
                while (n30 < this.aaWidth) {
                    int n31 = this.pix0[n29] & 0xFF;
                    int n32 = 0;
                    while (n32 < this.xsampling) {
                        n31 += byArray[n28++];
                        ++n32;
                    }
                    this.pix0[n29++] = (byte)(n31 == 256 ? 255 : n31);
                    ++n30;
                }
                ++n27;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (n2 >= this.height) {
            return;
        }
        if (this.pixArray.length == 4) {
            int n7 = n5;
            int n8 = n6 - this.width;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = this.width + this.xsampling;
                int n11 = 0;
                while (n11 < n10) {
                    nArray[n11] = nArray[n11] == 0 ? this.inc : 0;
                    ++n11;
                }
                int n12 = (n2 + n9) / this.ysampling * this.aaWidth;
                n11 = 0;
                while (n11 < this.aaWidth) {
                    int n13 = this.pix0[n12] & 0xFF;
                    int n14 = this.pix1[n12] & 0xFF;
                    int n15 = this.pix2[n12] & 0xFF;
                    int n16 = this.pix3[n12] & 0xFF;
                    int n17 = 0;
                    while (n17 < this.xsampling) {
                        n13 += nArray[n7 + 8];
                        n14 += nArray[n7 + 6];
                        n15 += nArray[n7 + 4];
                        n16 += nArray[n7 + 2];
                        ++n7;
                        ++n17;
                    }
                    this.pix0[n12] = (byte)(n13 == 256 ? 255 : n13);
                    this.pix1[n12] = (byte)(n14 == 256 ? 255 : n14);
                    this.pix2[n12] = (byte)(n15 == 256 ? 255 : n15);
                    this.pix3[n12] = (byte)(n16 == 256 ? 255 : n16);
                    ++n12;
                    ++n11;
                }
                n7 += n8;
                ++n9;
            }
        } else if (this.pixArray.length == 2) {
            int n18 = n5;
            int n19 = n6 - this.width;
            int n20 = 0;
            while (n20 < n4) {
                int n21 = this.width + this.xsampling;
                int n22 = 0;
                while (n22 < n21) {
                    nArray[n22] = nArray[n22] == 0 ? this.inc : 0;
                    ++n22;
                }
                int n23 = (n2 + n20) / this.ysampling * this.aaWidth;
                n22 = 0;
                while (n22 < this.aaWidth) {
                    int n24 = this.pix0[n23] & 0xFF;
                    int n25 = this.pix1[n23] & 0xFF;
                    int n26 = 0;
                    while (n26 < this.xsampling) {
                        n24 += nArray[n18 + 4];
                        n25 += nArray[n18 + 2];
                        ++n18;
                        ++n26;
                    }
                    this.pix0[n23] = (byte)(n24 == 256 ? 255 : n24);
                    this.pix1[n23] = (byte)(n25 == 256 ? 255 : n25);
                    ++n23;
                    ++n22;
                }
                n18 += n19;
                ++n20;
            }
        } else {
            this.pix0 = this.pixArray[0];
            int n27 = n2 / this.ysampling * this.aaWidth;
            int n28 = 0;
            while (n28 < n4) {
                int n29 = this.width + this.xsampling;
                int n30 = 0;
                while (n30 < n29) {
                    nArray[n30] = nArray[n30] == 0 ? this.inc : 0;
                    ++n30;
                }
                n27 = (n2 + n28) / this.ysampling * this.aaWidth;
                int n31 = n28 * n6 + n5;
                n30 = 0;
                while (n30 < this.aaWidth) {
                    int n32 = this.pix0[n27] & 0xFF;
                    int n33 = 0;
                    while (n33 < this.xsampling) {
                        n32 += nArray[n31++];
                        ++n33;
                    }
                    this.pix0[n27] = (byte)(n32 == 256 ? 255 : n32);
                    ++n27;
                    ++n30;
                }
                ++n28;
            }
        }
    }

    public void setProperties(Hashtable hashtable) {
    }
}

