/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.filters.FilterParams;
import com.adobe.acrobat.pdfobjstore.DictEntryNFExc;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFFilter;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.PEASCII85DecodeFilter;
import com.adobe.acrobat.pdfobjstore.PEASCIIHexDecodeFilter;
import com.adobe.acrobat.pdfobjstore.PECCITTFaxDecodeFilter;
import com.adobe.acrobat.pdfobjstore.PEDCTDecodeFilter;
import com.adobe.acrobat.pdfobjstore.PEFlateDecodeFilter;
import com.adobe.acrobat.pdfobjstore.PELZWDecodeFilter;
import com.adobe.acrobat.pdfobjstore.PERC4DecodeFilter;
import com.adobe.acrobat.pdfobjstore.PERunLengthDecodeFilter;
import com.adobe.acrobat.pdfobjstore.UnknownFilterException;
import com.adobe.acrobat.pdfobjstore.security.PDFObjCryptKey;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.VValue;
import com.adobe.util.Assert;

public class VFilterRules
extends VValue {
    private static final String VInlineImageFilterRules_K = "VInlineImageFilterRules";
    private static final String VFilterRules_K = "VFilterRules";
    private static final String VUnFilteredRules_K = "VUnFilteredRules";
    private static ExtensionDataProvider provider = null;
    private static final String BitsPerComponent_K = "BitsPerComponent";
    private static final String BlackIs1_K = "BlackIs1";
    private static final String BPC_K = "BPC";
    private static final String Colors_K = "Colors";
    private static final String Columns_K = "Columns";
    private static final String DamagedRowsBeforeError_K = "DamagedRowsBeforeError";
    private static final String DecodeParms_K = "DecodeParms";
    private static final String DP_K = "DP";
    private static final String EarlyChange_K = "EarlyChange";
    private static final String EncodedByteAlign_K = "EncodedByteAlign";
    private static final String EndOfBlock_K = "EndOfBlock";
    private static final String EndOfLine_K = "EndOfLine";
    private static final String F_K = "F";
    private static final String Filter_K = "Filter";
    private static final String FFilter_K = "FFilter";
    private static final String H_K = "H";
    private static final String Height_K = "Height";
    private static final String K_K = "K";
    private static final String Predictor_K = "Predictor";
    private static final String Rows_K = "Rows";
    private static final String W_K = "W";
    private static final String Width_K = "Width";
    private static final String[] inlineFilterKeys = new String[]{"Filter", "F"};
    private static final String[] inlineDecodeKeys = new String[]{"DecodeParms", "DP"};
    private static final String[] inlineBPCKeys = new String[]{"BitsPerComponent", "BPC"};
    private static final String[] inlineHeightKeys = new String[]{"Height", "H"};
    private static final String[] inlineWidthKeys = new String[]{"Width", "W"};
    private static final String AHx_K = "AHx";
    private static final String ASCIIHexDecode_K = "ASCIIHexDecode";
    private static final String A85_K = "A85";
    private static final String ASCII85Decode_K = "ASCII85Decode";
    private static final String CCF_K = "CCF";
    private static final String CCITTFaxDecode_K = "CCITTFaxDecode";
    private static final String DCT_K = "DCT";
    private static final String DCTDecode_K = "DCTDecode";
    private static final String Fl_K = "Fl";
    private static final String FlateDecode_K = "FlateDecode";
    private static final String LZW_K = "LZW";
    private static final String LZWDecode_K = "LZWDecode";
    private static final String RL_K = "RL";
    private static final String RunLengthDecode_K = "RunLengthDecode";
    private PDFReference pdfRef;
    private boolean decryptonly;
    private boolean inlineImage;
    private PDFFilter[] filterRules;

    VFilterRules(PDFReference pDFReference, boolean bl, boolean bl2) {
        this.pdfRef = pDFReference;
        this.inlineImage = bl2;
        this.decryptonly = bl ^ true;
    }

    private FilterParams buildDecodeParms(FilterParams filterParams, PDFDict pDFDict, PDFObj pDFObj, Requester requester) throws Exception {
        if (pDFObj != null) {
            PDFObj pDFObj2;
            PDFObj pDFObj3;
            PDFObj pDFObj4;
            PDFObj pDFObj5;
            PDFObj pDFObj6;
            PDFObj pDFObj7;
            PDFObj pDFObj8;
            PDFObj pDFObj9;
            PDFObj pDFObj10;
            PDFObj pDFObj11;
            PDFObj pDFObj12;
            if (pDFObj.type(requester) == 0) {
                return filterParams;
            }
            PDFDict pDFDict2 = pDFObj.dictValue(requester);
            if (this.hasKey(pDFDict, inlineHeightKeys)) {
                filterParams.put(Height_K, new Integer(this.getFromDict(pDFDict, inlineHeightKeys).integerValue(requester)));
            }
            if (this.hasKey(pDFDict, inlineWidthKeys)) {
                filterParams.put(Width_K, new Integer(this.getFromDict(pDFDict, inlineWidthKeys).integerValue(requester)));
            }
            if ((pDFObj12 = this.getParm(pDFDict2, Predictor_K)) != null) {
                filterParams.put(Predictor_K, new Integer(pDFObj12.integerValue(requester)));
            }
            if ((pDFObj11 = this.getParm(pDFDict2, Columns_K)) != null) {
                filterParams.put("Cols", new Integer(pDFObj11.integerValue(requester)));
            }
            if ((pDFObj10 = this.getParm(pDFDict2, Colors_K)) != null) {
                filterParams.put("Components", new Integer(pDFObj10.integerValue(requester)));
            }
            if ((pDFObj9 = this.getParm(pDFDict2, inlineBPCKeys)) != null) {
                filterParams.put(BitsPerComponent_K, new Integer(pDFObj9.integerValue(requester)));
            } else if (this.hasKey(pDFDict, inlineBPCKeys)) {
                filterParams.put(BitsPerComponent_K, new Integer(this.getFromDict(pDFDict, inlineBPCKeys).integerValue(requester)));
            }
            PDFObj pDFObj13 = this.getParm(pDFDict2, EarlyChange_K);
            if (pDFObj13 != null) {
                filterParams.put(EarlyChange_K, new Integer(pDFObj13.integerValue(requester)));
            }
            if ((pDFObj8 = this.getParm(pDFDict2, K_K)) != null) {
                filterParams.put(K_K, new Integer(pDFObj8.integerValue(requester)));
            }
            if ((pDFObj7 = this.getParm(pDFDict2, EndOfLine_K)) != null) {
                filterParams.put("DoEOL", new Boolean(pDFObj7.booleanValue(requester)));
            }
            if ((pDFObj6 = this.getParm(pDFDict2, EncodedByteAlign_K)) != null) {
                filterParams.put("ByteAlign", new Boolean(pDFObj6.booleanValue(requester)));
            }
            if ((pDFObj5 = this.getParm(pDFDict2, Rows_K)) != null) {
                filterParams.put(Rows_K, new Integer(pDFObj5.integerValue(requester)));
            }
            if ((pDFObj4 = this.getParm(pDFDict2, EndOfBlock_K)) != null) {
                filterParams.put("DoRTC", new Boolean(pDFObj4.booleanValue(requester)));
            }
            if ((pDFObj3 = this.getParm(pDFDict2, BlackIs1_K)) != null) {
                filterParams.put(BlackIs1_K, new Boolean(pDFObj3.booleanValue(requester)));
            }
            if ((pDFObj2 = this.getParm(pDFDict2, DamagedRowsBeforeError_K)) != null) {
                filterParams.put(DamagedRowsBeforeError_K, new Integer(pDFObj2.integerValue(requester)));
            }
        }
        return filterParams;
    }

    protected final void compute(Requester requester) throws Exception {
        PDFDict pDFDict = this.pdfRef.dictValue(requester);
        PDFObjCryptKey pDFObjCryptKey = this.pdfRef.getCryptKey(requester);
        PERC4DecodeFilter pERC4DecodeFilter = pDFObjCryptKey != null ? new PERC4DecodeFilter(pDFObjCryptKey) : null;
        boolean bl = !this.inlineImage && pDFDict.hasKey(F_K);
        PDFObj pDFObj = null;
        if (!this.decryptonly) {
            if (!bl) {
                if (this.hasKey(pDFDict, inlineFilterKeys)) {
                    pDFObj = this.getFromDict(pDFDict, inlineFilterKeys);
                }
            } else if (pDFDict.hasKey(FFilter_K)) {
                pDFObj = pDFDict.get(FFilter_K);
            }
        }
        if (pDFObj == null) {
            if (!bl) {
                this.filterRules = this.prependEncryptFilter(pERC4DecodeFilter, new PDFFilter[0]);
            }
        } else {
            PDFFilter[] pDFFilterArray;
            PDFObj pDFObj2;
            boolean bl2 = this.hasKey(pDFDict, inlineDecodeKeys);
            PDFObj pDFObj3 = pDFObj2 = bl2 ? this.getFromDict(pDFDict, inlineDecodeKeys) : null;
            if (pDFObj.type(requester) == 5) {
                pDFFilterArray = new PDFFilter[]{this.handleOneFilter(0, pDFObj.nameValue(requester), pDFDict, pDFObj2, requester)};
            } else {
                PDFArray pDFArray = pDFObj.arrayValue(requester);
                PDFArray pDFArray2 = pDFObj2 != null ? pDFObj2.arrayValue(requester) : null;
                pDFFilterArray = new PDFFilter[pDFArray.size()];
                int n = 0;
                while (n < pDFArray.size()) {
                    pDFFilterArray[n] = this.handleOneFilter(n, pDFArray.get(n).nameValue(requester), pDFDict, pDFObj2 != null ? pDFArray2.get(n) : null, requester);
                    ++n;
                }
            }
            this.filterRules = !bl ? this.prependEncryptFilter(pERC4DecodeFilter, pDFFilterArray) : pDFFilterArray;
        }
    }

    public PDFFilter[] filterRulesValue(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.filterRules;
    }

    private PDFObj getFromDict(PDFDict pDFDict, String[] stringArray) throws DictEntryNFExc {
        if (this.inlineImage) {
            int n = stringArray.length;
            while (n-- > 0) {
                if (!pDFDict.hasKey(stringArray[n])) continue;
                return pDFDict.get(stringArray[n]);
            }
            throw new DictEntryNFExc(stringArray[0]);
        }
        return pDFDict.get(stringArray[0]);
    }

    private String getLongFilterName(String string) {
        if (this.inlineImage) {
            if (string.equals(AHx_K)) {
                return ASCIIHexDecode_K;
            }
            if (string.equals(A85_K)) {
                return ASCII85Decode_K;
            }
            if (string.equals(CCF_K)) {
                return CCITTFaxDecode_K;
            }
            if (string.equals(DCT_K)) {
                return DCTDecode_K;
            }
            if (string.equals(Fl_K)) {
                return FlateDecode_K;
            }
            if (string.equals(LZW_K)) {
                return LZWDecode_K;
            }
            if (string.equals(RL_K)) {
                return RunLengthDecode_K;
            }
        }
        return string;
    }

    private PDFObj getParm(PDFDict pDFDict, String string) throws Exception {
        if (pDFDict.hasKey(string)) {
            return pDFDict.get(string);
        }
        return null;
    }

    private PDFObj getParm(PDFDict pDFDict, String[] stringArray) throws Exception {
        if (this.hasKey(pDFDict, stringArray)) {
            return this.getFromDict(pDFDict, stringArray);
        }
        return null;
    }

    static VFilterRules getVFilterRules(PDFReference pDFReference, boolean bl, boolean bl2) {
        VFilterRules.initProvider();
        if (bl2) {
            return (VFilterRules)pDFReference.getExtensionData(VInlineImageFilterRules_K);
        }
        if (bl) {
            return (VFilterRules)pDFReference.getExtensionData(VFilterRules_K);
        }
        return (VFilterRules)pDFReference.getExtensionData(VUnFilteredRules_K);
    }

    private PDFFilter handleOneFilter(int n, String string, PDFDict pDFDict, PDFObj pDFObj, Requester requester) throws Exception {
        FilterParams filterParams = new FilterParams();
        if (this.inlineImage && n == 0) {
            filterParams.put("CloseSource", Boolean.FALSE);
            filterParams.put("AvoidInOverrun", Boolean.TRUE);
        }
        if ((string = this.getLongFilterName(string)).equals(ASCIIHexDecode_K)) {
            return new PEASCIIHexDecodeFilter(filterParams);
        }
        if (string.equals(ASCII85Decode_K)) {
            return new PEASCII85DecodeFilter(filterParams);
        }
        if (string.equals(LZWDecode_K)) {
            return new PELZWDecodeFilter(this.buildDecodeParms(filterParams, pDFDict, pDFObj, requester));
        }
        if (string.equals(RunLengthDecode_K)) {
            return new PERunLengthDecodeFilter(filterParams);
        }
        if (string.equals(CCITTFaxDecode_K)) {
            return new PECCITTFaxDecodeFilter(this.buildDecodeParms(filterParams, pDFDict, pDFObj, requester));
        }
        if (string.equals(DCTDecode_K)) {
            return new PEDCTDecodeFilter(this.buildDecodeParms(filterParams, pDFDict, pDFObj, requester));
        }
        if (string.equals(FlateDecode_K)) {
            return new PEFlateDecodeFilter(this.buildDecodeParms(filterParams, pDFDict, pDFObj, requester));
        }
        throw new UnknownFilterException(string);
    }

    private boolean hasKey(PDFDict pDFDict, String[] stringArray) {
        if (this.inlineImage) {
            int n = stringArray.length;
            while (n-- > 0) {
                if (!pDFDict.hasKey(stringArray[n])) continue;
                return true;
            }
            return false;
        }
        return pDFDict.hasKey(stringArray[0]);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof PDFReference);
                    PDFReference pDFReference = (PDFReference)extensible;
                    if (string.equals(VFilterRules.VInlineImageFilterRules_K)) {
                        return new VFilterRules(pDFReference, true, true);
                    }
                    if (string.equals(VFilterRules.VFilterRules_K)) {
                        return new VFilterRules(pDFReference, true, false);
                    }
                    if (string.equals(VFilterRules.VUnFilteredRules_K)) {
                        return new VFilterRules(pDFReference, false, false);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VInlineImageFilterRules_K, provider);
            Extension.registerProvider(VFilterRules_K, provider);
            Extension.registerProvider(VUnFilteredRules_K, provider);
        }
    }

    private PDFFilter[] prependEncryptFilter(PDFFilter pDFFilter, PDFFilter[] pDFFilterArray) {
        if (pDFFilter != null) {
            PDFFilter[] pDFFilterArray2 = new PDFFilter[pDFFilterArray.length + 1];
            pDFFilterArray2[0] = pDFFilter;
            int n = pDFFilterArray.length;
            while (n-- > 0) {
                pDFFilterArray2[n + 1] = pDFFilterArray[n];
            }
            return pDFFilterArray2;
        }
        return pDFFilterArray;
    }
}

