/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.filters.BitfieldInputStream;
import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.IndexedColorModel;
import com.adobe.acrobat.pdf.image.PDFColorModel;
import com.adobe.acrobat.pdf.image.ShadeEdge;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatPoint;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.ListSort;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class TPatch
implements Cloneable {
    FloatPoint[] control = new FloatPoint[16];
    FloatPoint[] corner = new FloatPoint[4];
    boolean[] locked;
    ColorValue[] color = new ColorValue[4];
    FloatRect bbox;
    boolean lf;
    boolean rf;
    boolean tf;
    boolean bf;
    boolean tp;
    TPatch next;
    int index;
    int uRecursion;
    int vRecursion;
    static final int MAX_RECURSION_LEVEL = 6;
    static final double FLATNESS_EPSILON = 2.0;
    private static final double oneThird = 0.3333333333333333;

    protected TPatch() {
        this.locked = new boolean[4];
        this.bbox = new FloatRect(0.0, 0.0, 1.0, 1.0);
        this.locked[3] = false;
        this.locked[2] = false;
        this.locked[1] = false;
        this.locked[0] = false;
        this.tp = false;
        this.bf = false;
        this.tf = false;
        this.rf = false;
        this.lf = false;
        this.next = null;
    }

    private static void BezierDivide(TPatch tPatch, TPatch tPatch2, TPatch tPatch3, int n, int n2, int n3, int n4) {
        FloatPoint floatPoint = TPatch.MidPoint(tPatch.control[n2], tPatch.control[n3]);
        tPatch2.control[n] = tPatch.control[n];
        tPatch3.control[n4] = tPatch.control[n4];
        tPatch2.control[n2] = TPatch.MidPoint(tPatch.control[n], tPatch.control[n2]);
        tPatch3.control[n3] = TPatch.MidPoint(tPatch.control[n3], tPatch.control[n4]);
        tPatch2.control[n3] = TPatch.MidPoint(tPatch2.control[n2], floatPoint);
        tPatch3.control[n2] = TPatch.MidPoint(tPatch3.control[n3], floatPoint);
        tPatch2.control[n4] = tPatch3.control[n] = TPatch.MidPoint(tPatch2.control[n3], tPatch3.control[n2]);
    }

    private FloatPoint CPEval(int n, int n2, FloatPoint[] floatPointArray, FloatPoint[] floatPointArray2, FloatPoint[] floatPointArray3, FloatPoint[] floatPointArray4) {
        double d = (double)n / 3.0;
        double d2 = (double)n2 / 3.0;
        double d3 = (1.0 - d2) * floatPointArray[n].x + d2 * floatPointArray2[n].x;
        double d4 = (1.0 - d) * floatPointArray3[n2].x + d * floatPointArray4[n2].x;
        double d5 = (1.0 - d2) * ((1.0 - d) * floatPointArray[0].x + d * floatPointArray[3].x) + d2 * ((1.0 - d) * floatPointArray2[0].x + d * floatPointArray2[3].x);
        double d6 = d3 + d4 - d5;
        d3 = (1.0 - d2) * floatPointArray[n].y + d2 * floatPointArray2[n].y;
        d4 = (1.0 - d) * floatPointArray3[n2].y + d * floatPointArray4[n2].y;
        d5 = (1.0 - d2) * ((1.0 - d) * floatPointArray[0].y + d * floatPointArray[3].y) + d2 * ((1.0 - d) * floatPointArray2[0].y + d * floatPointArray2[3].y);
        double d7 = d3 + d4 - d5;
        return new FloatPoint(d6, d7);
    }

    private void CPSurface() {
        FloatPoint[] floatPointArray = new FloatPoint[]{this.control[0], this.control[11], this.control[10], this.control[9]};
        FloatPoint[] floatPointArray2 = new FloatPoint[]{this.control[3], this.control[4], this.control[5], this.control[6]};
        FloatPoint[] floatPointArray3 = new FloatPoint[]{this.control[0], this.control[1], this.control[2], this.control[3]};
        FloatPoint[] floatPointArray4 = new FloatPoint[]{this.control[9], this.control[8], this.control[7], this.control[6]};
        this.control[12] = this.CPEval(1, 1, floatPointArray, floatPointArray2, floatPointArray3, floatPointArray4);
        this.control[13] = this.CPEval(1, 2, floatPointArray, floatPointArray2, floatPointArray3, floatPointArray4);
        this.control[14] = this.CPEval(2, 2, floatPointArray, floatPointArray2, floatPointArray3, floatPointArray4);
        this.control[15] = this.CPEval(2, 1, floatPointArray, floatPointArray2, floatPointArray3, floatPointArray4);
    }

    private ColorValue CornerColor(float f, float f2) {
        if (f2 == 0.0f) {
            if (f == 0.0f) {
                return this.color[0];
            }
            if (f == 1.0f) {
                return this.color[1];
            }
        } else if (f2 == 1.0f) {
            if (f == 1.0f) {
                return this.color[2];
            }
            if (f == 0.0f) {
                return this.color[3];
            }
        }
        float[] fArray = this.color[0].accessColor();
        float[] fArray2 = this.color[1].accessColor();
        float[] fArray3 = this.color[2].accessColor();
        float[] fArray4 = this.color[3].accessColor();
        int n = fArray.length;
        float[] fArray5 = new float[n];
        float[] fArray6 = new float[n];
        float f3 = 1.0f - f;
        float f4 = 1.0f - f2;
        int n2 = 0;
        while (n2 < n) {
            fArray5[n2] = f3 * fArray[n2] + f * fArray4[n2];
            fArray6[n2] = f3 * fArray2[n2] + f * fArray3[n2];
            fArray5[n2] = f4 * fArray5[n2] + f2 * fArray6[n2];
            ++n2;
        }
        return new ColorValue(this.color[0].getColorModel(), fArray5);
    }

    private TPatch DivideConvex(boolean bl) {
        int n;
        FloatPoint[] floatPointArray = new FloatPoint[4];
        FloatPoint[] floatPointArray2 = new FloatPoint[4];
        int[] nArray = new int[4];
        int n2 = 0;
        while (n2 < 4) {
            floatPointArray[n2] = this.locked[n2] ? this.corner[n2] : this.control[3 * n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            n = n2 - 1 & 3;
            floatPointArray2[n2] = new FloatPoint(floatPointArray[n2].x - floatPointArray[n].x, floatPointArray[n2].y - floatPointArray[n].y);
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            n = n2 + 1 & 3;
            double d = floatPointArray2[n2].y * floatPointArray2[n].x - floatPointArray2[n2].x * floatPointArray2[n].y;
            if (d == 0.0) {
                return null;
            }
            nArray[n2] = d > 0.0 ? 1 : -1;
            ++n2;
        }
        if (nArray[0] == nArray[3] && nArray[1] == nArray[2] && (floatPointArray2[0].x * floatPointArray2[0].x + floatPointArray2[0].y * floatPointArray2[0].y > 2.0 || floatPointArray2[2].x * floatPointArray2[2].x + floatPointArray2[2].y * floatPointArray2[2].y > 2.0)) {
            return this.DivideInV();
        }
        if (!bl && nArray[0] == nArray[1] && nArray[2] == nArray[3]) {
            if (nArray[0] == nArray[2]) {
                return null;
            }
            if (floatPointArray2[1].x * floatPointArray2[1].x + floatPointArray2[1].y * floatPointArray2[1].y > 2.0 || floatPointArray2[3].x * floatPointArray2[3].x + floatPointArray2[3].y * floatPointArray2[3].y > 2.0) {
                return this.DivideInU();
            }
        }
        return null;
    }

    private TPatch DivideInU() {
        TPatch tPatch = null;
        TPatch tPatch2 = null;
        if (this.uRecursion++ >= 6) {
            return null;
        }
        try {
            tPatch = (TPatch)this.clone();
            tPatch2 = (TPatch)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        tPatch.next = tPatch2;
        tPatch2.next = this.next;
        TPatch.BezierDivide(this, tPatch, tPatch2, 3, 4, 5, 6);
        TPatch.BezierDivide(this, tPatch, tPatch2, 2, 13, 14, 7);
        TPatch.BezierDivide(this, tPatch, tPatch2, 1, 12, 15, 8);
        TPatch.BezierDivide(this, tPatch, tPatch2, 0, 11, 10, 9);
        double d = this.bbox.getxMin();
        double d2 = this.bbox.getyMin();
        double d3 = this.bbox.getxMax();
        double d4 = this.bbox.getyMax();
        double d5 = (d + d3) / 2.0;
        tPatch.bbox = new FloatRect(d, d2, d5, d4);
        tPatch2.bbox = new FloatRect(d5, d2, d3, d4);
        tPatch.rf = false;
        tPatch.corner[3] = null;
        tPatch.corner[2] = null;
        tPatch.locked[3] = false;
        tPatch.locked[2] = false;
        tPatch2.lf = false;
        tPatch2.corner[1] = null;
        tPatch2.corner[0] = null;
        tPatch2.locked[1] = false;
        tPatch2.locked[0] = false;
        if (this.tf) {
            tPatch2.corner[1] = tPatch.corner[2] = TPatch.MidPoint(this.corner[1], this.corner[2]);
            tPatch.locked[2] = true;
            tPatch2.locked[1] = true;
        }
        if (this.bf) {
            tPatch2.corner[0] = tPatch.corner[3] = TPatch.MidPoint(this.corner[0], this.corner[3]);
            tPatch.locked[3] = true;
            tPatch2.locked[0] = true;
        }
        return tPatch;
    }

    private TPatch DivideInV() {
        TPatch tPatch = null;
        TPatch tPatch2 = null;
        if (this.vRecursion++ >= 6) {
            return null;
        }
        try {
            tPatch = (TPatch)this.clone();
            tPatch2 = (TPatch)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        tPatch2.next = tPatch;
        tPatch.next = this.next;
        TPatch.BezierDivide(this, tPatch2, tPatch, 0, 1, 2, 3);
        TPatch.BezierDivide(this, tPatch2, tPatch, 11, 12, 13, 4);
        TPatch.BezierDivide(this, tPatch2, tPatch, 10, 15, 14, 5);
        TPatch.BezierDivide(this, tPatch2, tPatch, 9, 8, 7, 6);
        double d = this.bbox.getxMin();
        double d2 = this.bbox.getyMin();
        double d3 = this.bbox.getxMax();
        double d4 = this.bbox.getyMax();
        double d5 = (d2 + d4) / 2.0;
        tPatch2.bbox = new FloatRect(d, d2, d3, d5);
        tPatch.bbox = new FloatRect(d, d5, d3, d4);
        tPatch.bf = false;
        tPatch.corner[3] = null;
        tPatch.corner[0] = null;
        tPatch.locked[3] = false;
        tPatch.locked[0] = false;
        tPatch2.tf = false;
        tPatch2.corner[2] = null;
        tPatch2.corner[1] = null;
        tPatch2.locked[2] = false;
        tPatch2.locked[1] = false;
        if (this.lf) {
            tPatch2.corner[1] = tPatch.corner[0] = TPatch.MidPoint(this.corner[0], this.corner[1]);
            tPatch.locked[0] = true;
            tPatch2.locked[1] = true;
        }
        if (this.rf) {
            tPatch2.corner[2] = tPatch.corner[3] = TPatch.MidPoint(this.corner[3], this.corner[2]);
            tPatch.locked[3] = true;
            tPatch2.locked[2] = true;
        }
        return tPatch2;
    }

    private static FloatPoint MidPoint(FloatPoint floatPoint, FloatPoint floatPoint2) {
        return new FloatPoint((floatPoint.x + floatPoint2.x) / 2.0, (floatPoint.y + floatPoint2.y) / 2.0);
    }

    public static TPatch ReadPatchList(InputStream inputStream, int n, int n2, int n3, float[] fArray, PDFColorModel pDFColorModel, boolean bl) {
        BitfieldInputStream bitfieldInputStream = new BitfieldInputStream(inputStream);
        TPatch tPatch = null;
        boolean bl2 = pDFColorModel instanceof IndexedColorModel;
        IndexedColorModel indexedColorModel = null;
        if (bl2) {
            indexedColorModel = (IndexedColorModel)pDFColorModel;
            pDFColorModel = indexedColorModel.getBaseColorModel();
        }
        int n4 = fArray.length / 2 - 2;
        double[] dArray = new double[n4 + 2];
        double[] dArray2 = new double[n4 + 2];
        double d = (1L << n) - 1L;
        double d2 = (1L << n2) - 1L;
        int n5 = 0;
        while (n5 < n4 + 2) {
            dArray[n5] = fArray[2 * n5];
            dArray2[n5] = fArray[2 * n5 + 1] - fArray[2 * n5];
            ++n5;
        }
        int n6 = bl ? 16 : 12;
        int n7 = 0;
        try {
            while (true) {
                TPatch tPatch2 = new TPatch();
                tPatch2.index = n7++;
                tPatch2.uRecursion = 0;
                tPatch2.vRecursion = 0;
                tPatch2.tp = bl;
                TPatch tPatch3 = tPatch;
                while (tPatch3 != null && tPatch3.next != null) {
                    tPatch3 = tPatch3.next;
                }
                bitfieldInputStream.read(0);
                int n8 = (int)bitfieldInputStream.read(n3);
                if (n8 >= 0) {
                    if (tPatch3 == null) {
                        n8 = 0;
                    }
                    int n9 = 0;
                    switch (n8 &= 3) {
                        case 1: {
                            tPatch2.control[0] = tPatch3.control[3];
                            tPatch2.control[1] = tPatch3.control[4];
                            tPatch2.control[2] = tPatch3.control[5];
                            tPatch2.control[3] = tPatch3.control[6];
                            tPatch2.color[0] = tPatch3.color[1];
                            tPatch2.color[1] = tPatch3.color[2];
                            n9 = 4;
                            break;
                        }
                        case 2: {
                            tPatch2.control[0] = tPatch3.control[6];
                            tPatch2.control[1] = tPatch3.control[7];
                            tPatch2.control[2] = tPatch3.control[8];
                            tPatch2.control[3] = tPatch3.control[9];
                            tPatch2.color[0] = tPatch3.color[2];
                            tPatch2.color[1] = tPatch3.color[3];
                            n9 = 4;
                            break;
                        }
                        case 3: {
                            tPatch2.control[0] = tPatch3.control[9];
                            tPatch2.control[1] = tPatch3.control[10];
                            tPatch2.control[2] = tPatch3.control[11];
                            tPatch2.control[3] = tPatch3.control[0];
                            tPatch2.color[0] = tPatch3.color[3];
                            tPatch2.color[1] = tPatch3.color[0];
                            n9 = 4;
                            break;
                        }
                    }
                    int n10 = n9;
                    while (n10 < n6) {
                        double d3 = (double)bitfieldInputStream.read(n) / d;
                        double d4 = dArray[0] + dArray2[0] * d3;
                        d3 = (double)bitfieldInputStream.read(n) / d;
                        double d5 = dArray[1] + dArray2[1] * d3;
                        tPatch2.control[n10] = new FloatPoint(d4, d5);
                        ++n10;
                    }
                    if (!bl) {
                        tPatch2.CPSurface();
                    }
                    n9 = n8 == 0 ? 0 : 2;
                    long l = 0L;
                    int n11 = n9;
                    while (n11 < 4) {
                        float[] fArray2 = new float[n4];
                        int n12 = 0;
                        while (n12 < n4) {
                            l = bitfieldInputStream.read(n2);
                            fArray2[n12] = (float)(dArray[2 + n12] + dArray2[2 + n12] * ((double)l / d2));
                            ++n12;
                        }
                        tPatch2.color[n11] = bl2 ? new ColorValue(pDFColorModel, indexedColorModel.getBaseColor(fArray2[0])) : new ColorValue(pDFColorModel, fArray2);
                        ++n11;
                    }
                    if (l < 0L) continue;
                    if (tPatch == null) {
                        tPatch = tPatch2;
                        continue;
                    }
                    tPatch.append(tPatch2);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return tPatch;
    }

    static /* synthetic */ TPatch access$0(TPatch tPatch, boolean bl) {
        return tPatch.flattenSurface(bl);
    }

    static /* synthetic */ ShadeEdge access$1(TPatch tPatch, ShadeEdge shadeEdge) {
        return tPatch.addQuadToMesh(shadeEdge);
    }

    private ShadeEdge addQuadToMesh(ShadeEdge shadeEdge) {
        int n;
        int n2;
        float f = (float)this.bbox.getxMin();
        float f2 = (float)this.bbox.getyMin();
        float f3 = (float)this.bbox.getxMax();
        float f4 = (float)this.bbox.getyMax();
        ColorValue[] colorValueArray = new ColorValue[4];
        int[] nArray = new int[4];
        int n3 = 0;
        while (n3 < 4) {
            if (!this.locked[n3]) {
                this.corner[n3] = this.control[3 * n3];
            }
            ++n3;
        }
        colorValueArray[0] = this.CornerColor(f, f2);
        colorValueArray[1] = this.CornerColor(f, f4);
        colorValueArray[2] = this.CornerColor(f3, f4);
        colorValueArray[3] = this.CornerColor(f3, f2);
        int n4 = 0;
        int n5 = 0;
        n3 = 0;
        while (n3 < 4) {
            n2 = n3 - 1 & 3;
            n = n3 + 1 & 3;
            double d = (this.corner[n3].x - this.corner[n2].x) * (this.corner[n].y - this.corner[n3].y) - (this.corner[n3].y - this.corner[n2].y) * (this.corner[n].x - this.corner[n3].x);
            if (d == 0.0) {
                nArray[n3] = 0;
            } else if (d > 0.0) {
                nArray[n3] = 1;
                ++n5;
            } else {
                nArray[n3] = -1;
                ++n4;
            }
            ++n3;
        }
        if (n5 == 4 || n4 == 4) {
            shadeEdge = new ShadeEdge(this.corner[0], this.corner[1], this.corner[2], colorValueArray[0], colorValueArray[1], colorValueArray[2], f3, f4, shadeEdge);
            shadeEdge = new ShadeEdge(this.corner[2], this.corner[3], this.corner[0], colorValueArray[2], colorValueArray[3], colorValueArray[0], f3, f4, shadeEdge);
            return shadeEdge;
        }
        if (n4 > n5) {
            n3 = 0;
            while (n3 < 4) {
                nArray[n3] = -nArray[n3];
                ++n3;
            }
            n3 = n4;
            n4 = n5;
            n5 = n3;
        }
        if (n5 == 3) {
            n3 = 0;
            while (n3 < 4) {
                if (nArray[n3] <= 0) {
                    n2 = n3 + 1 & 3;
                    n = n3 + 2 & 3;
                    shadeEdge = new ShadeEdge(this.corner[n3], this.corner[n2], this.corner[n], colorValueArray[n3], colorValueArray[n2], colorValueArray[n], f3, f4, shadeEdge);
                    n2 = n3 - 1 & 3;
                    shadeEdge = new ShadeEdge(this.corner[n3], this.corner[n2], this.corner[n], colorValueArray[n3], colorValueArray[n2], colorValueArray[n], f3, f4, shadeEdge);
                    return shadeEdge;
                }
                ++n3;
            }
        }
        if (n5 == 2) {
            if (n4 == 2) {
                if (nArray[0] == nArray[1]) {
                    shadeEdge = new ShadeEdge(this.corner[0], this.corner[1], this.corner[3], colorValueArray[0], colorValueArray[1], colorValueArray[3], f3, f4, shadeEdge);
                    shadeEdge = new ShadeEdge(this.corner[2], this.corner[3], this.corner[0], colorValueArray[2], colorValueArray[3], colorValueArray[0], f3, f4, shadeEdge);
                    return shadeEdge;
                }
                shadeEdge = new ShadeEdge(this.corner[0], this.corner[1], this.corner[3], colorValueArray[0], colorValueArray[1], colorValueArray[3], f3, f4, shadeEdge);
                shadeEdge = new ShadeEdge(this.corner[2], this.corner[1], this.corner[0], colorValueArray[2], colorValueArray[1], colorValueArray[0], f3, f4, shadeEdge);
                return shadeEdge;
            }
            n3 = 0;
            while (n3 < 4) {
                n2 = n3 + 1 & 3;
                if (nArray[n3] == nArray[n2]) {
                    n = n3 + 2 & 3;
                    shadeEdge = new ShadeEdge(this.corner[n3], this.corner[n2], this.corner[n], colorValueArray[n3], colorValueArray[n2], colorValueArray[n], f3, f4, shadeEdge);
                    n = n3 - 1 & 3;
                    shadeEdge = new ShadeEdge(this.corner[n3], this.corner[n2], this.corner[n], colorValueArray[n3], colorValueArray[n2], colorValueArray[n], f3, f4, shadeEdge);
                    return shadeEdge;
                }
                ++n3;
            }
        }
        return shadeEdge;
    }

    private void append(TPatch tPatch) {
        TPatch tPatch2 = this;
        while (tPatch2.next != null) {
            tPatch2 = tPatch2.next;
        }
        tPatch2.next = tPatch;
    }

    public Object clone() throws CloneNotSupportedException {
        TPatch tPatch = (TPatch)super.clone();
        tPatch.control = (FloatPoint[])this.control.clone();
        tPatch.corner = (FloatPoint[])this.corner.clone();
        tPatch.bbox = this.bbox;
        tPatch.color = this.color;
        tPatch.locked = (boolean[])this.locked.clone();
        return tPatch;
    }

    public Enumeration elements(AffineTransform affineTransform) {
        return new TPatchEnumeration(this, affineTransform);
    }

    private TPatch flattenSurface(boolean bl) {
        boolean bl2 = this.lf = this.lf || TPatch.isFlat(this.control[0], this.control[1], this.control[2], this.control[3]);
        if (this.lf) {
            if (!this.locked[0]) {
                this.corner[0] = this.control[0];
                this.locked[0] = true;
            }
            if (!this.locked[1]) {
                this.corner[1] = this.control[3];
                this.locked[1] = true;
            }
        }
        boolean bl3 = this.rf = this.rf || TPatch.isFlat(this.control[9], this.control[8], this.control[7], this.control[6]);
        if (this.rf) {
            if (!this.locked[2]) {
                this.corner[2] = this.control[6];
                this.locked[2] = true;
            }
            if (!this.locked[3]) {
                this.corner[3] = this.control[9];
                this.locked[3] = true;
            }
        }
        boolean bl4 = this.tf = this.tf || TPatch.isFlat(this.control[3], this.control[4], this.control[5], this.control[6]);
        if (this.tf) {
            if (!this.locked[1]) {
                this.corner[1] = this.control[3];
                this.locked[1] = true;
            }
            if (!this.locked[2]) {
                this.corner[2] = this.control[6];
                this.locked[2] = true;
            }
        }
        boolean bl5 = this.bf = this.bf || TPatch.isFlat(this.control[0], this.control[11], this.control[10], this.control[9]);
        if (this.bf) {
            if (!this.locked[0]) {
                this.corner[0] = this.control[0];
                this.locked[0] = true;
            }
            if (!this.locked[3]) {
                this.corner[3] = this.control[9];
                this.locked[3] = true;
            }
        }
        if (!(bl || this.tf && this.bf && (!this.tp || TPatch.isFlat(this.control[1], this.control[12], this.control[15], this.control[8]) && TPatch.isFlat(this.control[2], this.control[13], this.control[14], this.control[7])))) {
            return this.DivideInU();
        }
        if (!(this.lf && this.rf && (!this.tp || TPatch.isFlat(this.control[11], this.control[12], this.control[13], this.control[4]) && TPatch.isFlat(this.control[10], this.control[15], this.control[14], this.control[5])))) {
            return this.DivideInV();
        }
        return this.DivideConvex(bl);
    }

    public FloatRect getBoundingBox() {
        double d;
        double d2;
        TPatch tPatch = this;
        double d3 = d2 = this.control[0].x;
        double d4 = d = this.control[0].y;
        while (tPatch != null) {
            int n = 0;
            while (n < 16) {
                double d5 = tPatch.control[n].x;
                if (d3 > d5) {
                    d3 = d5;
                } else if (d2 < d5) {
                    d2 = d5;
                }
                double d6 = tPatch.control[n].y;
                if (d4 > d6) {
                    d4 = d6;
                } else if (d < d6) {
                    d = d6;
                }
                ++n;
            }
            tPatch = tPatch.next;
        }
        return new FloatRect(d3, d4, d2, d);
    }

    private static boolean isFlat(FloatPoint floatPoint, FloatPoint floatPoint2, FloatPoint floatPoint3, FloatPoint floatPoint4) {
        double d = (floatPoint4.x - floatPoint.x) * 0.3333333333333333;
        double d2 = (floatPoint4.y - floatPoint.y) * 0.3333333333333333;
        double d3 = floatPoint.x + d;
        double d4 = floatPoint.y + d2;
        if ((d = floatPoint2.x - d3) * d + (d2 = floatPoint2.y - d4) * d2 > 2.0) {
            return false;
        }
        return !((d = d3 + d - floatPoint3.x) * d + (d2 = d4 + d2 - floatPoint3.y) * d2 > 2.0);
    }

    class TPatchEnumeration
    implements Enumeration {
        private AffineTransform fTransform;
        private TPatch patchList;
        private TPatch morePatches;
        private ShadeEdge moreEdges;

        public TPatchEnumeration(TPatch tPatch2, AffineTransform affineTransform) {
            this.patchList = tPatch2;
            this.fTransform = affineTransform;
            this.morePatches = null;
            this.moreEdges = null;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            while (this.moreEdges == null && (this.morePatches != null || this.patchList != null)) {
                if (this.morePatches != null || this.patchList == null) ** GOTO lbl38
                try {
                    this.morePatches = (TPatch)this.patchList.clone();
                    this.morePatches.next = null;
                    var1_1 = 0;
                    while (var1_1 < 16) {
                        this.morePatches.control[var1_1] = this.morePatches.control[var1_1].deltaTransform(this.fTransform);
                        ++var1_1;
                    }
                    this.patchList = this.patchList.next;
                }
                catch (CloneNotSupportedException v0) {}
                ** GOTO lbl38
                {
                    this.morePatches = var1_2;
                    do {
                        if ((var1_2 = TPatch.access$0(this.morePatches, true)) != null) continue block4;
                        var3_4 = this.morePatches;
                        this.morePatches = this.morePatches.next;
                        var3_4.next = null;
                        while ((var1_2 = TPatch.access$0(var3_4, false)) != null) {
                            var3_4 = var1_2;
                        }
                        var1_2 = var3_4;
                        ** GOTO lbl31
                        {
                            var2_3 = var4_5;
                            do {
                                if ((var4_5 = TPatch.access$0(var2_3, false)) != null) continue block7;
                                var1_2.next = var2_3;
                                var1_2 = var2_3;
lbl31:
                                // 2 sources

                            } while ((var2_3 = var1_2.next) != null);
                        }
                        while (var3_4 != null) {
                            this.moreEdges = TPatch.access$1(var3_4, this.moreEdges);
                            var3_4 = var3_4.next;
                        }
                        if (this.moreEdges == null) continue;
                        this.moreEdges = (ShadeEdge)ListSort.Sort(this.moreEdges, this.moreEdges);
lbl38:
                        // 5 sources

                    } while (this.moreEdges == null && this.morePatches != null);
                }
            }
            return this.moreEdges != null;
        }

        public Object nextElement() {
            if (this.moreEdges == null) {
                this.hasMoreElements();
            }
            ShadeEdge shadeEdge = this.moreEdges;
            if (this.moreEdges != null) {
                this.moreEdges = this.moreEdges.next;
            }
            return shadeEdge;
        }
    }
}

