/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf.image;

import com.adobe.acrobat.pdf.ColorValue;
import com.adobe.acrobat.pdf.image.ExpandBitsImageFilter;
import com.adobe.acrobat.pdf.image.PDFColorParams;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;

public abstract class PDFColorModel
extends ColorModel {
    public static final int DeviceRGBColorSpace = 0;
    public static final int CalRGBColorSpace = 1;
    public static final int DeviceCMYKColorSpace = 2;
    public static final int CalCMYKColorSpace = 3;
    public static final int LabColorSpace = 4;
    public static final int DeviceGrayColorSpace = 5;
    public static final int CalGrayColorSpace = 6;
    public static final int ImageMaskColorSpace = 7;
    public static final int ImageMaskClip1ColorSpace = 8;
    public static final int ImageMaskClip8ColorSpace = 9;
    public static final int SeparationColorSpace = 10;
    public static final int ICCBasedColorSpace = 11;
    public static final int IndexedColorSpace = 20;
    public static final int PatternColorSpace = 21;
    protected PDFColorParams params;
    protected static final float[] xyz2sRGB = new float[]{3.241f, -0.9692f, 0.0556f, -1.5374f, 1.876f, -0.204f, -0.4986f, 0.0416f, 1.057f};
    protected static final double sRGBGammaInv = 0.45454545454545453;

    public PDFColorModel(PDFColorParams pDFColorParams) {
        super(pDFColorParams.Validate());
        this.params = pDFColorParams;
    }

    public static int XYZtoRGB(float f, float f2, float f3) {
        float f4 = xyz2sRGB[0] * f + xyz2sRGB[3] * f2 + xyz2sRGB[6] * f3;
        float f5 = xyz2sRGB[1] * f + xyz2sRGB[4] * f2 + xyz2sRGB[7] * f3;
        float f6 = xyz2sRGB[2] * f + xyz2sRGB[5] * f2 + xyz2sRGB[8] * f3;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        if (f6 < 0.0f) {
            f6 = 0.0f;
        } else if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        int n = Math.round(255.0f * (float)Math.pow(f4, 0.45454545454545453));
        int n2 = Math.round(255.0f * (float)Math.pow(f5, 0.45454545454545453));
        int n3 = Math.round(255.0f * (float)Math.pow(f6, 0.45454545454545453));
        return -16777216 + (n << 16) + (n2 << 8) + n3;
    }

    public static int XYZtoRGB(float[] fArray) {
        if (fArray.length >= 3) {
            return PDFColorModel.XYZtoRGB(fArray[0], fArray[1], fArray[2]);
        }
        throw new RuntimeException("PDFColorModel.XYZtoRGB(xyz[]) -- arrayToShort");
    }

    public ImageProducer addExpandFilter(ImageProducer imageProducer) {
        if (this.params.getBitsPerComponent() < 8 && this.params.getNumComponents() == 1) {
            return new FilteredImageSource(imageProducer, ExpandBitsImageFilter.theFilter);
        }
        return imageProducer;
    }

    public boolean canBlend() {
        return false;
    }

    public int getAlpha(int n) {
        return n >>> 24 & 0xFF;
    }

    public int[] getAlphaMask() {
        return this.params.getAlphaMask();
    }

    public boolean getAlphaPremultiplied() {
        return false;
    }

    public float[] getBlack() {
        throw new RuntimeException("PDFColorModel.getBlack() -- not implemented for " + this.toString());
    }

    public PDFColorModel getBlendModel() {
        return this;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public int getGreen(int n) {
        return n >>> 8 & 0xFF;
    }

    public abstract ColorModel getJavaColorModel();

    public int getNumComponents() {
        return this.params.getNumComponents();
    }

    public int getPDFColorModelComponentSize() {
        return this.params.getBitsPerComponent();
    }

    public int getPDFColorSpace() {
        return this.params.getPDFColorSpace();
    }

    public ColorValue getPaintColor() {
        return ColorValue.black;
    }

    public PDFColorParams getParams() {
        return this.params.getParams();
    }

    public int getRGB(float f) {
        throw new RuntimeException("PDFColorModel.getRGB(a) -- not implemented for " + this.toString());
    }

    public int getRGB(float f, float f2) {
        throw new RuntimeException("PDFColorModel.getRGB(a,b) -- not implemented for " + this.toString());
    }

    public int getRGB(float f, float f2, float f3) {
        throw new RuntimeException("PDFColorModel.getRGB(a,b,c) -- not implemented for " + this.toString());
    }

    public int getRGB(float f, float f2, float f3, float f4) {
        throw new RuntimeException("PDFColorModel.getRGB(a,b,c,d) -- not implemented for " + this.toString());
    }

    public int getRGB(float f, float f2, float f3, float f4, float f5) {
        throw new RuntimeException("PDFColorModel.getRGB(a,b,c,d,e) -- not implemented for " + this.toString());
    }

    public int getRGB(int n) {
        return n;
    }

    public int getRGB(float[] fArray) {
        throw new RuntimeException("PDFColorModel.getRGB(c[]) -- not implemented for " + this.toString());
    }

    public int getRed(int n) {
        return n >>> 16 & 0xFF;
    }

    public boolean setPaintColor(ColorValue colorValue) {
        return false;
    }

    public void toBlend(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray != byArray2 || n != n2) {
            System.arraycopy(byArray, n, byArray2, n2, n3);
        }
    }

    public void toRGB(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = this.getNumComponents();
        switch (n4) {
            case 1: {
                int n5 = 0;
                while (n5 < n3) {
                    nArray[n2 + n5] = byArray[n + n5] & 0xFF;
                    ++n5;
                }
                break;
            }
            case 3: {
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n2 + n6] = -16777216 + ((byArray[n] & 0xFF) << 16) + ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
                    n += 3;
                    ++n6;
                }
                break;
            }
            case 4: {
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n2 + n7] = ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
                    n += 4;
                    ++n7;
                }
                break;
            }
        }
    }
}

