/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.Content;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.GState;
import com.adobe.acrobat.pdf.ContentText;
import com.adobe.acrobat.pdf.Funct_DoubleQuote;
import com.adobe.acrobat.pdf.Funct_SingleQuote;
import com.adobe.acrobat.pdf.Funct_TextDoubleParam;
import com.adobe.acrobat.pdf.Funct_TextIntParam;
import com.adobe.acrobat.pdf.Funct_TextSimple;
import com.adobe.acrobat.pdf.Funct_Tf;
import com.adobe.acrobat.pdf.Funct_Tj;
import com.adobe.acrobat.pdf.Funct_Tm;
import com.adobe.acrobat.pdf.Funct_TwoParam;
import com.adobe.acrobat.pdf.Funct_cTJ;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Log;
import com.adobe.util.MemUtil;
import java.util.Hashtable;

public class TextExecuter {
    public static AffineTransform getCTM(Content content) {
        ContentText contentText = (ContentText)content;
        GState gState = contentText.getGState();
        AffineTransform affineTransform = gState.getCTM();
        return affineTransform;
    }

    public static double[] getCharOffsets(Content content) {
        ContentText contentText = (ContentText)content;
        return contentText.getLogicalOffsets();
    }

    public static PDFFont getFont(Content content) {
        ContentText contentText = (ContentText)content;
        return contentText.getFont();
    }

    public static FloatRect getFontBBox(Content content) {
        FloatRect floatRect;
        try {
            ContentText contentText = (ContentText)content;
            GState gState = contentText.getGState();
            double[] dArray = new double[4];
            double d = 0.0;
            PDFFont pDFFont = gState.getVFont().pdfFontValue(null);
            pDFFont.getBBox(dArray);
            d = pDFFont.unitsPerEM();
            dArray[0] = dArray[0] / d;
            dArray[2] = dArray[2] / d;
            dArray[1] = dArray[1] / d;
            dArray[3] = dArray[3] / d;
            floatRect = new FloatRect(dArray);
        }
        catch (Exception exception) {
            floatRect = null;
        }
        return floatRect;
    }

    public static String getText(Content content) {
        ContentText contentText = (ContentText)content;
        return contentText.getText();
    }

    public static FloatRect getTextBBox(Content content) throws Exception {
        ContentText contentText = (ContentText)content;
        GState gState = contentText.getGState();
        AffineTransform affineTransform = gState.getCTM();
        return ((ContentText)content).getBoundingBox(affineTransform);
    }

    public static FloatRect getTjBoundingBox(Object object, DrawContext drawContext, String string) throws Exception {
        return ((ContentText)object).getBoundingBox(drawContext.awtg.getCurrentTransform());
    }

    public static double getWordSpacing(Content content) {
        ContentText contentText = (ContentText)content;
        PDFFont pDFFont = contentText.getFont();
        GState gState = contentText.getGState();
        double d = gState.getCharSpacing() / gState.getFontSize() * 1000.0;
        double d2 = gState.getWordSpacing() / gState.getFontSize() * 1000.0;
        double d3 = 0.0;
        try {
            if (pDFFont.isCIDFont()) {
                boolean bl = pDFFont.getWMode() == 1;
                double[] dArray = MemUtil.allocDouble(4);
                pDFFont.getType0Widths(null, ' ', dArray, 0);
                d3 = dArray[0];
            } else {
                d3 = pDFFont.getLogicalCharWidth(null, ' ');
            }
        }
        catch (Exception exception) {
            d3 = 0.0;
        }
        return d3 + d + d2;
    }

    public static void loadme() {
        Log.clog("here");
    }

    public static void loadme(String string) {
        Log.clog("here" + string);
    }

    public static void populateOperators(Hashtable hashtable) {
        hashtable.put("BT", new Funct_TextSimple(1));
        hashtable.put("ET", new Funct_TextSimple(2));
        hashtable.put("Tc", new Funct_TextDoubleParam(2));
        hashtable.put("Td", new Funct_TwoParam(1));
        hashtable.put("TD", new Funct_TwoParam(2));
        hashtable.put("Tf", new Funct_Tf());
        hashtable.put("Tj", new Funct_Tj());
        hashtable.put("TJ", new Funct_cTJ());
        hashtable.put("TL", new Funct_TextDoubleParam(1));
        hashtable.put("Tm", new Funct_Tm());
        hashtable.put("Tr", new Funct_TextIntParam(1));
        hashtable.put("Ts", new Funct_TextDoubleParam(3));
        hashtable.put("Tw", new Funct_TextDoubleParam(4));
        hashtable.put("Tz", new Funct_TextDoubleParam(5));
        hashtable.put("T*", new Funct_TextSimple(3));
        hashtable.put("'", new Funct_SingleQuote());
        hashtable.put("\"", new Funct_DoubleQuote());
    }

    public static boolean textContainer(Content content) {
        return content instanceof ContentText;
    }
}

