/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdf;

import com.adobe.acrobat.page.ContentArray;
import com.adobe.acrobat.page.DrawContext;
import com.adobe.acrobat.page.VFormContentArray;
import com.adobe.acrobat.page.VXObjectFormProps;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AWTGraphics;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.BezierPath;
import com.adobe.acrobat.sidecar.ClipShape;
import com.adobe.acrobat.sidecar.ComplexPolygon;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.sidecar.SidecarImage;
import com.adobe.acrobat.util.SidecarPainting;
import com.adobe.pe.notify.Requester;
import java.awt.Image;

public class AppearancePainting
extends SidecarPainting {
    private static final String AP_K = "AP";
    private static final String Rect_K = "Rect";
    private static final String AS_K = "AS";
    private ContentArray contentArray;
    private AffineTransform drawTransform;
    private AffineTransform formMatrix;
    private FloatRect formBBox;

    public AppearancePainting(AffineTransform affineTransform, FloatRect floatRect, ContentArray contentArray, AffineTransform affineTransform2, FloatRect floatRect2, Requester requester) throws Exception {
        super(affineTransform, floatRect, false, false);
        this.contentArray = contentArray;
        this.formMatrix = affineTransform2;
        this.formBBox = floatRect2;
        FloatRect floatRect3 = this.formBBox.transformRect(this.formMatrix);
        double d = floatRect.width() / floatRect3.width();
        double d2 = floatRect.height() / floatRect3.height();
        this.drawTransform = this.formMatrix;
        this.drawTransform = this.drawTransform.scale(d, d2);
        floatRect3 = this.formBBox.transformRect(this.drawTransform);
        double d3 = this.formBBox.getxMin() - floatRect3.getxMin() + floatRect.getxMin();
        double d4 = this.formBBox.getyMin() - floatRect3.getyMin() + floatRect.getyMin();
        this.drawTransform = this.drawTransform.scale(d, d2);
        this.drawTransform = this.drawTransform.translate(d3, d4);
    }

    public AppearancePainting(AffineTransform affineTransform, FloatRect floatRect, PDFReference pDFReference, Requester requester) throws Exception {
        super(affineTransform, floatRect, false, false);
        PDFDict pDFDict = pDFReference.dictValue(requester);
        this.contentArray = VFormContentArray.getVFormContentArray(pDFReference).contentArrayValue(requester);
        this.formMatrix = VXObjectFormProps.getFormVMatrix(pDFReference).affineTransformValue(requester);
        this.formBBox = VXObjectFormProps.getFormVBBox(pDFReference).floatRectValue(requester);
        FloatRect floatRect2 = this.formBBox.transformRect(this.formMatrix);
        double d = floatRect.width() / floatRect2.width();
        double d2 = floatRect.height() / floatRect2.height();
        this.drawTransform = this.formMatrix;
        this.drawTransform = this.drawTransform.scale(d, d2);
        floatRect2 = this.formBBox.transformRect(this.drawTransform);
        double d3 = this.formBBox.getxMin() - floatRect2.getxMin() + floatRect.getxMin();
        double d4 = this.formBBox.getyMin() - floatRect2.getyMin() + floatRect.getyMin();
        this.drawTransform = this.drawTransform.translate(d3, d4);
    }

    public void draw(AWTGraphics aWTGraphics) throws Exception {
        Object object;
        AffineTransform affineTransform = this.drawTransform.appendTransform(aWTGraphics.getCurrentTransform());
        ClipShape clipShape = new ClipShape(null);
        clipShape.setClip(aWTGraphics.getClipShape());
        BezierPath bezierPath = new BezierPath(this.formBBox);
        bezierPath = bezierPath.transform(affineTransform);
        ComplexPolygon complexPolygon = bezierPath.flattenBezierPath();
        clipShape.setClip(complexPolygon, 1);
        Image image = aWTGraphics.getImage();
        if (image instanceof SidecarImage) {
            object = (SidecarImage)image;
            ((SidecarImage)object).erase();
        }
        object = new DrawContext(aWTGraphics, affineTransform, clipShape);
        this.contentArray.draw((DrawContext)object);
        this.contentArray.throwOnError();
    }
}

