/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.page;

import com.adobe.acrobat.pdf.VPDFFloatRect;
import com.adobe.acrobat.pdf.VPDFTransform;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.util.Assert;

public class VXObjectFormProps
implements ExtensionDataProvider {
    public static final String BBox_K = "BBox";
    public static final String Matrix_K = "Matrix";
    private static final String FormBBox_K = "FormBBox";
    private static final String FormMatrix_K = "FormMatrix";
    private static ExtensionDataProvider provider = null;

    public static VFloatRect getFormVBBox(PDFReference pDFReference) throws Exception {
        VXObjectFormProps.initProvider();
        return (VFloatRect)pDFReference.getExtensionData(FormBBox_K);
    }

    public static VAffineTransform getFormVMatrix(PDFReference pDFReference) throws Exception {
        VXObjectFormProps.initProvider();
        return (VAffineTransform)pDFReference.getExtensionData(FormMatrix_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new VXObjectFormProps();
            Extension.registerProvider(FormBBox_K, provider);
            Extension.registerProvider(FormMatrix_K, provider);
        }
    }

    public Object provide(String string, Extensible extensible) {
        Assert.notFalse(extensible instanceof PDFReference);
        PDFReference pDFReference = (PDFReference)extensible;
        if (string.equals(FormBBox_K)) {
            return new VFormBBox(pDFReference);
        }
        if (string.equals(FormMatrix_K)) {
            return new VFormMatrix(pDFReference);
        }
        throw new ProviderNotFoundException(string);
    }

    static class VFormBBox
    extends VFloatRect {
        private PDFReference pdfRef;

        VFormBBox(PDFReference pDFReference) {
            this.pdfRef = pDFReference;
        }

        protected final FloatRect computeFloatRect(Requester requester) throws Exception {
            PDFReference pDFReference = this.pdfRef.dictValue(requester).get(VXObjectFormProps.BBox_K).pdfReferenceValue(requester);
            FloatRect floatRect = VPDFFloatRect.getVPDFFloatRect(pDFReference).floatRectValue(requester);
            return floatRect;
        }
    }

    static class VFormMatrix
    extends VAffineTransform {
        private PDFReference pdfRef;

        VFormMatrix(PDFReference pDFReference) {
            this.pdfRef = pDFReference;
        }

        protected final AffineTransform computeAffineTransform(Requester requester) throws Exception {
            PDFDict pDFDict = this.pdfRef.dictValue(requester);
            if (pDFDict.hasKey(VXObjectFormProps.Matrix_K)) {
                PDFReference pDFReference = pDFDict.get(VXObjectFormProps.Matrix_K).pdfReferenceValue(requester);
                AffineTransform affineTransform = VPDFTransform.getVPDFTransform(pDFReference).affineTransformValue(requester);
                return affineTransform;
            }
            return AffineTransform.getIdentityMatrix();
        }
    }
}

