/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.PageLayoutUIVerb;
import com.adobe.acrobat.gui.VPageLayoutUIElementGroup;
import com.adobe.acrobat.gui.VZoomUIElementGroup;
import com.adobe.acrobat.gui.ZoomUIVerb;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.util.Assert;

public class ViewModes {
    public static final int kShort = 1;
    public static final int kMedium = 2;
    private static final String VPageLayoutUIElementGroup_K = "VPageLayoutUIElementGroup";
    private static final String VZoomUIElementGroupShort_K = "VZoomUIElementGroupShort";
    private static final String VZoomUIElementGroupMedium_K = "VZoomUIElementGroupMedium";
    private static ExtensionDataProvider provider = null;

    public static VUIElement getVPageLayoutUIElementGroup(AcroViewContext acroViewContext) throws Exception {
        ViewModes.initProvider();
        return (VUIElement)acroViewContext.getExtensionData(VPageLayoutUIElementGroup_K);
    }

    public static VUIElement getVZoomUIElementGroup(AcroViewContext acroViewContext, int n) throws Exception {
        ViewModes.initProvider();
        if (n == 1) {
            return (VUIElement)acroViewContext.getExtensionData(VZoomUIElementGroupShort_K);
        }
        if (n == 2) {
            return (VUIElement)acroViewContext.getExtensionData(VZoomUIElementGroupMedium_K);
        }
        throw new IllegalArgumentException();
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    AcroViewContext acroViewContext = (AcroViewContext)extensible;
                    if (string.equals(ViewModes.VPageLayoutUIElementGroup_K)) {
                        return new VPageLayoutUIElementGroup(acroViewContext);
                    }
                    if (string.equals(ViewModes.VZoomUIElementGroupShort_K)) {
                        return new VZoomUIElementGroup(acroViewContext, 1);
                    }
                    if (string.equals(ViewModes.VZoomUIElementGroupMedium_K)) {
                        return new VZoomUIElementGroup(acroViewContext, 2);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPageLayoutUIElementGroup_K, provider);
            Extension.registerProvider(VZoomUIElementGroupShort_K, provider);
            Extension.registerProvider(VZoomUIElementGroupMedium_K, provider);
        }
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        ZoomUIVerb.registerCommands(acroViewContext);
        PageLayoutUIVerb.registerCommands(acroViewContext);
    }
}

