/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.file.ByteArraySource;
import com.adobe.acrobat.file.FileByteArraySourceSpace;
import com.adobe.acrobat.file.URLByteArraySourceSpace;
import com.adobe.acrobat.file.VByteArraySource;
import com.adobe.acrobat.gui.AboutDialog;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.Authenticator;
import com.adobe.acrobat.gui.BasicPanel;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.DocInfo;
import com.adobe.acrobat.gui.ErrorDialog;
import com.adobe.acrobat.gui.FindDialog;
import com.adobe.acrobat.gui.FullScreenVerb;
import com.adobe.acrobat.gui.KeyBindings;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.TransactionDialog;
import com.adobe.acrobat.gui.URLDialog;
import com.adobe.acrobat.gui.ViewerFrame;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.util.Assert;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Properties;
import netscape.security.PrivilegeManager;

public class SimpleUIVerb
extends UIVerb
implements ViewerCommand {
    public static final int kNewWindow = 1;
    public static final int kOpenFile = 2;
    public static final int kOpenURL = 3;
    public static final int kCloseWindow = 4;
    public static final int kPreferences = 5;
    public static final int kAbout = 6;
    public static final int kBindings = 7;
    public static final int kOpenHelpFile = 8;
    public static final int kOpenLicenseFile = 9;
    public static final int kToFullScreen = 10;
    public static final int kFromFullScreen = 11;
    public static final int kAlwaysEnabledCutOff = 12;
    public static final int kPageOnly = 13;
    public static final int kShowBookmarks = 14;
    public static final int kToggleBookmarks = 15;
    public static final int kShowThumbs = 16;
    public static final int kReload = 17;
    public static final int kFind = 18;
    public static final int kDocInfo = 19;
    public static final int kFindNext = 20;
    private static KeyBindings keyBindings;
    private static final String VDocIsOpenBoolean_K = "VDocIsOpenBoolean";
    private static ExtensionDataProvider provider;
    AcroViewContext context;
    int selector;

    static {
        provider = null;
    }

    public SimpleUIVerb(int n, AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        this.selector = n;
        SimpleUIVerbTransactor simpleUIVerbTransactor = new SimpleUIVerbTransactor();
        VBoolean vBoolean = n > 12 ? SimpleUIVerb.getVDocIsOpenBoolean(acroViewContext) : null;
        this.setAttributes(simpleUIVerbTransactor, vBoolean, null);
    }

    public static VBoolean getVDocIsOpenBoolean(AcroViewContext acroViewContext) {
        SimpleUIVerb.initProvider();
        return (VBoolean)acroViewContext.getExtensionData(VDocIsOpenBoolean_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    if (string.equals(SimpleUIVerb.VDocIsOpenBoolean_K)) {
                        AcroViewContext acroViewContext = (AcroViewContext)extensible;
                        return new VDocIsOpenBoolean(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VDocIsOpenBoolean_K, provider);
        }
    }

    public static void openFileWithUI(Transaction transaction, AcroViewContext acroViewContext) throws Exception {
        Object object;
        Object object2;
        Frame frame = PEUtil.getFrame(acroViewContext.getRootComponent());
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        FileDialog fileDialog = new FileDialog(frame, Util.getDialogString("OpenFile:Title"), 0);
        Component component = acroViewContext.getPageView().getDisplayComponent();
        if (component != null) {
            object2 = (BasicPanel)component.getParent();
            object = PEUtil.getFrame((Component)object2).getLocation();
            object = new Point(((Point)object).x < 0 ? 0 : ((Point)object).x, ((Point)object).y < 0 ? 0 : ((Point)object).y);
            ((Component)fileDialog).setLocation((Point)object);
            fileDialog.addComponentListener(new ComponentAdapter((BasicPanel)object2){
                private final /* synthetic */ BasicPanel val$bp;
                {
                    this.val$bp = basicPanel;
                }

                public void componentShown(ComponentEvent componentEvent) {
                    this.val$bp.ignoreEscAndEnter();
                }
            });
        } else {
            object2 = frame.getLocation();
            object2 = new Point(((Point)object2).x < 0 ? 0 : ((Point)object2).x, ((Point)object2).y < 0 ? 0 : ((Point)object2).y);
            ((Component)fileDialog).setLocation((Point)object2);
        }
        String string = ReaderPrefs.fFileOpenDirectory;
        Log.clog("Open File Dialog - " + string + " - " + string.length());
        if (string == null || string.length() == 0) {
            object2 = System.getProperties();
            string = ((Properties)object2).getProperty("user.home", ((Properties)object2).getProperty("java.home"));
            Log.clog("******* " + string);
            if (string == null) {
                string = "";
            } else {
                fileDialog.setDirectory(string);
            }
        } else {
            fileDialog.setDirectory(string);
        }
        String string2 = ReaderPrefs.fFileOpenFile;
        if (!string2.equals("")) {
            fileDialog.setFile(string2);
        }
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            boolean bl;
            Object object3;
            object2 = fileDialog.getDirectory();
            object = fileDialog.getFile();
            String string3 = String.valueOf(object2) + (String)object;
            Log.clog(String.valueOf(object2) + " : " + (String)object + " : " + string3);
            try {
                object3 = new File(string3);
                bl = ((String)object).length() > 0 && ((File)object3).isFile() && ((File)object3).canRead();
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                object3 = FileByteArraySourceSpace.createFileByteArraySource(string3);
                acroViewContext.setByteArraySource(transaction, (ByteArraySource)object3);
                ReaderPrefs.fFileOpenDirectory = object2;
                ReaderPrefs.fFileOpenFile = object;
            } else {
                new ErrorDialog(frame, Util.getErrorString("Error:File:FileReadProblem", string3));
            }
        }
    }

    public void openHelpFile(Transaction transaction, AcroViewContext acroViewContext) throws Exception {
        String string = ReaderPrefs.fHelpFileURL;
        URL uRL = new URL(string);
        ByteArraySource byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL);
        acroViewContext.setByteArraySource(transaction, byteArraySource);
    }

    public void openLicenseFile(Transaction transaction, AcroViewContext acroViewContext) throws Exception {
        String string = ReaderPrefs.fLicenseFileURL;
        URL uRL = new URL(string);
        ByteArraySource byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL);
        acroViewContext.setByteArraySource(transaction, byteArraySource);
    }

    public void openNewWindow(Transaction transaction) throws Exception {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalTopLevelWindow");
        }
        PDFObjStore pDFObjStore = this.context.getPDFObjStore(transaction);
        AcroViewContext acroViewContext = new AcroViewContext(transaction, pDFObjStore);
        ViewerFrame viewerFrame = new ViewerFrame(acroViewContext, transaction);
        viewerFrame.show();
    }

    public void openURLWithUI(Transaction transaction) throws Exception {
        URLDialog uRLDialog = TransactionDialog.getURLDialog(this.context);
        uRLDialog.show(transaction);
        URL uRL = uRLDialog.getURL();
        if (uRL != null && !uRLDialog.didUserCancel()) {
            ByteArraySource byteArraySource = null;
            Object var5_5 = null;
            if (uRL.getProtocol().equals("http")) {
                Authenticator authenticator = new Authenticator(uRL, PEUtil.getFrame(this.context.getRootComponent()));
                if (!authenticator.didUserCancel()) {
                    byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL, authenticator);
                }
            } else {
                byteArraySource = URLByteArraySourceSpace.createURLByteArraySource(uRL);
            }
            if (byteArraySource != null) {
                this.context.setByteArraySource(transaction, byteArraySource);
                ReaderPrefs.addToHistory(uRL.toString());
            }
        }
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(new SimpleUIVerb(2, acroViewContext), acroViewContext, "Open");
        CommandRegistry.addCommand(new SimpleUIVerb(3, acroViewContext), acroViewContext, "OpenURL");
        CommandRegistry.addCommand(new SimpleUIVerb(1, acroViewContext), acroViewContext, "Window");
        CommandRegistry.addCommand(new SimpleUIVerb(4, acroViewContext), acroViewContext, "Close");
        CommandRegistry.addCommand(new SimpleUIVerb(5, acroViewContext), acroViewContext, "GeneralPrefs");
        CommandRegistry.addCommand(new SimpleUIVerb(6, acroViewContext), acroViewContext, "About");
        CommandRegistry.addCommand(new SimpleUIVerb(17, acroViewContext), acroViewContext, "Reload");
        CommandRegistry.addCommand(new SimpleUIVerb(18, acroViewContext), acroViewContext, "Find");
        CommandRegistry.addCommand(new SimpleUIVerb(20, acroViewContext), acroViewContext, "FindAgain");
        CommandRegistry.addCommand(new SimpleUIVerb(19, acroViewContext), acroViewContext, "DocInfo");
        CommandRegistry.addCommand(new SimpleUIVerb(7, acroViewContext), acroViewContext, "ListBindings");
        CommandRegistry.addCommand(new SimpleUIVerb(8, acroViewContext), acroViewContext, "OpenHelpFile");
        CommandRegistry.addCommand(new SimpleUIVerb(9, acroViewContext), acroViewContext, "OpenLicenseFile");
        FullScreenVerb.registerCommands(acroViewContext);
        CommandRegistry.addCommand(new SimpleUIVerb(10, acroViewContext), acroViewContext, "FullScreen");
        CommandRegistry.addCommand(new SimpleUIVerb(10, acroViewContext), acroViewContext, "ToFullScreen");
        CommandRegistry.addCommand(new SimpleUIVerb(11, acroViewContext), acroViewContext, "FromFullScreen");
    }

    public void reload(Transaction transaction) throws Exception {
        VByteArraySource vByteArraySource = this.context.getVByteArraySource();
        ByteArraySource byteArraySource = vByteArraySource.byteArraySourceValue(transaction);
        this.context.setByteArraySource(transaction, byteArraySource);
    }

    class SimpleUIVerbTransactor
    extends Transactor {
        SimpleUIVerbTransactor() {
        }

        protected void buildChanges(Transaction transaction) throws Exception {
            switch (SimpleUIVerb.this.selector) {
                case 1: {
                    SimpleUIVerb.this.openNewWindow(transaction);
                    break;
                }
                case 2: {
                    SimpleUIVerb.openFileWithUI(transaction, SimpleUIVerb.this.context);
                    break;
                }
                case 3: {
                    SimpleUIVerb.this.openURLWithUI(transaction);
                    break;
                }
                case 4: {
                    Component component = SimpleUIVerb.this.context.getRootComponent();
                    if (component.getParent() instanceof Window) {
                        CommandRegistry.executeCommand(transaction, SimpleUIVerb.this.context, "FromFullScreen");
                        component = SimpleUIVerb.this.context.getRootComponent();
                    }
                    if (!(component.getParent() instanceof ViewerFrame)) break;
                    SimpleUIVerb.this.context.setPDFObjStore(transaction, null);
                    ((ViewerFrame)component.getParent()).close(transaction);
                    break;
                }
                case 5: {
                    ReaderPrefs.handlePrefsDialog(SimpleUIVerb.this.context, transaction);
                    break;
                }
                case 6: {
                    AboutDialog aboutDialog = new AboutDialog(PEUtil.getFrame(SimpleUIVerb.this.context.getRootComponent()));
                    aboutDialog.setVisible(true);
                    break;
                }
                case 19: {
                    DocInfo docInfo = TransactionDialog.getDocInfoDialog(SimpleUIVerb.this.context);
                    docInfo.show(transaction);
                    break;
                }
                case 17: {
                    SimpleUIVerb.this.reload(transaction);
                    break;
                }
                case 18: {
                    FindDialog findDialog = FindDialog.getFindDialog(SimpleUIVerb.this.context);
                    findDialog.show(transaction, SimpleUIVerb.this.context);
                    break;
                }
                case 20: {
                    FindDialog findDialog = FindDialog.getFindDialog(SimpleUIVerb.this.context);
                    findDialog.show(transaction, SimpleUIVerb.this.context);
                    findDialog.findNext();
                    break;
                }
                case 8: {
                    SimpleUIVerb.this.openHelpFile(transaction, SimpleUIVerb.this.context);
                    break;
                }
                case 9: {
                    SimpleUIVerb.this.openLicenseFile(transaction, SimpleUIVerb.this.context);
                    break;
                }
                case 7: {
                    if (keyBindings == null) {
                        SimpleUIVerb.keyBindings = new KeyBindings(PEUtil.getFrame(SimpleUIVerb.this.context.getRootComponent()), SimpleUIVerb.this.context, transaction);
                    }
                    keyBindings.setVisible(true);
                    break;
                }
                case 10: {
                    SimpleUIVerb.this.context.getFullScreenVerb().toFullScreen(transaction);
                    break;
                }
                case 11: {
                    SimpleUIVerb.this.context.getFullScreenVerb().fromFullScreen(transaction);
                    break;
                }
            }
        }
    }

    private static class EndsWithFilter
    implements FilenameFilter {
        private String extension;

        public EndsWithFilter(String string) {
            this.extension = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            if (string.toLowerCase().endsWith(this.extension)) {
                return true;
            }
            return new File(file, string).isDirectory();
        }
    }

    static class VDocIsOpenBoolean
    extends VBoolean {
        AcroViewContext context;

        VDocIsOpenBoolean(AcroViewContext acroViewContext) {
            this.context = acroViewContext;
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            PDFObjStore pDFObjStore = this.context.getPDFObjStore(requester);
            return pDFObjStore != null;
        }
    }
}

