/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.AlphabetizedProperties;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.PrefsDialog;
import com.adobe.acrobat.gui.TerminalErrorDialog;
import com.adobe.acrobat.gui.TransactionDialog;
import com.adobe.acrobat.gui.VZoomValueSpec;
import com.adobe.acrobat.gui.ZoomValueSpec;
import com.adobe.acrobat.util.FontCache;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VDouble;
import com.adobe.pe.vtypes.VInt;
import com.adobe.pe.vtypes.VString;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class ReaderPrefs {
    private static final String AdobeHeader_PK = "com.adobe.acrobat.";
    private static final String Width_PK = "Width";
    private static final String Height_PK = "Height";
    private static final String Location_PK = "Location";
    private static final String DefPageLayout_PK = "Default_Page_Layout";
    private static final String DefZoomType_PK = "Default_Zoom_Type";
    private static final String DefMagnification_PK = "Default_Magnification";
    private static final String MaxMagnification_PK = "Max_Magnification";
    private static final String SubstitutionFonts_PK = "Substitution_Fonts";
    private static final String PageUnits_PK = "Page_Units";
    private static final String DisplayLarge_PK = "Display_Large";
    private static final String GreekText_PK = "Greek_Text";
    private static final String GreekTextLimit_PK = "Greek_Text_Limit";
    private static final String DisplayOpenDialog_PK = "Display_Open_Dialog";
    private static final String FileOpenDirectory_PK = "Open_Dialog_Directory";
    private static final String FileOpenFile_PK = "Open_Dialog_File";
    private static final String ShrinkToFit_PK = "Shrink_To_Fit";
    private static final String FaxFineMode_PK = "Fax_Fine_Mode";
    private static final String ServerHome_PK = "Server_Home";
    private static final String LastFaxNumber_PK = "Last_Fax_Number";
    private static final String LastPrinter_PK = "Last_Printer";
    private static final String UseIronCity_PK = "Use_Print_Server";
    private static final String PrintMethodKnown_PK = "Print_Method_Known";
    private static final String GetPrinterScript_PK = "Server_Printers";
    private static final String ServerPrintScript_PK = "Server_Print";
    private static final String SitePrefsURL_PK = "SitePreferencesURL";
    private static final String HelpFileURL_PK = "HelpFileURL";
    private static final String LicenseFileURL_PK = "LicenseFileURL";
    private static final String MatchCase_PK = "Find:MatchCase";
    private static final String FindBackwards_PK = "Find:FindBackwards";
    private static final String FindWholeWord_PK = "Find:FindWholeWord";
    private static final String FindAll_PK = "Find:FindAll";
    private static final String BROWSER_PK = "Browser";
    public static Properties defaultPrefs;
    public static Properties sitePrefs;
    public static Properties readerPrefs;
    public static VInt fWidth;
    public static VInt fHeight;
    public static VInt fXOrg;
    public static VInt fYOrg;
    public static VString fDefPageLayout;
    public static VZoomValueSpec fDefaultZoom;
    public static VDouble fMaxVisibleZoom;
    public static VString fSubstitutionFont;
    public static VString fPageUnitsStr;
    public static VBoolean fDisplayLargeImages;
    public static VBoolean fGreekText;
    public static VInt fGreekTextLimit;
    public static VBoolean fShowOpenDialogOnStartup;
    static VBoolean fMatchCase;
    static VBoolean fFindBackwards;
    static VBoolean fFindWholeWord;
    static VBoolean fFindAll;
    public static String fFileOpenDirectory;
    public static String fFileOpenFile;
    public static boolean fUsePrintServer;
    public static boolean fPrintMethodKnown;
    public static boolean fShrinkToFit;
    public static boolean fFaxFineMode;
    public static String fLastFaxNumber;
    public static String fLastPrinter;
    public static String fPrintServerPath;
    public static String fPrintServerGetPrinters;
    public static String fPrintServerPrint;
    public static String fSitePrefsURL;
    public static String fHelpFileURL;
    public static String fHelpFileURL_system;
    public static String fLicenseFileURL;
    public static String fLicenseFileURL_system;
    public static String fBrowser;
    private static boolean createCache;
    private static boolean enableProxy;
    public static String fSystemOSName;
    private static String fPrefsFileName;
    private static final String FTP_PROXY_HOST = "ftpProxyHost";
    private static final String FTP_PROXY_PORT = "ftpProxyPort";
    private static final String FTP_PROXY_SET = "ftpProxySet";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static String fFtpProxyHost;
    public static String fFtpProxyHost_system;
    public static String fFtpProxyPort;
    public static String fFtpProxyPort_system;
    public static boolean fFtpProxySet;
    public static boolean fFtpProxySet_system;
    public static String fHttpNonProxyHosts;
    public static String fHttpNonProxyHosts_system;
    public static String fHttpProxyHost;
    public static String fHttpProxyHost_system;
    public static String fHttpProxyPort;
    public static String fHttpProxyPort_system;
    private static int kMaxHistory;
    private static Vector history;
    private static final String HistoryPrefix_K = "com.adobe.acrobat.history.";

    static {
        createCache = true;
        enableProxy = false;
        fSystemOSName = null;
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        Properties properties = System.getProperties();
        fFtpProxyHost_system = properties.getProperty(FTP_PROXY_HOST, "");
        fFtpProxyPort_system = properties.getProperty(FTP_PROXY_PORT, "");
        fFtpProxySet_system = properties.getProperty(FTP_PROXY_SET, "").equalsIgnoreCase("true");
        fHttpNonProxyHosts_system = properties.getProperty(HTTP_NON_PROXY_HOSTS, "");
        fHttpProxyHost_system = properties.getProperty(HTTP_PROXY_HOST, "");
        fHttpProxyPort_system = properties.getProperty(HTTP_PROXY_PORT, "");
        kMaxHistory = 19;
        history = new Vector(kMaxHistory);
    }

    public static void addAuthorization(URL uRL, String string) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.authorization." + uRL.getHost(), string);
    }

    public static void addToHistory(String string) {
        history.removeElement(string);
        history.insertElementAt(string, 0);
        if (history.size() > kMaxHistory) {
            history.setSize(kMaxHistory);
        }
    }

    public static void addUserKeymap(String string, String string2) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.keymap." + string2, string);
    }

    private static String booleanString(boolean bl) {
        if (bl) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public static void clearUserKeymaps() {
        Enumeration enumeration = ((Hashtable)readerPrefs).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("com.adobe.acrobat.keymap.")) continue;
            ((Hashtable)readerPrefs).remove(string);
        }
    }

    private static void finalError(String string, String string2) {
        new TerminalErrorDialog(Util.getErrorString(string, string2), ReaderPrefs.getEnableProxySettings());
    }

    public static String getAcrobatFontsSource() {
        return ReaderPrefs.getStringProperty("fontsource", null);
    }

    public static String getAuthorization(URL uRL) {
        return ReaderPrefs.getStringProperty("authorization." + uRL.getHost(), null);
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = ReaderPrefs.getStringProperty(string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static boolean getCacheFiles() {
        return createCache;
    }

    public static Properties getClientProperties() throws Exception {
        Properties properties = new Properties();
        ReaderPrefs.initialize();
        ReaderPrefs.updatePrefs();
        ((Hashtable)properties).put(DefPageLayout_PK, ReaderPrefs.getStringProperty(DefPageLayout_PK));
        ((Hashtable)properties).put(DefZoomType_PK, ReaderPrefs.getStringProperty(DefZoomType_PK));
        ((Hashtable)properties).put(DefMagnification_PK, ReaderPrefs.getStringProperty(DefMagnification_PK));
        ((Hashtable)properties).put(MaxMagnification_PK, ReaderPrefs.getStringProperty(MaxMagnification_PK));
        ((Hashtable)properties).put(SubstitutionFonts_PK, ReaderPrefs.getStringProperty(SubstitutionFonts_PK));
        ((Hashtable)properties).put(PageUnits_PK, ReaderPrefs.getStringProperty(PageUnits_PK));
        ((Hashtable)properties).put(DisplayLarge_PK, ReaderPrefs.getStringProperty(DisplayLarge_PK));
        ((Hashtable)properties).put(GreekText_PK, ReaderPrefs.getStringProperty(GreekText_PK));
        ((Hashtable)properties).put(GreekTextLimit_PK, ReaderPrefs.getStringProperty(GreekTextLimit_PK));
        ((Hashtable)properties).put(ShrinkToFit_PK, ReaderPrefs.getStringProperty(ShrinkToFit_PK));
        ((Hashtable)properties).put(FaxFineMode_PK, ReaderPrefs.getStringProperty(FaxFineMode_PK));
        ((Hashtable)properties).put(UseIronCity_PK, ReaderPrefs.getStringProperty(UseIronCity_PK));
        ((Hashtable)properties).put(LastPrinter_PK, ReaderPrefs.getStringProperty(LastPrinter_PK));
        ((Hashtable)properties).put(PrintMethodKnown_PK, ReaderPrefs.getStringProperty(PrintMethodKnown_PK));
        ((Hashtable)properties).put(ServerHome_PK, ReaderPrefs.getStringProperty(ServerHome_PK));
        ((Hashtable)properties).put(GetPrinterScript_PK, ReaderPrefs.getStringProperty(GetPrinterScript_PK));
        ((Hashtable)properties).put(ServerPrintScript_PK, ReaderPrefs.getStringProperty(ServerPrintScript_PK));
        return properties;
    }

    private static double getDoubleProperty(String string, double d) {
        double d2;
        block2: {
            d2 = d;
            String string2 = ReaderPrefs.getStringProperty(string);
            if (string2 == null) break block2;
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public static boolean getEnableProxySettings() {
        return enableProxy;
    }

    private static String getHelpFileURL() {
        String string = ReaderPrefs.getStringProperty(HelpFileURL_PK, "help.pdf");
        if (string == null) {
            return fHelpFileURL_system;
        }
        if (string.startsWith("http:") || string.startsWith("file:")) {
            return string;
        }
        string = String.valueOf(Session.getTheSession().getApplicationBaseURLAsString()) + string;
        return string;
    }

    public static Vector getHistory() {
        return history;
    }

    private static int getIntegerProperty(String string, int n) {
        int n2;
        block2: {
            n2 = n;
            String string2 = ReaderPrefs.getStringProperty(string);
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public static Properties getKeymaps() {
        return ReaderPrefs.getKeymaps(readerPrefs.propertyNames());
    }

    private static Properties getKeymaps(Enumeration enumeration) {
        Properties properties = new Properties();
        try {
            ReaderPrefs.initialize();
            Enumeration enumeration2 = enumeration;
            while (enumeration2.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration2.nextElement();
                if (!string2.startsWith("com.adobe.acrobat.keymap.") || !CommandRegistry.isCommandAllowed(string = readerPrefs.getProperty(string2))) continue;
                ((Hashtable)properties).put(string2.substring("com.adobe.acrobat.keymap.".length()), string);
            }
        }
        catch (Exception exception) {}
        return properties;
    }

    private static String getLicenseFileURL() {
        String string = ReaderPrefs.getStringProperty(LicenseFileURL_PK, "License.pdf");
        if (string == null) {
            return fLicenseFileURL_system;
        }
        if (string.startsWith("http:") || string.startsWith("file:")) {
            return string;
        }
        string = String.valueOf(Session.getTheSession().getApplicationBaseURLAsString()) + string;
        return string;
    }

    private static Point getPointProperty(String string, int n, int n2) {
        String string2 = ReaderPrefs.getStringProperty(string);
        if (string2 != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2.trim(), "[,]", true);
                if (stringTokenizer.nextToken().equals("[")) {
                    String string3 = stringTokenizer.nextToken();
                    if (stringTokenizer.nextToken().equals(",")) {
                        String string4 = stringTokenizer.nextToken();
                        if (stringTokenizer.nextToken().equals("]")) {
                            int n3 = Integer.parseInt(string3);
                            int n4 = Integer.parseInt(string4);
                            n = n3;
                            n2 = n4;
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        return new Point(n, n2);
    }

    public static String getProperty(String string, String string2) {
        return readerPrefs.getProperty(string, string2);
    }

    private static String getSitePrefsURL() {
        String string = ReaderPrefs.getStringProperty(SitePrefsURL_PK, "");
        if (string.startsWith("http:") || string.startsWith("file:")) {
            return string;
        }
        string = String.valueOf(Session.getTheSession().getApplicationBaseURLAsString()) + "acrobat-site.properties";
        return string;
    }

    private static String getStringProperty(String string) {
        return readerPrefs.getProperty(AdobeHeader_PK + string);
    }

    private static String getStringProperty(String string, String string2) {
        return readerPrefs.getProperty(AdobeHeader_PK + string, string2);
    }

    public static Properties getSystemKeymaps() {
        return ReaderPrefs.getKeymaps(sitePrefs.propertyNames());
    }

    public static Properties getUserKeymaps() {
        return ReaderPrefs.getKeymaps(((Hashtable)readerPrefs).keys());
    }

    public static void handlePrefsDialog(AcroViewContext acroViewContext, Transaction transaction) throws Exception {
        PrefsDialog prefsDialog = TransactionDialog.getPrefsDialog(acroViewContext);
        prefsDialog.show(transaction);
    }

    public static boolean hasUserAcceptedLicAgreement() {
        return !ReaderPrefs.getCacheFiles() || ReaderPrefs.getStringProperty("AcceptedLicAgreement", "false").equalsIgnoreCase("true");
    }

    public static void initialize() throws Exception {
        if (readerPrefs == null) {
            defaultPrefs = new Properties();
            sitePrefs = new Properties(defaultPrefs);
            readerPrefs = new Properties(sitePrefs);
            ReaderPrefs.readDefaultProperties();
            ReaderPrefs.readUserProperties();
            fSitePrefsURL = ReaderPrefs.getSitePrefsURL();
            ReaderPrefs.readSiteProperties();
            ReaderPrefs.readUserProperties();
            ReaderPrefs.readPrefs();
        }
    }

    private static void readDefaultProperties() throws Exception {
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
        }
        Log.clog("Read default properties file...");
        InputStream inputStream = Util.getResourceAsStream("acrobat-default.properties");
        defaultPrefs.load(inputStream);
        inputStream.close();
        if (((Hashtable)defaultPrefs).size() == 0) {
            throw new Exception("Corrupt default system properties file: acrobat-default.properties");
        }
    }

    public static void readHistory() {
        history.setSize(kMaxHistory);
        try {
            ReaderPrefs.initialize();
            Enumeration<?> enumeration = readerPrefs.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string;
                int n;
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(HistoryPrefix_K) || (n = Integer.parseInt(string = string2.substring(HistoryPrefix_K.length()))) >= kMaxHistory) continue;
                history.setElementAt(readerPrefs.getProperty(string2), n);
            }
            int n = history.size();
            while (n-- > 0) {
                if (history.elementAt(n) != null) continue;
                history.removeElementAt(n);
            }
        }
        catch (Exception exception) {}
    }

    public static void readPrefs() throws Exception {
        Serializable serializable;
        int n;
        if (ReaderPrefs.getCacheFiles()) {
            n = ReaderPrefs.getIntegerProperty(Width_PK, 400);
            if (n <= 0) {
                n = 400;
            }
            fWidth = new VInt(n);
            n = ReaderPrefs.getIntegerProperty(Height_PK, 400);
            if (n <= 0) {
                n = 400;
            }
            fHeight = new VInt(n);
            serializable = ReaderPrefs.getPointProperty(Location_PK, 50, 50);
            if (serializable.x < 0 || serializable.y < 0) {
                serializable.y = 50;
                serializable.x = 50;
            }
            fXOrg = new VInt(serializable.x);
            fYOrg = new VInt(serializable.y);
        } else {
            ReaderPrefs.setMaxFrame();
        }
        String string = ReaderPrefs.getStringProperty(DefPageLayout_PK, "SinglePage");
        if (!(string.equals("OneColumn") || string.equals("TwoColumn") || string.equals("TwoColumnLeft") || string.equals("TwoColumnRight"))) {
            string = "SinglePage";
        }
        fDefPageLayout = new VString(string);
        string = ReaderPrefs.getStringProperty(DefZoomType_PK, "FitPage");
        if (!(string.equals("FixedZoom") || string.equals("FitVisible") || string.equals("FitWidth") || string.equals("FitVisibleWidth") || string.equals("FitHeight") || string.equals("FitVisibleHeight"))) {
            string = "FitPage";
        }
        double d = ReaderPrefs.getDoubleProperty(DefMagnification_PK, 1.0);
        serializable = !string.equals("FixedZoom") ? new ZoomValueSpec(string) : (d < (double)PageView.kMinimumZoom ? new ZoomValueSpec(PageView.kMinimumZoom) : (d > (double)PageView.kMaximumZoom ? new ZoomValueSpec(PageView.kMaximumZoom) : new ZoomValueSpec(d)));
        fDefaultZoom = new VZoomValueSpec((ZoomValueSpec)serializable);
        d = ReaderPrefs.getDoubleProperty(MaxMagnification_PK, PageView.kMaximumZoom);
        if (d < (double)PageView.kMinimumZoom) {
            d = PageView.kMinimumZoom;
        } else if (d > (double)PageView.kMaximumZoom) {
            d = PageView.kMaximumZoom;
        }
        fMaxVisibleZoom = new VDouble(d);
        string = ReaderPrefs.getStringProperty(SubstitutionFonts_PK, "Sans&Serif");
        if (!string.equals("Sans") && !string.equals("Serif")) {
            string = "Sans&Serif";
        }
        fSubstitutionFont = new VString(string);
        string = ReaderPrefs.getStringProperty(PageUnits_PK, "Inches");
        if (!string.equals("Points") && !string.equals("Millimeters")) {
            string = "Inches";
        }
        fPageUnitsStr = new VString(string);
        fDisplayLargeImages = new VBoolean(ReaderPrefs.getBooleanProperty(DisplayLarge_PK, true));
        fGreekText = new VBoolean(ReaderPrefs.getBooleanProperty(GreekText_PK, true));
        n = ReaderPrefs.getIntegerProperty(GreekTextLimit_PK, 6);
        if (n < 0) {
            n = 0;
        }
        fGreekTextLimit = new VInt(n);
        fShowOpenDialogOnStartup = new VBoolean(ReaderPrefs.getBooleanProperty(DisplayOpenDialog_PK, true) && CommandRegistry.isCommandAllowed("Open"));
        fMatchCase = new VBoolean(ReaderPrefs.getBooleanProperty(MatchCase_PK, false));
        fFindBackwards = new VBoolean(ReaderPrefs.getBooleanProperty(FindBackwards_PK, false));
        fFindWholeWord = new VBoolean(ReaderPrefs.getBooleanProperty(FindWholeWord_PK, false));
        fFindAll = new VBoolean(ReaderPrefs.getBooleanProperty(FindAll_PK, false));
        fFileOpenDirectory = ReaderPrefs.getStringProperty(FileOpenDirectory_PK, "");
        fFileOpenFile = ReaderPrefs.getStringProperty(FileOpenFile_PK, "");
        fUsePrintServer = ReaderPrefs.getBooleanProperty(UseIronCity_PK, false);
        fPrintMethodKnown = ReaderPrefs.getBooleanProperty(PrintMethodKnown_PK, false);
        fShrinkToFit = ReaderPrefs.getBooleanProperty(ShrinkToFit_PK, true);
        fFaxFineMode = ReaderPrefs.getBooleanProperty(FaxFineMode_PK, true);
        fLastFaxNumber = ReaderPrefs.getStringProperty(LastFaxNumber_PK, "");
        fLastPrinter = ReaderPrefs.getStringProperty(LastPrinter_PK, "");
        fPrintServerPath = ReaderPrefs.getStringProperty(ServerHome_PK, "");
        fPrintServerGetPrinters = ReaderPrefs.getStringProperty(GetPrinterScript_PK, "");
        fPrintServerPrint = ReaderPrefs.getStringProperty(ServerPrintScript_PK, "");
        fBrowser = ReaderPrefs.getStringProperty(BROWSER_PK, "");
        fSitePrefsURL = ReaderPrefs.getSitePrefsURL();
        fHelpFileURL = ReaderPrefs.getHelpFileURL();
        fLicenseFileURL = ReaderPrefs.getLicenseFileURL();
        if (ReaderPrefs.getEnableProxySettings()) {
            ReaderPrefs.readProxySettings();
            ReaderPrefs.writeProxySettings();
        }
        ReaderPrefs.readHistory();
    }

    private static void readProxySettings() {
        fFtpProxyHost = readerPrefs.getProperty(FTP_PROXY_HOST, fFtpProxyHost_system);
        fFtpProxyPort = readerPrefs.getProperty(FTP_PROXY_PORT, fFtpProxyPort_system);
        fFtpProxySet = readerPrefs.getProperty(FTP_PROXY_SET, fFtpProxySet_system ? "true" : "false").equalsIgnoreCase("true");
        fHttpNonProxyHosts = readerPrefs.getProperty(HTTP_NON_PROXY_HOSTS, fHttpNonProxyHosts_system);
        fHttpProxyHost = readerPrefs.getProperty(HTTP_PROXY_HOST, fHttpProxyHost_system);
        fHttpProxyPort = readerPrefs.getProperty(HTTP_PROXY_PORT, fHttpProxyPort_system);
    }

    private static void readSiteProperties() throws Exception {
        if (fSitePrefsURL == null || fSitePrefsURL.trim().length() == 0) {
            return;
        }
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalConnect");
        }
        try {
            URL uRL = new URL(fSitePrefsURL);
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                Log.clog("Unable to read acrobat-site.properties file");
            } else {
                Log.clog("Read acrobat-site.properties file ...");
                sitePrefs.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Log.clog("unable to find/load acrobat-site.properties: " + fSitePrefsURL);
        }
    }

    private static void readUserProperties() throws Exception {
        if (!ReaderPrefs.getCacheFiles()) {
            return;
        }
        Session session = Session.getTheSession();
        if (session.isIE()) {
            PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
        } else if (session.isNetscape()) {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            PrivilegeManager.enablePrivilege((String)"UniversalPropertyRead");
        }
        fSystemOSName = System.getProperty("os.name");
        String string = System.getProperty("user.home");
        fPrefsFileName = String.valueOf(string) + File.separator + "acrobat.properties";
        String string2 = System.getProperty("user.dir");
        String string3 = "file://localhost/" + string2.replace(File.separatorChar, '/');
        fLicenseFileURL_system = String.valueOf(string3) + "/License.pdf";
        fHelpFileURL_system = String.valueOf(string3) + "/help.pdf";
        File file = new File(fPrefsFileName);
        if (file.exists() && file.canRead()) {
            Log.clog("Read user properties file:" + fPrefsFileName);
            FileInputStream fileInputStream = new FileInputStream(file);
            readerPrefs.load(fileInputStream);
            fileInputStream.close();
        }
    }

    public static void refreshSiteProperties() throws Exception {
        ((Hashtable)sitePrefs).clear();
        ReaderPrefs.readSiteProperties();
        ReaderPrefs.readPrefs();
    }

    public static String removeAuthorization(URL uRL) {
        return (String)((Hashtable)readerPrefs).remove("com.adobe.acrobat.authorization." + uRL.getHost());
    }

    private static void resetHelpSystem() {
        fHelpFileURL = fHelpFileURL_system;
        fLicenseFileURL = fLicenseFileURL_system;
    }

    private static void resetProxy() {
        fFtpProxyHost = fFtpProxyHost_system;
        fFtpProxyPort = fFtpProxyPort_system;
        fFtpProxySet = fFtpProxySet_system;
        fHttpNonProxyHosts = fHttpNonProxyHosts_system;
        fHttpProxyHost = fHttpProxyHost_system;
        fHttpProxyPort = fHttpProxyPort_system;
    }

    public static void restoreDefaults() throws Exception {
        boolean bl = ReaderPrefs.hasUserAcceptedLicAgreement();
        ((Hashtable)readerPrefs).clear();
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.Open_Dialog_Directory", fFileOpenDirectory);
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.Open_Dialog_File", fFileOpenFile);
        ReaderPrefs.setUserAcceptedLicAgreement(bl);
        ReaderPrefs.saveHistory();
        ReaderPrefs.resetProxy();
        ReaderPrefs.resetHelpSystem();
        ReaderPrefs.readPrefs();
    }

    private static void save(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        String string3 = readerPrefs.getProperty(string, "");
        String string4 = sitePrefs.getProperty(string);
        if (!string3.equals(string2)) {
            ((Hashtable)readerPrefs).put(string, string2);
        } else if (string4 != null && string4.equals(string3)) {
            ((Hashtable)readerPrefs).remove(string);
        }
    }

    public static void saveHistory() {
        int n = 0;
        while (n < history.size()) {
            ((Hashtable)readerPrefs).put(HistoryPrefix_K + n, history.elementAt(n));
            ++n;
        }
    }

    public static void setAcrobatFontsSource(String string) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.fontsource", string);
    }

    public static void setCacheFiles(boolean bl) {
        createCache = bl;
    }

    public static void setClientProperties(Transaction transaction, Hashtable hashtable) throws Exception {
        ZoomValueSpec zoomValueSpec;
        ReaderPrefs.initialize();
        String string = null;
        double d = -1.0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            zoomValueSpec = (ZoomValueSpec)enumeration.nextElement();
            String string2 = hashtable.get(zoomValueSpec).toString();
            if (string2 == null) continue;
            if (((Object)zoomValueSpec).equals(DefPageLayout_PK)) {
                if (!string2.equals("SinglePage") && !string2.equals("OneColumn") && !string2.equals("TwoColumn") && !string2.equals("TwoColumnLeft") && !string2.equals("TwoColumnRight")) continue;
                fDefPageLayout.setStringValue(transaction, string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(DefZoomType_PK)) {
                if (!string2.equals("FixedZoom") && !string2.equals("FitPage") && !string2.equals("FitWidth") && !string2.equals("FitVisibleWidth") && !string2.equals("FitHeight") && !string2.equals("FitVisibleHeight") && !string2.equals("FitVisible")) continue;
                string = string2;
                if (!string2.equals("FixedZoom")) continue;
                string = null;
                if (!(d < 0.0)) continue;
                d = 1.0;
                continue;
            }
            if (((Object)zoomValueSpec).equals(DefMagnification_PK)) {
                try {
                    double d2 = Double.valueOf(string2);
                    if (d2 < (double)PageView.kMinimumZoom) {
                        d2 = PageView.kMinimumZoom;
                    } else if (d2 > (double)PageView.kMaximumZoom) {
                        d2 = PageView.kMaximumZoom;
                    }
                    d = d2;
                    if (d2 == 1.0) continue;
                    string = null;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (((Object)zoomValueSpec).equals(MaxMagnification_PK)) {
                try {
                    int n = Integer.parseInt(string2);
                    if ((float)n < 100.0f * PageView.kMinimumZoom) {
                        n = (int)(100.0f * PageView.kMinimumZoom);
                    } else if ((float)n > 100.0f * PageView.kMaximumZoom) {
                        n = (int)(100.0f * PageView.kMaximumZoom);
                    }
                    fMaxVisibleZoom.setDoubleValue(transaction, (double)n / 100.0);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (((Object)zoomValueSpec).equals(SubstitutionFonts_PK)) {
                if (!string2.equals("Sans") && !string2.equals("Serif") && !string2.equals("Sans&Serif")) continue;
                fSubstitutionFont.setStringValue(transaction, string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(PageUnits_PK)) {
                if (!string2.equals("Points") && !string2.equals("Millimeters") && !string2.equals("Inches")) continue;
                fPageUnitsStr.setStringValue(transaction, string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(DisplayLarge_PK)) {
                fDisplayLargeImages.setBooleanValue(transaction, Boolean.valueOf(string2));
                continue;
            }
            if (((Object)zoomValueSpec).equals(GreekText_PK)) {
                fGreekText.setBooleanValue(transaction, Boolean.valueOf(string2));
                continue;
            }
            if (((Object)zoomValueSpec).equals(GreekTextLimit_PK)) {
                try {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        n = 0;
                    }
                    fGreekTextLimit.setIntValue(transaction, n);
                    if (n <= 0) continue;
                    fGreekText.setBooleanValue(transaction, true);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (((Object)zoomValueSpec).equals(PrintMethodKnown_PK)) {
                fPrintMethodKnown = Boolean.valueOf(string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(ShrinkToFit_PK)) {
                fShrinkToFit = Boolean.valueOf(string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(UseIronCity_PK)) {
                fUsePrintServer = Boolean.valueOf(string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(FaxFineMode_PK)) {
                fFaxFineMode = Boolean.valueOf(string2);
                continue;
            }
            if (((Object)zoomValueSpec).equals(ServerHome_PK)) {
                fPrintServerPath = string2;
                continue;
            }
            if (((Object)zoomValueSpec).equals(GetPrinterScript_PK)) {
                fPrintServerGetPrinters = string2;
                continue;
            }
            if (((Object)zoomValueSpec).equals(ServerPrintScript_PK)) {
                fPrintServerPrint = string2;
                continue;
            }
            if (((Object)zoomValueSpec).equals(LastPrinter_PK)) {
                fLastPrinter = string2;
                continue;
            }
            if (!((Object)zoomValueSpec).equals(LastFaxNumber_PK)) continue;
            fLastFaxNumber = string2;
        }
        zoomValueSpec = null;
        if (string != null) {
            zoomValueSpec = new ZoomValueSpec(string);
        } else if (d > 0.0) {
            zoomValueSpec = new ZoomValueSpec(d);
        }
        if (zoomValueSpec != null) {
            fDefaultZoom.setZoomValueSpecValue(transaction, zoomValueSpec);
        }
    }

    public static void setEnableProxySettings(boolean bl) {
        enableProxy = bl;
    }

    public static void setHeight(int n) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.Height", Integer.toString(n));
    }

    private static void setHelpSystem() {
    }

    public static void setLocation(Point point) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.Location", "[" + Integer.toString(point.x).trim() + "," + Integer.toString(point.y).trim() + "]");
    }

    private static void setMaxFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        fWidth = new VInt(dimension.width);
        fHeight = new VInt(dimension.height);
        fXOrg = new VInt(0);
        fYOrg = new VInt(0);
    }

    public static void setUserAcceptedLicAgreement(boolean bl) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.AcceptedLicAgreement", bl ? "true" : "false");
    }

    public static void setWidth(int n) {
        ((Hashtable)readerPrefs).put("com.adobe.acrobat.Width", Integer.toString(n));
    }

    private static void updatePrefs() throws Exception {
        ReaderPrefs.save("com.adobe.acrobat.Default_Page_Layout", fDefPageLayout.stringValue(null));
        ZoomValueSpec zoomValueSpec = fDefaultZoom.zoomValueSpecValue(null);
        ReaderPrefs.save("com.adobe.acrobat.Default_Zoom_Type", zoomValueSpec.zoomType);
        ReaderPrefs.save("com.adobe.acrobat.Default_Magnification", Double.toString(zoomValueSpec.zoomLevel));
        ReaderPrefs.save("com.adobe.acrobat.Max_Magnification", Double.toString(fMaxVisibleZoom.doubleValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Substitution_Fonts", fSubstitutionFont.stringValue(null));
        ReaderPrefs.save("com.adobe.acrobat.Page_Units", fPageUnitsStr.stringValue(null));
        ReaderPrefs.save("com.adobe.acrobat.Display_Large", ReaderPrefs.booleanString(fDisplayLargeImages.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Greek_Text", ReaderPrefs.booleanString(fGreekText.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Greek_Text_Limit", Integer.toString(fGreekTextLimit.intValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Display_Open_Dialog", ReaderPrefs.booleanString(fShowOpenDialogOnStartup.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Find:MatchCase", ReaderPrefs.booleanString(fMatchCase.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Find:FindWholeWord", ReaderPrefs.booleanString(fFindWholeWord.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Find:FindBackwards", ReaderPrefs.booleanString(fFindBackwards.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Find:FindAll", ReaderPrefs.booleanString(fFindAll.booleanValue(null)));
        ReaderPrefs.save("com.adobe.acrobat.Open_Dialog_Directory", fFileOpenDirectory);
        ReaderPrefs.save("com.adobe.acrobat.Open_Dialog_File", fFileOpenFile);
        ReaderPrefs.save("com.adobe.acrobat.Print_Method_Known", ReaderPrefs.booleanString(fPrintMethodKnown));
        ReaderPrefs.save("com.adobe.acrobat.Use_Print_Server", ReaderPrefs.booleanString(fUsePrintServer));
        ReaderPrefs.save("com.adobe.acrobat.Shrink_To_Fit", ReaderPrefs.booleanString(fShrinkToFit));
        ReaderPrefs.save("com.adobe.acrobat.Fax_Fine_Mode", ReaderPrefs.booleanString(fFaxFineMode));
        ReaderPrefs.save("com.adobe.acrobat.Last_Printer", fLastPrinter);
        ReaderPrefs.save("com.adobe.acrobat.Last_Fax_Number", fLastFaxNumber);
        ReaderPrefs.save("com.adobe.acrobat.Server_Home", fPrintServerPath);
        ReaderPrefs.save("com.adobe.acrobat.Server_Printers", fPrintServerGetPrinters);
        ReaderPrefs.save("com.adobe.acrobat.Server_Print", fPrintServerPrint);
        ReaderPrefs.save("com.adobe.acrobat.SitePreferencesURL", fSitePrefsURL);
        ReaderPrefs.save("com.adobe.acrobat.Browser", fBrowser);
        String string = "com.adobe.acrobat.HelpFileURL";
        if (fHelpFileURL.equals(fHelpFileURL_system)) {
            ((Hashtable)readerPrefs).remove(string);
        } else {
            ((Hashtable)readerPrefs).put(string, fHelpFileURL);
        }
        string = AdobeHeader_PK + fLicenseFileURL;
        if (fLicenseFileURL.equals(fLicenseFileURL_system)) {
            ((Hashtable)readerPrefs).remove(string);
        } else {
            ((Hashtable)readerPrefs).put(string, fLicenseFileURL);
        }
        if (ReaderPrefs.getEnableProxySettings()) {
            ReaderPrefs.save(FTP_PROXY_HOST, fFtpProxyHost);
            ReaderPrefs.save(FTP_PROXY_PORT, fFtpProxyPort);
            ReaderPrefs.save(FTP_PROXY_SET, fFtpProxySet ? "true" : "false");
            ReaderPrefs.save(HTTP_NON_PROXY_HOSTS, fHttpNonProxyHosts);
            ReaderPrefs.save(HTTP_PROXY_HOST, fHttpProxyHost);
            ReaderPrefs.save(HTTP_PROXY_PORT, fHttpProxyPort);
        }
        ReaderPrefs.saveHistory();
    }

    public static void writePrefs() {
        if (!ReaderPrefs.getCacheFiles()) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        File file = null;
        try {
            ReaderPrefs.initialize();
            Session session = Session.getTheSession();
            if (session.isIE()) {
                PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
            } else if (session.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalFileWrite");
                PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            }
            Log.clog("Saving the font cache...");
            FontCache.getTheFontCache().save();
            String string = FontCache.getTheFontCache().getSearchDirs();
            String string2 = FontCache.getTheFontCache().getFontIgnoreFileExtensionList();
            Log.clog(String.valueOf(String.valueOf(readerPrefs)) + " - " + string + " - " + string2);
            if (string != null && string2 != null) {
                ((Hashtable)readerPrefs).put("com.adobe.acrobat.util.fontDirectories", string);
                ((Hashtable)readerPrefs).put("com.adobe.acrobat.util.fontIgnoreExtensions", string2);
            }
            Log.clog("Completed saving the font cache...");
            file = new File(fPrefsFileName);
            if (file.exists() && !file.canWrite()) {
                Log.clog("Unable to write properties file. Please check file permissions for: " + file);
                ReaderPrefs.finalError("Error:PropertiesFileWriteFailed", fPrefsFileName);
            } else {
                Log.clog("ReaderPrefs.writePrefs: " + file);
                fileOutputStream = new FileOutputStream(file);
                Log.clog("updating prefs...");
                ReaderPrefs.updatePrefs();
                Log.clog("completed updating prefs...");
                AlphabetizedProperties alphabetizedProperties = new AlphabetizedProperties(readerPrefs);
                alphabetizedProperties.save(fileOutputStream, "com.adobe.acrobat.Viewer Properties");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            Log.clog("Unable to write to properties file: " + exception.toString());
            ReaderPrefs.finalError("Error:PropertiesFileWriteException", exception.toString());
        }
    }

    public static void writeProxySettings() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put(FTP_PROXY_HOST, fFtpProxyHost);
        ((Hashtable)properties).put(FTP_PROXY_PORT, fFtpProxyPort);
        ((Hashtable)properties).put(FTP_PROXY_SET, fFtpProxySet ? "true" : "false");
        ((Hashtable)properties).put(HTTP_NON_PROXY_HOSTS, fHttpNonProxyHosts);
        ((Hashtable)properties).put(HTTP_PROXY_HOST, fHttpProxyHost);
        ((Hashtable)properties).put(HTTP_PROXY_PORT, fHttpProxyPort);
        System.setProperties(properties);
    }
}

