/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.IronCityPrint;
import com.adobe.acrobat.gui.LocalPrintTask;
import com.adobe.acrobat.gui.PDFPrint;
import com.adobe.acrobat.gui.PrintProgressDialog;
import com.adobe.acrobat.gui.PrintUIVerb;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.VPrintUIElements;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.UIElementVerb;
import com.adobe.pe.awt.VUIElement;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.util.PEUtil;
import com.adobe.util.Assert;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.awt.Frame;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.PrivilegeManager;

public class PrintUI {
    static final String VPrintUIElements_K = "VPrintUIElements";
    static final String PrintUIElement_K = "PrintUIElement";
    private static ExtensionDataProvider provider = null;

    private static PrintJob getPrintJob(AcroViewContext acroViewContext, Properties properties, int n, int n2) {
        Frame frame = PEUtil.getFrame(PEUtil.getFrame(acroViewContext.getRootComponent()));
        String string = properties.getProperty("AcrobatSilentPrint", "false");
        boolean bl = string.equals("true");
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, Util.getDialogString("Print:LocalPrint"), properties);
        return printJob;
    }

    public static UIElementVerb getPrintUIElement(AcroViewContext acroViewContext) {
        PrintUI.initProvider();
        return (UIElementVerb)acroViewContext.getExtensionData(PrintUIElement_K);
    }

    public static VUIElement getVPrintUIElements(AcroViewContext acroViewContext) {
        PrintUI.initProvider();
        return (VUIElement)acroViewContext.getExtensionData(VPrintUIElements_K);
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    AcroViewContext acroViewContext = (AcroViewContext)extensible;
                    if (string.equals(PrintUI.VPrintUIElements_K)) {
                        return new VPrintUIElements(acroViewContext);
                    }
                    if (string.equals(PrintUI.PrintUIElement_K)) {
                        return new UIElementVerb(0, new PrintUIVerb(acroViewContext, 1), Util.getMenuVString("Print"), null, "print.gif");
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(VPrintUIElements_K, provider);
            Extension.registerProvider(PrintUIElement_K, provider);
        }
    }

    public static void printPages(Transaction transaction, AcroViewContext acroViewContext, Properties properties, int n, int n2) throws Exception {
        if (!acroViewContext.getPermission(transaction, "Print")) {
            return;
        }
        boolean bl = ReaderPrefs.fUsePrintServer;
        boolean bl2 = ReaderPrefs.fPrintMethodKnown;
        boolean bl3 = ReaderPrefs.fShrinkToFit;
        int n3 = acroViewContext.getPageView().getNumPages(transaction);
        if (n2 < n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > n3) {
            return;
        }
        if (n2 < n) {
            return;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (!bl2 || !properties.getProperty("AcrobatSilentPrint", "false").equals("true")) {
            ((Hashtable)properties).put("AcrobatSilentPrint", "false");
            PDFPrint pDFPrint = new PDFPrint(PEUtil.getFrame(acroViewContext.getRootComponent()), bl3, n, n2, n3);
            if (pDFPrint.okToPrint()) {
                n = pDFPrint.getFromPage();
                n2 = pDFPrint.getToPage();
                ReaderPrefs.fShrinkToFit = bl3 = pDFPrint.getShrinkToFit();
                bl2 = true;
                bl = pDFPrint.getActionCommand().equals("Print:PrintServer");
            } else {
                return;
            }
        }
        if (bl) {
            IronCityPrint ironCityPrint = new IronCityPrint(acroViewContext, properties, n, n2, n3);
            if (ironCityPrint.didUserCancel()) {
                return;
            }
        } else {
            try {
                Session session = Session.getTheSession();
                if (session.isIE()) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                } else if (session.isNetscape()) {
                    PrivilegeManager.enablePrivilege((String)"UniversalPrintJobAccess");
                }
                PrintJob printJob = PrintUI.getPrintJob(acroViewContext, properties, n, n2);
                if (printJob != null) {
                    PrintProgressDialog printProgressDialog = null;
                    if (!properties.getProperty("AcrobatSilentPrint", "false").equals("true")) {
                        printProgressDialog = new PrintProgressDialog(PEUtil.getFrame(acroViewContext.getRootComponent()));
                    }
                    LocalPrintTask localPrintTask = new LocalPrintTask(transaction, printProgressDialog, printJob, acroViewContext.getPDFObjStore(transaction), bl3, n, n2);
                    Thread thread = new Thread(localPrintTask);
                    thread.setPriority(thread.getPriority() - 1);
                    thread.start();
                }
            }
            catch (Exception exception) {
                Log.clog("netscape or User refused UniversalPrintJobAccess");
            }
        }
        ReaderPrefs.fPrintMethodKnown = bl2;
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        PrintUIVerb.registerCommands(acroViewContext);
    }
}

