/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.util.PEUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

public class PDFPrint {
    private PageRangeDialog fPageDialog = null;

    public PDFPrint(Frame frame, boolean bl, int n, int n2, int n3) {
        this.fPageDialog = new PageRangeDialog(PEUtil.getFrame(frame), bl, n, n2, n3);
        this.fPageDialog.setVisible(true);
    }

    public String getActionCommand() {
        return this.fPageDialog.getActionCommand();
    }

    public int getFromPage() {
        return this.fPageDialog.getStartPage();
    }

    public boolean getShrinkToFit() {
        return this.fPageDialog.getShrinkToFit();
    }

    public int getToPage() {
        return this.fPageDialog.getEndPage();
    }

    public boolean okToPrint() {
        return this.fPageDialog.didUserCancel() ^ true;
    }

    class PageRangeDialog
    extends BasicDialog {
        private boolean firstTime = true;
        private TextField fFromPage;
        private TextField fToPage;
        private Panel resizePanel;
        private int fStartPage;
        private int fEndPage;
        private int fMaxPages;
        private Button firstButton;
        private Button serverButton;
        private CheckboxGroup cbg;
        private Checkbox fFullRes;
        private Checkbox fShrink;

        public PageRangeDialog(Frame frame, boolean bl, int n, int n2, int n3) {
            super(frame, Util.getDialogString("Print:Title"), true);
            this.fStartPage = n;
            this.fEndPage = n2;
            this.fMaxPages = n3;
            boolean bl2 = ReaderPrefs.fUsePrintServer;
            this.ok.setLabel(Util.getDialogString("Print:PrintLocal"));
            this.ok.setActionCommand("Print:PrintLocal");
            Button button = this.ok;
            if (bl2) {
                this.serverButton = new Button(Util.getDialogString("Print:PrintServer"));
                this.serverButton.setActionCommand("Print:PrintServer");
                this.okCancelPanel.add((Component)this.serverButton, 0);
                this.serverButton.addActionListener(this);
                this.serverButton.addKeyListener(this);
                this.serverButton.addActionListener(this);
                this.serverButton.addKeyListener(this);
            }
            this.firstButton = ReaderPrefs.fUsePrintServer && this.serverButton != null ? this.serverButton : button;
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout(0, 5, 5));
            this.fFromPage = new TextField(String.valueOf(this.fStartPage), 4);
            this.fToPage = new TextField(String.valueOf(this.fEndPage), 4);
            panel.add(new Label(Util.getDialogString("Print:PrintPages")));
            panel.add(this.fFromPage);
            panel.add(new Label(Util.getDialogString("Print:FromTo")));
            panel.add(this.fToPage);
            this.fFromPage.addActionListener(this);
            this.fFromPage.addKeyListener(this);
            this.fToPage.addActionListener(this);
            this.fToPage.addKeyListener(this);
            this.resizePanel = new Panel();
            this.resizePanel.setLayout(new GridLayout(1, 2));
            this.cbg = new CheckboxGroup();
            this.fFullRes = new Checkbox(Util.getDialogString("Print:FullRes"), this.cbg, bl ^ true);
            this.fShrink = new Checkbox(Util.getDialogString("Print:ShrinkToFit"), this.cbg, bl);
            this.resizePanel.add(this.fFullRes);
            this.resizePanel.add(this.fShrink);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)panel, "North");
            this.add((Component)this.resizePanel, "Center");
            this.add((Component)this.okCancelPanel, "South");
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.serverButton) {
                this.actionCmd = actionEvent.getActionCommand();
                this.ok();
            } else {
                super.actionPerformed(actionEvent);
            }
        }

        private void doErrorDialog(String string) {
            MessageDialog messageDialog = new MessageDialog(PEUtil.getFrame(this), Util.getDialogString("Dialog:InvalidEntry"), Util.getDialogString("Dialog:NotValidFromTo", string, new Integer(1), new Integer(this.fMaxPages)));
            messageDialog.runDialog();
        }

        public int getEndPage() {
            return this.fEndPage;
        }

        public boolean getShrinkToFit() {
            return this.cbg != null && this.cbg.getSelectedCheckbox() == this.fShrink;
        }

        public int getStartPage() {
            return this.fStartPage;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getComponent() == this.fFromPage || keyEvent.getComponent() == this.fToPage) {
                this.ok.setEnabled(this.fFromPage.getText().length() > 0 && this.fToPage.getText().length() > 0);
                if (this.serverButton != null) {
                    this.serverButton.setEnabled(this.fFromPage.getText().length() > 0 && this.fToPage.getText().length() > 0);
                }
                if (keyEvent.getKeyCode() == 10) {
                    this.ok();
                }
            } else {
                super.keyReleased(keyEvent);
            }
        }

        public void ok() {
            if (this.validateFields()) {
                super.ok();
            }
        }

        public boolean validateFields() {
            int n;
            int n2;
            String string = this.fFromPage.getText();
            String string2 = this.fToPage.getText();
            String string3 = null;
            TextField textField = null;
            try {
                string3 = string;
                textField = this.fFromPage;
                Integer n3 = new Integer(string);
                n2 = n3;
                string3 = string2;
                textField = this.fToPage;
                n3 = new Integer(string2);
                n = n3;
            }
            catch (NumberFormatException numberFormatException) {
                this.doErrorDialog(string3);
                textField.selectAll();
                textField.requestFocus();
                return false;
            }
            if (n2 >= 1 && n2 <= n && n <= this.fMaxPages) {
                this.fStartPage = n2;
                this.fEndPage = n;
                return true;
            }
            if (n2 < 1) {
                n2 = 1;
                string3 = string;
                textField = this.fFromPage;
                this.fFromPage.setText(Integer.toString(n2));
            }
            if (n2 > this.fMaxPages) {
                n2 = this.fMaxPages;
                string3 = string;
                textField = this.fFromPage;
                this.fFromPage.setText(Integer.toString(n2));
            }
            if (n < n2) {
                n = n2;
                string3 = string2;
                if (textField == null) {
                    textField = this.fToPage;
                }
                this.fToPage.setText(Integer.toString(n));
            }
            if (n > this.fMaxPages) {
                n = this.fMaxPages;
                string3 = string2;
                if (textField == null) {
                    textField = this.fToPage;
                }
                this.fToPage.setText(Integer.toString(n));
            }
            this.doErrorDialog(string3);
            textField.selectAll();
            textField.requestFocus();
            return false;
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.firstTime) {
                this.firstButton.requestFocus();
            }
            this.firstTime = false;
        }
    }
}

