/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;

public class NotesFrame
extends Window
implements FocusListener {
    private static final int GAP = 2;
    private static final int MIN_WIDTH = 100;
    private static final int MIN_HEIGHT = 100;
    private Title title;
    private NotesText content;
    private Resizer resizer;
    private Insets insets = new Insets(2, 2, 2, 2);
    private boolean hasFocus = false;

    public NotesFrame(Frame frame) {
        super(frame);
        this.setLayout(new BorderLayout());
        this.title = new Title();
        this.content = new NotesText();
        this.resizer = new Resizer();
        this.add((Component)this.title, "North");
        this.add((Component)this.content, "Center");
        this.add((Component)this.resizer, "South");
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.title.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.title.repaint();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        Dimension dimension = this.getSize();
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 < 100) {
            n3 = 100;
        }
        if (n4 < 100) {
            n4 = 100;
        }
        super.setBounds(n, n2, n3, n4);
        this.invalidate();
        this.validate();
    }

    public void setContent(String string) {
        this.content.setText(string);
    }

    public void setTitle(String string) {
        this.title.setTitle(string);
    }

    public void setTitleColor(Color color) {
        this.title.setTitleColor(color);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.toFront();
        }
        super.setVisible(bl);
    }

    public class Resizer
    extends Canvas
    implements MouseMotionListener,
    MouseListener,
    FocusListener {
        private final int maxheight = 12;
        private final int sq = 4;
        private final int gap = 3;
        private Dimension minsize = new Dimension(100, 12);
        private int hotzone;

        public Resizer() {
            this.setBackground(SystemColor.control);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.addFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            NotesFrame.this.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            NotesFrame.this.focusLost(focusEvent);
        }

        public Dimension getMinimumSize() {
            return this.minsize;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getParent().getSize();
            if (dimension == null) {
                return this.minsize;
            }
            return new Dimension(dimension.width, 12);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= this.hotzone) {
                Point point = NotesFrame.this.getLocation();
                Point point2 = this.getLocation();
                Point point3 = mouseEvent.getPoint();
                NotesFrame.this.setBounds(point.x, point.y, point3.x + point2.x, point3.y + point2.y);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.getX() >= this.hotzone) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            this.hotzone = n - 4 - 3;
            Color color = this.getBackground();
            graphics.setColor(color.darker());
            graphics.drawLine(n - 4 - 3, n2 - 3, n - 3, n2 - 4 - 3);
            graphics.setColor(color.brighter());
            graphics.drawLine(n - 4 - 3 + 1, n2 - 3, n - 3, n2 - 4 - 3 + 1);
            graphics.setColor(color.darker());
            graphics.drawLine(n - 4 - 3 - 3, n2 - 3, n - 3, n2 - 4 - 3 - 3);
            graphics.setColor(color.brighter());
            graphics.drawLine(n - 4 - 3 - 3 + 1, n2 - 3, n - 3, n2 - 4 - 3 - 3 + 1);
            graphics.setColor(color.darker());
            graphics.drawLine(n - 4, n2 - 3, n - 3, n2 - 4);
            graphics.setColor(color.brighter());
            graphics.drawLine(n - 4 + 1, n2 - 3, n - 3, n2 - 4 + 1);
        }
    }

    public class NotesText
    extends TextArea
    implements FocusListener {
        private String delimiter = " ,.;:-()[]{}+=|/~!@#$%^&*_'<>`\"\n\r";
        private FontMetrics fm;
        private Font font = new Font("SanSerif", 0, 12);
        private String text;
        private String NEWLINE = "\r\n";
        private String oldText = "";

        public NotesText() {
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.setFont(this.font);
            this.addFocusListener(this);
            ((Component)this).setBackground(Color.white);
            this.setEditable(false);
        }

        public void focusGained(FocusEvent focusEvent) {
            NotesFrame.this.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            NotesFrame.this.focusLost(focusEvent);
        }

        private boolean isDelimiter(String string) {
            return string.length() == 1 && this.delimiter.indexOf(string) != -1;
        }

        private boolean isLF(String string) {
            return string.equals("\n");
        }

        private boolean isReturn(String string) {
            return string.equals("\r");
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            this.wrapText();
            super.setBounds(n, n2, n3, n4);
        }

        public void setText(String string) {
            this.text = string;
        }

        private void wrapText() {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, this.delimiter, true);
            String string = "";
            String string2 = "";
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (this.isLF(string3)) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    bl = false;
                    string = String.valueOf(string) + string2 + this.NEWLINE;
                    string2 = "";
                    continue;
                }
                if (this.isReturn(string3)) {
                    bl = true;
                    string = String.valueOf(string) + string2 + this.NEWLINE;
                    string2 = "";
                    continue;
                }
                bl = true;
                int n = NotesFrame.this.getSize().width - 15;
                int n2 = this.fm.stringWidth(String.valueOf(string2) + string3);
                int n3 = this.fm.stringWidth(string3);
                if (n2 > n) {
                    string = String.valueOf(string) + string2 + this.NEWLINE;
                    string2 = string3;
                    continue;
                }
                string2 = String.valueOf(string2) + string3;
            }
            if (string2.length() > 1) {
                string = String.valueOf(string) + string2;
            }
            if (!string.equals(this.oldText)) {
                this.oldText = string;
                super.setText(string);
            }
        }
    }

    public class Title
    extends Canvas
    implements MouseMotionListener,
    FocusListener {
        private String title;
        private Rectangle controlBounds;
        private Point lastPoint = new Point(0, 0);
        private Font font = new Font("SanSerif", 0, 12);
        private Color titleColor = Color.yellow;

        public Title() {
            this.controlBounds = new Rectangle();
            this.addMouseMotionListener(this);
            this.addFocusListener(this);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Title this$1;
                {
                    this.this$1 = title;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    Title.access$0(this.this$1).focusGained(null);
                    if (Title.access$1(this.this$1).contains(mouseEvent.getPoint())) {
                        Title.access$0(this.this$1).setVisible(false);
                    }
                    mouseEvent.consume();
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }

        static /* synthetic */ NotesFrame access$0(Title title) {
            return title.NotesFrame.this;
        }

        static /* synthetic */ Rectangle access$1(Title title) {
            return title.controlBounds;
        }

        public void focusGained(FocusEvent focusEvent) {
            NotesFrame.this.focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            NotesFrame.this.focusLost(focusEvent);
        }

        public Dimension getPreferredSize() {
            return new Dimension(20, 20);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = NotesFrame.this.getLocation();
            Point point2 = mouseEvent.getPoint();
            int n = point2.x - this.lastPoint.x;
            int n2 = point2.y - this.lastPoint.y;
            int n3 = point.x + n;
            int n4 = point.y + n2;
            ((Component)NotesFrame.this).setLocation(n3, n4);
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.lastPoint = mouseEvent.getPoint();
        }

        public void paint(Graphics graphics) {
            Color color;
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            this.controlBounds.setBounds(0, 0, 20, n2 - 2);
            Color color2 = color = this.titleColor.getBlue() > 128 ? Color.white : Color.black;
            if (this.titleHasFocus()) {
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, 21, n2 - 1);
                graphics.setColor(SystemColor.menu);
                graphics.fillRect(1, 1, 20, n2 - 2);
                graphics.setColor(Color.black);
                graphics.fillRect(6, 9, 10, 3);
                graphics.setColor(color);
                graphics.setFont(this.font);
                graphics.drawString(this.title, 40, 15);
            } else {
                graphics.clearRect(0, 0, n, n2);
                graphics.setColor(color);
                graphics.setFont(this.font);
                graphics.drawString(this.title, 40, 15);
            }
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setTitleColor(Color color) {
            this.titleColor = color;
            this.setBackground(color);
        }

        private boolean titleHasFocus() {
            return NotesFrame.this.hasFocus;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

