/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ScrollingMouseTransactionClient;
import com.adobe.acrobat.gui.TextSelectionTool;
import com.adobe.acrobat.gui.Tool;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MouseTransactionClient;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class HandTool
extends Tool {
    private static final String Hand_K = "Hand";
    private static Tool gHandTool = new HandTool();

    private HandTool() {
        super(Util.getMenuVString(Hand_K), "hand.gif");
    }

    public boolean canSelectAll(PageView pageView, Requester requester) throws Exception {
        return TextSelectionTool.getTextSelectionTool().canSelectAll(pageView, requester);
    }

    public Cursor getCursor(PageView pageView, Requester requester) throws Exception {
        Cursor cursor = super.getCursor(pageView, requester);
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(13);
        }
        return cursor;
    }

    public static Tool getHandTool() {
        return gHandTool;
    }

    public static void register() {
        Tool.registerTool(Hand_K, HandTool.getHandTool());
    }

    public void selectAll(PageView pageView, Transaction transaction) throws Exception {
        TextSelectionTool.getTextSelectionTool().selectAll(pageView, transaction);
    }

    public MouseTransactionClient wantsMouseTransactionControl(Transaction transaction, PageView pageView, MouseEvent mouseEvent) throws Exception {
        MouseTransactionClient mouseTransactionClient = pageView.getOrnamentMouseTransactionClient(transaction, mouseEvent);
        if (mouseTransactionClient != null) {
            return mouseTransactionClient;
        }
        return new ScrollingMouseTransactionClient(pageView);
    }
}

