/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ViewerPanel;
import com.adobe.acrobat.sidecar.Region;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.painting.Painting;
import com.adobe.pe.painting.PaintingSampler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class GalleyPainting
extends Painting {
    private Color bg = ViewerPanel.getDesktopColor();
    private int numCols;
    private int numRows;
    private int topLeftPage;
    private int numPages;
    private Vector pagePaintings;
    private Vector cellBounds;
    private Vector paintingBounds;
    private Region grayRegion;
    private int[] rowStarts;
    private int[] colStarts;
    private int[] rowHeights;
    private int[] colWidths;
    private int firstVisCol;
    private int lastVisCol;
    private int firstVisRow;
    private int lastVisRow;

    GalleyPainting(PageView pageView, Requester requester) throws Exception {
        super(GalleyPainting.computeBounds(pageView, requester), false, true);
        int n = pageView.vGalleyWidth.intValue(requester);
        int n2 = pageView.vGalleyHeight.intValue(requester);
        this.topLeftPage = pageView.getTopLeftPage(requester);
        this.numCols = pageView.getNumColumns(requester);
        this.numRows = pageView.getNumRows(requester);
        this.numPages = pageView.getNumPages(requester);
        Rectangle rectangle = pageView.getVisiblePagesRectangle(requester);
        this.firstVisCol = rectangle.x;
        this.firstVisRow = rectangle.y;
        this.lastVisCol = rectangle.x + rectangle.width - 1;
        this.lastVisRow = rectangle.y + rectangle.height - 1;
        this.pagePaintings = new Vector();
        this.cellBounds = new Vector();
        this.paintingBounds = new Vector();
        this.grayRegion = new Region(this.getBounds());
        int n3 = this.firstVisRow;
        while (n3 <= this.lastVisRow) {
            int n4 = this.firstVisCol;
            while (n4 <= this.lastVisCol) {
                Rectangle rectangle2 = new Rectangle(pageView.getNthColumnStart(n4, requester), pageView.getNthRowStart(n3, requester), pageView.getNthColumnWidthDeviceSpace(n4, requester), pageView.getNthRowHeightDeviceSpace(n3, requester));
                this.cellBounds.addElement(rectangle2);
                int n5 = n3 * this.numCols + n4 + this.topLeftPage;
                if (n5 >= 0 && n5 < this.numPages) {
                    Painting painting = pageView.getPagePainting(n5, requester);
                    this.pagePaintings.addElement(painting);
                    Rectangle rectangle3 = pageView.getPageRectangle(n5, requester);
                    this.paintingBounds.addElement(rectangle3);
                    this.grayRegion = this.grayRegion.subtract(rectangle3);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public PaintingSampler acquireSampler(Rectangle rectangle) {
        return new GalleyPaintingSampler(this, rectangle);
    }

    private static Rectangle computeBounds(PageView pageView, Requester requester) throws Exception {
        return pageView.getAperture(requester);
    }

    public void draw(Graphics graphics) throws Exception {
        int n = 0;
        graphics.setColor(this.bg);
        int n2 = this.firstVisRow;
        while (n2 <= this.lastVisRow) {
            int n3 = this.firstVisCol;
            while (n3 <= this.lastVisCol) {
                int n4 = n2 * this.numCols + n3 + this.topLeftPage;
                if (n4 >= 0 && n4 < this.numPages) {
                    try {
                        this.drawOnePage(graphics, n++, n3, n2);
                    }
                    catch (Exception exception) {}
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void drawGrayArea(Graphics graphics) {
        Rectangle[] rectangleArray = this.grayRegion.getRects();
        graphics.setColor(this.bg);
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        int n2 = 0;
        int n3 = this.firstVisRow;
        while (n3 <= this.lastVisRow) {
            int n4 = this.firstVisCol;
            while (n4 <= this.lastVisCol) {
                int n5 = n3 * this.numCols + n4 + this.topLeftPage;
                Rectangle rectangle = (Rectangle)this.cellBounds.elementAt((n3 - this.firstVisRow) * (this.lastVisCol - this.firstVisCol + 1) + n4 - this.firstVisCol);
                if (n5 >= 0 && n5 < this.numPages) {
                    Painting painting = (Painting)this.pagePaintings.elementAt(n2);
                    Rectangle rectangle2 = (Rectangle)this.paintingBounds.elementAt(n2);
                    ++n2;
                    int n6 = rectangle2.y - rectangle.y;
                    int n7 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                    int n8 = rectangle2.x - rectangle.x;
                    int n9 = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
                    graphics.setColor(this.bg);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, n6);
                    graphics.fillRect(rectangle.x, rectangle2.y, n8, rectangle2.height);
                    graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, n7);
                    graphics.fillRect(rectangle2.x + rectangle2.width, rectangle2.y, n9, rectangle2.height);
                    graphics.setColor(Color.black);
                    graphics.drawRect(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 1, rectangle2.height + 1);
                    graphics.fillRect(rectangle2.x + 2, rectangle2.y + rectangle2.height + 1, rectangle2.width + 1, 2);
                    graphics.fillRect(rectangle2.x + rectangle2.width + 1, rectangle2.y + 2, 2, rectangle2.height + 1);
                } else {
                    graphics.setColor(this.bg);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                ++n4;
            }
            ++n3;
        }
    }

    private void drawOnePage(Graphics graphics, int n, int n2, int n3) throws Exception {
        Painting painting = (Painting)this.pagePaintings.elementAt(n);
        Rectangle rectangle = (Rectangle)this.paintingBounds.elementAt(n);
        painting.draw(graphics, new Point(rectangle.x, rectangle.y));
    }

    class GalleyPaintingSampler
    extends PaintingSampler {
        private Vector samplers = new Vector();
        private Color bg;

        GalleyPaintingSampler(Painting painting, Rectangle rectangle) {
            super(painting, rectangle);
            int n = 0;
            while (n < GalleyPainting.this.pagePaintings.size()) {
                Painting painting2 = (Painting)GalleyPainting.this.pagePaintings.elementAt(n);
                Rectangle rectangle2 = (Rectangle)GalleyPainting.this.paintingBounds.elementAt(n);
                Rectangle rectangle3 = new Rectangle(rectangle);
                rectangle3.translate(-rectangle2.x, -rectangle2.y);
                PaintingSampler paintingSampler = painting2.acquireSampler(rectangle3);
                this.samplers.addElement(paintingSampler);
                ++n;
            }
        }

        public void stopDrawing() {
            int n = 0;
            while (n < this.samplers.size()) {
                PaintingSampler paintingSampler = (PaintingSampler)this.samplers.elementAt(n);
                paintingSampler.stopDrawing();
                ++n;
            }
        }

        public boolean waitAndSample(Graphics graphics, boolean bl, long l) throws Throwable {
            if (bl) {
                GalleyPainting.this.drawGrayArea(graphics);
            }
            int n = 0;
            boolean bl2 = true;
            int n2 = GalleyPainting.this.firstVisRow;
            while (n2 <= GalleyPainting.this.lastVisRow) {
                int n3 = GalleyPainting.this.firstVisCol;
                while (n3 <= GalleyPainting.this.lastVisCol && !Thread.interrupted()) {
                    int n4 = n2 * GalleyPainting.this.numCols + n3 + GalleyPainting.this.topLeftPage;
                    if (n4 >= 0 && n4 < GalleyPainting.this.numPages) {
                        PaintingSampler paintingSampler = (PaintingSampler)this.samplers.elementAt(n);
                        if (paintingSampler != null) {
                            Rectangle rectangle = (Rectangle)GalleyPainting.this.paintingBounds.elementAt(n);
                            boolean bl3 = paintingSampler.waitAndSample(graphics, bl, l, new Point(rectangle.x, rectangle.y));
                            bl2 = bl3 && bl2;
                        }
                        ++n;
                    }
                    ++n3;
                }
                ++n2;
            }
            return bl2;
        }
    }
}

