/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.ViewerCommand;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.Ornament;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.gui.ViewerPanel;
import com.adobe.acrobat.util.Session;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VBoolean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Window;
import java.util.Enumeration;

public class FullScreenVerb
extends UIVerb
implements ViewerCommand {
    private boolean hasToolbar;
    private boolean hasStatusbar;
    private Dimension mainSize;
    private Point mainLocation;
    private String scaleType = null;
    private float scale;
    private Frame mainFrame;
    private Window fullscreen;
    private ViewerPanel viewerPanel;
    private Container parent;
    private AcroViewContext context;
    private boolean checkstate = true;
    private VBoolean checked;
    private MenuBar menubar;
    private static MenuBar blankMenubar = new MenuBar();

    public FullScreenVerb(AcroViewContext acroViewContext) {
        this.context = acroViewContext;
        FullScreenVerbTransactor fullScreenVerbTransactor = new FullScreenVerbTransactor();
        VFullScreenIsSelectedBoolean vFullScreenIsSelectedBoolean = new VFullScreenIsSelectedBoolean();
        this.setAttributes(fullScreenVerbTransactor, null, vFullScreenIsSelectedBoolean);
        this.checkstate = false;
        this.checked = new VBoolean(this.checkstate);
    }

    void fromFullScreen(Transaction transaction) throws Exception {
        if (this.checkstate) {
            this.checkstate = false;
            this.fullscreen.remove(this.viewerPanel);
            this.fullscreen.dispose();
            this.viewerPanel.addToolbar();
            this.viewerPanel.addStatusbar();
            this.parent.add(this.viewerPanel);
            if (this.hasToolbar) {
                this.viewerPanel.addToolbar();
            }
            if (this.hasStatusbar) {
                this.viewerPanel.addStatusbar();
            }
            PageView pageView = this.context.getPageView();
            if (this.scaleType != null) {
                pageView.setScaleType(transaction, this.scaleType);
                pageView.setScale(transaction, this.scale);
            } else {
                pageView.setScaleType(transaction, "FitPage");
            }
            this.checked.setBooleanValue(transaction, this.checkstate);
            this.mainFrame.invalidate();
            this.mainFrame.validate();
            this.mainFrame.setMenuBar(this.menubar);
            this.viewerPanel.requestFocus();
        }
    }

    public boolean getChecked() {
        return this.checkstate;
    }

    public static void registerCommands(AcroViewContext acroViewContext) {
        CommandRegistry.addCommand(acroViewContext.getFullScreenVerb(), acroViewContext, "ToggleFullScreen");
    }

    void toFullScreen(Transaction transaction) throws Exception {
        if (!this.checkstate) {
            Enumeration enumeration;
            this.viewerPanel = (ViewerPanel)this.context.getRootComponent();
            this.viewerPanel.removeToolbar();
            this.viewerPanel.removeStatusbar();
            this.mainFrame = PEUtil.getFrame(this.viewerPanel);
            this.menubar = this.mainFrame.getMenuBar();
            this.mainFrame.setMenuBar(blankMenubar);
            this.fullscreen = new Window(this.mainFrame);
            ((Component)this.fullscreen).setBackground(ViewerPanel.getDesktopColor());
            this.fullscreen.setLayout(new BorderLayout());
            Dimension dimension = this.fullscreen.getToolkit().getScreenSize();
            if (Session.getTheSession().isMacOS()) {
                int n = 18;
                int n2 = 4;
                ((Component)this.fullscreen).setBounds(-n2, -n - n2, dimension.width + n2 * 2, dimension.height + n + n2 * 2);
            } else {
                ((Component)this.fullscreen).setSize(dimension);
            }
            this.parent = this.viewerPanel.getParent();
            this.parent.remove(this.viewerPanel);
            this.context.getPageView().setScaleType(transaction, "FitPage");
            this.hasToolbar = this.viewerPanel.hasToolbar();
            this.hasStatusbar = this.viewerPanel.hasStatusbar();
            this.checkstate = true;
            this.checked.setBooleanValue(transaction, this.checkstate);
            this.fullscreen.add((Component)this.viewerPanel, "Center");
            this.fullscreen.invalidate();
            this.fullscreen.validate();
            this.fullscreen.show();
            Enumeration enumeration2 = enumeration = this.context.getPageView().vOrnaments.ornamentListValue(transaction).getOrnaments();
            while (enumeration2.hasMoreElements()) {
                Ornament ornament = (Ornament)enumeration2.nextElement();
                if (!ornament.hasPopupWindow()) continue;
                ornament.getPopupWindow().toFront();
            }
        }
    }

    void toggleFullScreen(Transaction transaction) throws Exception {
        if (this.checkstate) {
            this.fromFullScreen(transaction);
        } else {
            this.toFullScreen(transaction);
        }
    }

    class VFullScreenIsSelectedBoolean
    extends VBoolean {
        VFullScreenIsSelectedBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            if (SimpleUIVerb.getVDocIsOpenBoolean(FullScreenVerb.this.context).booleanValue(requester)) {
                return FullScreenVerb.this.checked.booleanValue(requester);
            }
            return false;
        }
    }

    class FullScreenVerbTransactor
    extends Transactor {
        FullScreenVerbTransactor() {
        }

        protected void buildChanges(Transaction transaction) throws Exception {
            FullScreenVerb.this.toggleFullScreen(transaction);
        }
    }
}

