/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.gui;

import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.BasicDialog;
import com.adobe.acrobat.gui.CommandRegistry;
import com.adobe.acrobat.gui.KeyBindings;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.gui.Selection;
import com.adobe.acrobat.gui.TextSelection;
import com.adobe.acrobat.pdf.VPageRefByNum;
import com.adobe.acrobat.pdf.VPageTextWordy;
import com.adobe.acrobat.pdf.Wordy;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Util;
import com.adobe.pe.awt.MessageDialog;
import com.adobe.pe.awt.StrobeUtils;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.awt.VButton;
import com.adobe.pe.awt.VCheckbox;
import com.adobe.pe.awt.VTextField;
import com.adobe.pe.extend.Extensible;
import com.adobe.pe.extend.Extension;
import com.adobe.pe.extend.ExtensionDataProvider;
import com.adobe.pe.extend.ProviderNotFoundException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VLatch;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VInt;
import com.adobe.pe.vtypes.VString;
import com.adobe.util.Assert;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.Properties;

public class FindDialog
extends BasicDialog
implements ActionListener,
TransactionExecutionContext,
KeyListener {
    private static ExtensionDataProvider provider = null;
    private static final String FindDialog_K = "FindDialog";
    private boolean setupDone = false;
    private VButton findButton;
    private Button closeButton;
    private VTextField findTextField;
    private Label xOfYLabel;
    private AcroViewContext context;
    private UIVerb findUIVerb;
    private VString vFindString = new VString("");
    private VBoolean vFindHappeningBoolean = new VBoolean(false);
    private VLatch vFindLatch = new VFindLatch();
    private VSynchronizer vFindSynchronizer = new VSynchronizer(true, 4);
    static final int kFindDialogSelectionMargin = 5;
    private VPDFReference vFindSessionStartPageRef = new VPDFReference(null);
    private VInt vFindSessionStartOffset = new VInt(0);
    private VPDFReference vFindSessionLastPageRef = new VPDFReference(null);
    private VInt vFindSessionLastOffset = new VInt(0);
    private VBoolean vAnyOccurrences = new VBoolean(false);

    FindDialog(AcroViewContext acroViewContext) {
        super(PEUtil.getFrame(acroViewContext.getRootComponent()), Util.getDialogString("Find:Title"), false);
        this.context = acroViewContext;
        this.setResizable(false);
    }

    public void abortTransaction(Transaction transaction) {
    }

    static /* synthetic */ VInt access$5(FindDialog findDialog) {
        return findDialog.vFindSessionStartOffset;
    }

    static /* synthetic */ VPDFReference access$6(FindDialog findDialog) {
        return findDialog.vFindSessionLastPageRef;
    }

    static /* synthetic */ VInt access$8(FindDialog findDialog) {
        return findDialog.vFindSessionLastOffset;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.findTextField) {
            this.findTextField.selectAll();
            this.vFindSynchronizer.setTransactor(this, this.findUIVerb.getTransactor());
        } else {
            this.setVisible(false);
        }
    }

    protected void arrangeButtons() {
    }

    public void beginTransaction(Transaction transaction) {
        Cursor cursor = Cursor.getPredefinedCursor(3);
        this.findTextField.setCursor(cursor);
        ((Component)this).setCursor(cursor);
        this.findButton.setCursor(Cursor.getDefaultCursor());
    }

    private synchronized UIVerb createFindUIVerb() {
        if (this.findUIVerb == null) {
            VGoFindButtonEnabledBoolean vGoFindButtonEnabledBoolean = new VGoFindButtonEnabledBoolean();
            FindTransactor findTransactor = new FindTransactor();
            this.findUIVerb = new UIVerb();
            this.findUIVerb.setAttributes(findTransactor, vGoFindButtonEnabledBoolean, null);
        }
        return this.findUIVerb;
    }

    public void doLayout() {
        String string = this.findButton.getLabel();
        this.findButton.setLabel(Util.getDialogString("Find:FindNext"));
        try {
            super.doLayout();
        }
        finally {
            Object var3_2 = null;
            this.findButton.setLabel(string);
        }
    }

    public void endTransaction(Transaction transaction) {
        Cursor cursor = Cursor.getDefaultCursor();
        this.findTextField.setCursor(cursor);
        ((Component)this).setCursor(cursor);
    }

    public void findNext() {
        this.findButton.perform();
    }

    public static synchronized FindDialog getFindDialog(AcroViewContext acroViewContext) {
        FindDialog.initProvider();
        FindDialog findDialog = (FindDialog)acroViewContext.getExtensionData(FindDialog_K);
        findDialog.setup();
        return findDialog;
    }

    private static synchronized void initProvider() {
        if (provider == null) {
            provider = new ExtensionDataProvider(){

                public Object provide(String string, Extensible extensible) {
                    Assert.notFalse(extensible instanceof AcroViewContext);
                    AcroViewContext acroViewContext = (AcroViewContext)extensible;
                    if (string.equals(FindDialog.FindDialog_K)) {
                        return new FindDialog(acroViewContext);
                    }
                    throw new ProviderNotFoundException(string);
                }
            };
            Extension.registerProvider(FindDialog_K, provider);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Properties properties = CommandRegistry.getKeymaps();
        String string = (String)((Hashtable)properties).get(KeyBindings.getKeybindingText(keyEvent));
        if ("EditCopy".equals(string) && CommandRegistry.isCommandAllowed("EditCopy")) {
            keyEvent.consume();
            try {
                CommandRegistry.executeCommand(this.context, "EditCopy");
            }
            catch (Exception exception) {}
        } else if ("FindAgain".equals(string)) {
            keyEvent.consume();
            this.findButton.perform();
        } else if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() != this.findTextField) {
            keyEvent.consume();
            this.findButton.perform();
        } else if (keyEvent.getKeyCode() == 27) {
            keyEvent.consume();
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void reportError(Transaction transaction, Throwable throwable, boolean bl) {
        this.context.reportError(transaction, throwable, bl);
    }

    void setCurrPageNum(int n, int n2) {
        if (n == -1) {
            this.xOfYLabel.setText("");
        } else {
            String string = Util.getDialogString("Find:PageXOfY", new Integer(n + 1), new Integer(n2));
            this.xOfYLabel.setText(string);
        }
    }

    private synchronized void setup() {
        if (this.setupDone) {
            return;
        }
        this.setLayout(new BorderLayout(5, 5));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Label label = new Label(Util.getDialogString("Find:Prompt"));
        panel2.add((Component)label, "West");
        this.findTextField = new VTextField(null, this.vFindString, this.vFindString, 40, true);
        this.findTextField.addKeyListener(this);
        panel2.add((Component)this.findTextField, "Center");
        panel.add((Component)panel2, "North");
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 2));
        VCheckbox vCheckbox = new VCheckbox(Util.getDialogString("Find:MatchCase"), ReaderPrefs.fMatchCase, ReaderPrefs.fMatchCase);
        panel3.add(vCheckbox);
        vCheckbox.addKeyListener(this);
        VCheckbox vCheckbox2 = new VCheckbox(Util.getDialogString("Find:WholeWord"), ReaderPrefs.fFindWholeWord, ReaderPrefs.fFindWholeWord);
        panel3.add(vCheckbox2);
        vCheckbox2.addKeyListener(this);
        VBoolean vBoolean = new VBoolean(){

            protected final boolean computeBoolean(Requester requester) throws Exception {
                return ReaderPrefs.fFindAll.booleanValue(requester) ^ true;
            }
        };
        VCheckbox vCheckbox3 = new VCheckbox(Util.getDialogString("Find:BackSearch"), ReaderPrefs.fFindBackwards, ReaderPrefs.fFindBackwards, vBoolean);
        panel3.add(vCheckbox3);
        vCheckbox3.addKeyListener(this);
        VCheckbox vCheckbox4 = new VCheckbox(Util.getDialogString("Find:FindAll"), ReaderPrefs.fFindAll, ReaderPrefs.fFindAll);
        panel3.add(vCheckbox4);
        vCheckbox4.addKeyListener(this);
        panel.add((Component)panel3, "Center");
        this.add((Component)panel, "Center");
        this.xOfYLabel = new Label();
        this.xOfYLabel.setFont(new Font("Dialog", 2, 11));
        this.xOfYLabel.setAlignment(1);
        this.add((Component)this.xOfYLabel, "South");
        this.findButton = new VButton(this, this.createFindUIVerb(), new VFindButtonTitle(), this.vFindSynchronizer, true);
        this.findButton.addKeyListener(this);
        this.closeButton = new Button(Util.getDialogString("Find:Close"));
        this.closeButton.addKeyListener(this);
        this.cancel = this.closeButton;
        Panel panel4 = new Panel();
        GridLayout gridLayout = new GridLayout(3, 1, 5, 5);
        gridLayout.setHgap(5);
        panel4.setLayout(gridLayout);
        panel4.add(this.findButton);
        panel4.add(this.closeButton);
        this.add((Component)panel4, "East");
        this.closeButton.addActionListener(this);
        this.findTextField.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
        this.setResizable(false);
        this.setupDone = true;
    }

    public void show(Transaction transaction, AcroViewContext acroViewContext) throws Exception {
        StrobeUtils.setAllStrobesActive(transaction, this, true);
        this.setVisible(true);
        this.restoreLocation();
        this.findButton.requestFocus();
        this.toFront();
    }

    class VFindLatch
    extends VLatch {
        VFindLatch() {
        }

        protected final void computeLatches(Requester requester) throws WriteLockException {
            PageView pageView = FindDialog.this.context.getPageView();
            this.query(pageView.getVSelection(), requester);
            this.query(FindDialog.this.vFindString, requester);
            this.query(ReaderPrefs.fFindWholeWord, requester);
            this.query(ReaderPrefs.fFindBackwards, requester);
            this.query(ReaderPrefs.fMatchCase, requester);
            this.query(ReaderPrefs.fFindAll, requester);
        }
    }

    class VGoFindButtonEnabledBoolean
    extends VBoolean {
        VGoFindButtonEnabledBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            String string = FindDialog.this.vFindString.stringValue(requester);
            return string != null && !string.equals("");
        }
    }

    class VFindButtonTitle
    extends VString {
        VFindButtonTitle() {
        }

        protected final String computeString(Requester requester) throws Exception {
            if (FindDialog.this.vFindHappeningBoolean.booleanValue(requester)) {
                return Util.getDialogString("Find:Stop");
            }
            if (ReaderPrefs.fFindAll.booleanValue(requester)) {
                return Util.getDialogString("Find:FindAll");
            }
            if (FindDialog.this.vFindLatch.isLatched(requester) && FindDialog.this.vFindSessionStartPageRef.pdfReferenceValue(requester) != null) {
                return Util.getDialogString("Find:FindNext");
            }
            return Util.getDialogString("Find:Find");
        }
    }

    class FindTransactor
    extends Transactor {
        FindTransactor() {
        }

        protected final void buildChanges(Transaction transaction) throws Exception {
            FindDialog.this.vFindHappeningBoolean.setBooleanValue(transaction, true);
            transaction.notifyStrobes();
            if (ReaderPrefs.fFindAll.booleanValue(transaction)) {
                this.findAll(transaction);
            } else {
                this.findOrFindNext(transaction);
            }
            FindDialog.this.vFindHappeningBoolean.setBooleanValue(transaction, false);
        }

        private void findAll(Transaction transaction) throws Exception {
            PageView pageView = FindDialog.this.context.getPageView();
            int n = pageView.getNumPages(transaction);
            String string = FindDialog.this.vFindString.stringValue(transaction);
            boolean bl = ReaderPrefs.fMatchCase.booleanValue(transaction);
            boolean bl2 = ReaderPrefs.fFindWholeWord.booleanValue(transaction);
            TextSelection textSelection = TextSelection.getEmptyTextSelection();
            int n2 = 0;
            try {
                Object object;
                Object object2;
                int n3 = 0;
                while (n3 < n) {
                    Point point;
                    FindDialog.this.setCurrPageNum(n3, n);
                    object2 = pageView.getPageRef(n3, transaction);
                    object = VPageTextWordy.getVPageTextWordy((PDFReference)object2).wordyValue(transaction);
                    int n4 = 0;
                    while ((point = ((Wordy)object).findString(string, n4, 0x3FFFFFFF, bl2, bl)) != null) {
                        ++n2;
                        textSelection = textSelection.addToSelection(pageView, (PDFReference)object2, point.x, point.y, transaction);
                        n4 = point.x + point.y;
                    }
                    ++n3;
                }
                pageView.setSelection(transaction, textSelection);
                transaction.notifyStrobes();
                this.moveDialogIfNecessary(transaction);
                object2 = n2 == 0 ? Util.getDialogString("Find:NoOccurrences", string) : Util.getDialogString("Find:NOccurrences", new Integer(n2));
                object = new MessageDialog(PEUtil.getFrame(FindDialog.this), Util.getDialogString("Find:Title"), (String)object2);
                ((MessageDialog)object).runDialog();
                FindDialog.this.toFront();
            }
            finally {
                Object var10_14 = null;
                FindDialog.this.setCurrPageNum(-1, 0);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void findOrFindNext(Transaction var1_1) throws Exception {
            block22: {
                try {
                    var4_2 = FindDialog.access$0(FindDialog.this).getPageView();
                    var5_3 = var4_2.getSelection(var1_1);
                    var6_4 = var5_3 instanceof TextSelection != false ? (TextSelection)var5_3 : null;
                    var7_5 = ReaderPrefs.fMatchCase.booleanValue(var1_1);
                    var8_6 = ReaderPrefs.fFindWholeWord.booleanValue(var1_1);
                    var9_7 = ReaderPrefs.fFindBackwards.booleanValue(var1_1) ^ true;
                    var10_8 = FindDialog.access$3(FindDialog.this).isLatched(var1_1) == false || FindDialog.access$4(FindDialog.this).pdfReferenceValue(var1_1) == null;
                    var11_9 = var4_2.getNumPages(var1_1);
                    var12_10 = FindDialog.access$1(FindDialog.this).stringValue(var1_1);
                    var13_11 = true;
                    if (var10_8) {
                        var14_12 = this.getStartPage(var4_2, var6_4, var9_7, var1_1);
                        var15_13 = this.getStartOffset(var14_12, var6_4, var9_7, var1_1);
                        FindDialog.access$4(FindDialog.this).setReferenceValue(var1_1, var14_12);
                        FindDialog.access$5(FindDialog.this).setIntValue(var1_1, var15_13);
                        FindDialog.access$6(FindDialog.this).setReferenceValue(var1_1, null);
                        FindDialog.access$7(FindDialog.this).setBooleanValue(var1_1, false);
                    }
                    var14_12 = FindDialog.access$4(FindDialog.this).pdfReferenceValue(var1_1);
                    var15_13 = FindDialog.access$5(FindDialog.this).intValue(var1_1);
                    var16_14 = FindDialog.access$6(FindDialog.this).pdfReferenceValue(var1_1);
                    if (var16_14 == null) {
                        var16_14 = var14_12;
                        var17_15 = var15_13;
                    } else {
                        var17_15 = FindDialog.access$8(FindDialog.this).intValue(var1_1) + (var9_7 != false ? 1 : -1);
                    }
                    var18_16 = var16_14 == var14_12 ? (var9_7 ? (var17_15 < var15_13 ? var15_13 : 0x3FFFFFFF) : (var17_15 > var15_13 ? var15_13 : 0)) : (var9_7 != false ? 0x3FFFFFFF : 0);
                    while (true) {
                        block25: {
                            block27: {
                                block28: {
                                    block26: {
                                        block24: {
                                            block23: {
                                                var19_17 = null;
                                                var20_18 = var4_2.getPageNum((PDFReference)var16_14, var1_1);
                                                FindDialog.this.setCurrPageNum(var20_18, var11_9);
                                                if (var16_14 != var14_12 || var17_15 != var15_13 || !FindDialog.access$7(FindDialog.this).booleanValue(var1_1)) {
                                                    var21_19 = VPageTextWordy.getVPageTextWordy((PDFReference)var16_14).wordyValue(var1_1);
                                                    var19_17 = var21_19.findString(var12_10, var17_15, var18_16, var8_6, var7_5);
                                                } else {
                                                    var18_16 = var17_15 + (var9_7 != false ? -1 : 1);
                                                }
                                                if (var19_17 != null) {
                                                    FindDialog.access$6(FindDialog.this).setReferenceValue(var1_1, (PDFReference)var16_14);
                                                    FindDialog.access$8(FindDialog.this).setIntValue(var1_1, var19_17.x);
                                                    FindDialog.access$7(FindDialog.this).setBooleanValue(var1_1, true);
                                                    var21_19 = new TextSelection(var4_2, (PDFReference)var16_14, var19_17.x, var19_17.y);
                                                    var4_2.setSelection(var1_1, (Selection)var21_19);
                                                    var22_21 = var21_19.getBBoxForPage((PDFReference)var16_14, var1_1);
                                                    Assert.notFalse(var22_21 != null);
                                                    var4_2.scrollToPageSpaceRect(var1_1, var4_2.getPageNum((PDFReference)var16_14, var1_1), var22_21, false);
                                                    this.moveDialogIfNecessary(var1_1);
                                                    break;
                                                }
                                                var20_18 = var9_7 != false ? (var20_18 + 1) % var11_9 : (var20_18 == 0 ? var11_9 - 1 : var20_18 - 1);
                                                var21_19 = var4_2.getPageRef(var20_18, var1_1);
                                                var22_20 = false;
                                                if (var16_14 != var14_12) ** GOTO lbl-1000
                                                if (!var9_7) break block23;
                                                if (var18_16 <= var15_13) ** GOTO lbl-1000
                                                v0 = false;
                                                break block24;
                                            }
                                            if (var18_16 >= var15_13) ** GOTO lbl-1000
                                            v0 = false;
                                        }
                                        if (v0) lbl-1000:
                                        // 3 sources

                                        {
                                            var22_20 = true;
                                        } else if (var21_19 == var14_12 && var15_13 == (var9_7 != false ? 0 : 0x3FFFFFFF)) {
                                            var22_20 = true;
                                        }
                                        if (!var22_20) {
                                            var23_22 = false;
                                            if (var9_7 && var20_18 == 0 && (var14_12 != var21_19 || var15_13 != 0)) {
                                                var23_22 = true;
                                            } else if (!(var9_7 || var20_18 != var11_9 - 1 || var14_12 == var21_19 && var15_13 == 0x3FFFFFFF)) {
                                                var23_22 = true;
                                            }
                                            if (var23_22) {
                                                var24_24 = this.getContinuationQueryString(var1_1, var12_10);
                                                var25_25 = new MessageDialog(PEUtil.getFrame(FindDialog.this), Util.getDialogString("Find:Title"), (String)var24_24, PEUtil.getString("General:Yes"), PEUtil.getString("General:No"));
                                                var26_26 = var25_25.runDialog();
                                                FindDialog.this.toFront();
                                                if (var26_26 == 1) {
                                                    var13_11 = false;
                                                    break;
                                                }
                                            }
                                        }
                                        if (var22_20) {
                                            FindDialog.access$4(FindDialog.this).setReferenceValue(var1_1, null);
                                            var23_23 = this.getNoOccurrencesString(var1_1, var12_10);
                                            var24_24 = new MessageDialog(PEUtil.getFrame(FindDialog.this), Util.getDialogString("Find:Title"), var23_23);
                                            var24_24.runDialog();
                                            FindDialog.this.toFront();
                                            break;
                                        }
                                        var16_14 = var21_19;
                                        v1 = var17_15 = var9_7 != false ? 0 : 0x3FFFFFFF;
                                        if (var16_14 != var14_12) break block25;
                                        if (!var9_7) break block26;
                                        if (var17_15 < var15_13) break block27;
                                        v2 = false;
                                        break block28;
                                    }
                                    if (var17_15 > var15_13) break block27;
                                    v2 = false;
                                }
                                if (!v2) break block25;
                            }
                            var18_16 = var15_13 + (var9_7 != false ? -1 : 1);
                            continue;
                        }
                        var18_16 = var9_7 != false ? 0x3FFFFFFF : 0;
                    }
                    if (!var13_11) break block22;
                    FindDialog.access$3(FindDialog.this).latch(var1_1);
                }
                catch (Throwable var2_29) {
                    var3_28 = null;
                    FindDialog.this.setCurrPageNum(-1, 0);
                    throw var2_29;
                }
            }
            var3_27 = null;
            FindDialog.this.setCurrPageNum(-1, 0);
        }

        private String getContinuationQueryString(Requester requester, String string) throws Exception {
            String string2 = this.getNoOccurrencesString(requester, string);
            String string3 = ReaderPrefs.fFindBackwards.booleanValue(requester) ? "Find:ContinueBackward" : "Find:ContinueForward";
            return String.valueOf(string2) + Util.getDialogString(string3);
        }

        private String getNoOccurrencesString(Requester requester, String string) throws Exception {
            String string2 = FindDialog.this.vAnyOccurrences.booleanValue(requester) ? "Find:NoMoreOccurrences" : "Find:NoOccurrences";
            String string3 = Util.getDialogString(string2, string);
            return string3;
        }

        private int getStartOffset(PDFReference pDFReference, TextSelection textSelection, boolean bl, Requester requester) throws Exception {
            if (textSelection == null) {
                return bl ? 0 : 0x3FFFFFFF;
            }
            return textSelection.getSelectionStart(pDFReference) + (bl ? 1 : -1);
        }

        private PDFReference getStartPage(PageView pageView, TextSelection textSelection, boolean bl, Requester requester) throws Exception {
            int n;
            PDFObjStore pDFObjStore = pageView.getPDFObjStore(requester);
            int n2 = pageView.getTopLeftPage(requester);
            int n3 = pageView.getNumRows(requester);
            int n4 = pageView.getNumColumns(requester);
            int n5 = pageView.getNumPages(requester);
            int n6 = Math.max(0, n2);
            int n7 = Math.min(n5 - 1, n2 + n3 * n4 - 1);
            if (textSelection != null) {
                if (bl) {
                    n = n7;
                    while (n >= n6) {
                        PDFReference pDFReference = VPageRefByNum.getVPageRefByNum(pDFObjStore, n).pdfReferenceValue(requester);
                        if (textSelection.includesPage(pDFReference)) {
                            return pDFReference;
                        }
                        --n;
                    }
                } else {
                    n = n6;
                    while (n <= n7) {
                        PDFReference pDFReference = VPageRefByNum.getVPageRefByNum(pDFObjStore, n).pdfReferenceValue(requester);
                        if (textSelection.includesPage(pDFReference)) {
                            return pDFReference;
                        }
                        ++n;
                    }
                }
            }
            n = bl ? n6 : n7;
            return VPageRefByNum.getVPageRefByNum(pDFObjStore, n).pdfReferenceValue(requester);
        }

        private void moveDialogIfNecessary(Requester requester) throws Exception {
            Object object;
            PageView pageView = FindDialog.this.context.getPageView();
            Component component = pageView.getDisplayComponent();
            if (component == null) {
                return;
            }
            Selection selection = pageView.getSelection(requester);
            if (selection == null || !(selection instanceof TextSelection)) {
                return;
            }
            Rectangle rectangle = null;
            TextSelection textSelection = (TextSelection)selection;
            int n = pageView.getNumPages(requester);
            Rectangle rectangle2 = pageView.getVisiblePagesRectangle(requester);
            int n2 = pageView.getTopLeftPage(requester);
            int n3 = pageView.getNumColumns(requester);
            int n4 = rectangle2.y;
            while (n4 < rectangle2.y + rectangle2.width) {
                int n5 = rectangle2.x;
                while (n5 < rectangle2.x + rectangle2.height) {
                    FloatRect floatRect;
                    int n6 = n2 + n4 * n3 + n5;
                    if (n6 >= 0 && n6 < n && (floatRect = textSelection.getBBoxForPage((PDFReference)(object = pageView.getPageRef(n6, requester)), requester)) != null) {
                        AffineTransform affineTransform = pageView.getGalleyTransform(n6, requester);
                        Assert.notFalse(affineTransform != null);
                        Rectangle rectangle3 = floatRect.transformRect(affineTransform).toEnclosingRect();
                        rectangle = rectangle == null ? new Rectangle(rectangle3) : rectangle3.union(rectangle);
                    }
                    ++n5;
                }
                ++n4;
            }
            if (rectangle == null) {
                return;
            }
            Rectangle rectangle4 = pageView.getAperture(requester);
            if (!rectangle.intersects(rectangle4)) {
                return;
            }
            rectangle = rectangle.intersection(rectangle4);
            rectangle.translate(-rectangle4.x, -rectangle4.y);
            rectangle = Util.localToGlobal(component, rectangle);
            Rectangle rectangle5 = FindDialog.this.getBounds();
            if (!rectangle5.intersects(rectangle)) {
                return;
            }
            object = new Rectangle(FindDialog.this.getToolkit().getScreenSize());
            int n7 = rectangle.y + rectangle.height / 2;
            int n8 = rectangle5.y + rectangle5.height / 2;
            int n9 = rectangle.y - 5 - rectangle5.height;
            int n10 = rectangle.y + rectangle.height + 5;
            if (n9 < 0) {
                if (n10 > ((Rectangle)object).height - rectangle5.height) {
                    return;
                }
                n9 = n10;
            } else if (n10 > ((Rectangle)object).height - rectangle5.height) {
                n10 = n9;
            }
            int n11 = n7 > n8 ? n9 : n10;
            Rectangle rectangle6 = new Rectangle(rectangle5);
            rectangle6.y = n11;
            ((Component)FindDialog.this).setBounds(rectangle6);
        }
    }
}

