/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.bytearray.ByteCache;
import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.ContiguousByteRange;
import com.adobe.acrobat.file.URLByteArray;
import com.adobe.acrobat.file.URLByteArrayException;
import com.adobe.acrobat.file.URLByteArraySource;
import com.adobe.acrobat.gui.ReaderPrefs;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.util.Session;
import com.adobe.acrobat.util.Util;
import com.adobe.util.Assert;
import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import netscape.security.PrivilegeManager;

class URLByteStream
extends InputStream
implements Runnable {
    private Thread runThread;
    private ByteCache byteCache;
    private ByteRange requestedBytes;
    private ByteRange realByteRange;
    private ByteRange currByteRange;
    private URLByteArray urlByteArray;
    private IOException savedIOException = null;
    private volatile boolean closed = false;
    private static final int kMaxRetry = 5;
    private boolean isMultipart;
    private URLConnection connection;
    private InputStream substream;
    private ContiguousByteRange partBR = null;
    private ContiguousByteRange markedPartBR = null;
    private int bytesLeftThisSegment = 0;
    private int markedBytesLeftThisSegment = 0;
    private String partBoundary;

    URLByteStream(URLByteArray uRLByteArray, ByteCache byteCache, ByteRange byteRange) {
        this.requestedBytes = byteRange;
        this.byteCache = byteCache;
        this.urlByteArray = uRLByteArray;
        this.currByteRange = byteRange;
        this.runThread = new Thread((Runnable)this, "URLByteStream");
        this.runThread.start();
    }

    public synchronized void close() throws IOException {
        try {
            this.closed = true;
            this.runThread.join();
            super.close();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    private boolean findPartBoundary(InputStream inputStream) throws IOException {
        int n = this.partBoundary.length();
        while (true) {
            String string;
            if ((string = this.readLine(inputStream)).length() < n) {
                if (string.length() != 1 || string.charAt(0) != '\uffff') continue;
                return false;
            }
            if (!this.partBoundary.equals(string.substring(0, n))) continue;
            if (string.length() == n) {
                return true;
            }
            if ((string = string.substring(n)).equals("--")) break;
        }
        return false;
    }

    synchronized ByteRange getRealByteRange() {
        return this.currByteRange;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void mark(int n) {
        this.substream.mark(n);
        this.markedBytesLeftThisSegment = this.bytesLeftThisSegment;
        this.markedPartBR = this.partBR;
    }

    public boolean markSupported() {
        return this.substream.markSupported();
    }

    private Properties parseAttributes(InputStream inputStream) throws IOException {
        int n;
        String string;
        Properties properties = new Properties();
        while ((string = this.readLine(inputStream)).length() > 1 && (n = string.indexOf(58)) >= 1) {
            String string2 = string.substring(0, n).trim().toLowerCase();
            String string3 = "";
            if (n + 1 < string.length()) {
                string3 = string.substring(n + 1);
            }
            ((Hashtable)properties).put(string2, string3);
        }
        return properties;
    }

    private ContiguousByteRange parseContentRange(String string) {
        int n;
        int n2;
        int n3 = string.indexOf("bytes") + 5;
        int n4 = string.indexOf(47);
        if (n3 < 0 || n4 < 0) {
            return null;
        }
        int n5 = (string = string.substring(n3, n4)).indexOf(45);
        if (n5 < 1) {
            return null;
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n5).trim());
            n = Integer.parseInt(string.substring(n5 + 1).trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Assert.notFalse(n2 <= n);
        return new ContiguousByteRange(n2, n);
    }

    private Properties parseContentType(String string) {
        Properties properties = new Properties();
        if (string != null) {
            while (string.length() > 0) {
                String string2 = string;
                int n = string.indexOf(59);
                if (n >= 0) {
                    string2 = n > 0 ? string.substring(0, n) : "";
                    string = n + 1 < string.length() ? string.substring(n + 1) : "";
                } else {
                    string = "";
                }
                if (((Hashtable)properties).isEmpty()) {
                    ((Hashtable)properties).put("content-type", string2);
                    continue;
                }
                int n2 = string2.indexOf(61);
                if (n2 <= 0) continue;
                String string3 = string2.substring(0, n2).trim().toLowerCase();
                String string4 = "";
                if (n2 + 1 < string2.length()) {
                    string4 = string2.substring(n2 + 1).trim().toLowerCase();
                }
                ((Hashtable)properties).put(string3, string4);
            }
        }
        return properties;
    }

    private boolean parsePartBoundary(InputStream inputStream) throws IOException {
        if (this.isMultipart) {
            if (!this.findPartBoundary(inputStream)) {
                return false;
            }
            Properties properties = this.parseAttributes(inputStream);
            String string = null;
            if (properties != null && (string = properties.getProperty("content-range")) == null) {
                string = properties.getProperty("range");
            }
            if (string == null) {
                return false;
            }
            this.partBR = this.parseContentRange(string);
            if (this.partBR == null) {
                return false;
            }
            this.bytesLeftThisSegment = this.partBR.getLength();
            return true;
        }
        this.partBR = this.getRealByteRange().getEnclosingRange();
        this.bytesLeftThisSegment = this.getRealByteRange().getLength();
        return true;
    }

    public int read() throws IOException {
        if (this.savedIOException != null) {
            throw this.savedIOException;
        }
        int n = this.substream.read();
        if (n != -1) {
            --this.bytesLeftThisSegment;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.savedIOException != null) {
            throw this.savedIOException;
        }
        int n3 = this.substream.read(byArray, n, n2 = Math.min(byArray.length - n, n2));
        if (n3 > 0) {
            this.bytesLeftThisSegment -= n3;
        }
        return n3;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while ((n = inputStream.read()) > 0 && n != 10) {
            if (Character.isISOControl((char)n) || Character.isWhitespace((char)n)) {
                if (!bl) {
                    if (stringBuffer.length() != 0) continue;
                    stringBuffer.append(' ');
                    continue;
                }
                if (n == 13) continue;
                stringBuffer.append(' ');
                continue;
            }
            bl = true;
            stringBuffer.append((char)n);
        }
        if (n < 0 && stringBuffer.length() == 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public void reset() throws IOException {
        this.substream.reset();
        this.bytesLeftThisSegment = this.markedBytesLeftThisSegment;
        this.partBR = this.markedPartBR;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        URL uRL = this.urlByteArray.url;
        try {
            try {
                Session session = Session.getTheSession();
                if (session.isIE()) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.SYSTEM);
                } else if (session.isNetscape()) {
                    PrivilegeManager.enablePrivilege((String)"UniversalConnect");
                    PrivilegeManager.enablePrivilege((String)"UniversalConnectWithRedirect");
                }
                while (!this.closed && !this.requestedBytes.isEmpty()) {
                    Object var6_4;
                    block55: {
                        block54: {
                            try {
                                try {
                                    Object object;
                                    int n = 0;
                                    while (n < 5) {
                                        block52: {
                                            try {
                                                this.connection = uRL.openConnection();
                                                this.connection.setUseCaches(true);
                                                Log.clog(String.valueOf(String.valueOf(this.connection.getClass())) + " instanceof HttpURLConnection == " + (this.connection instanceof HttpURLConnection));
                                                if (ReaderPrefs.getEnableProxySettings()) {
                                                    this.connection.setAllowUserInteraction(false);
                                                    object = (URLByteArraySource)this.urlByteArray.getByteArraySource();
                                                    String string = ((URLByteArraySource)object).getAuthHeader();
                                                    if (string != null) {
                                                        this.connection.setRequestProperty("Authorization", string);
                                                    }
                                                } else {
                                                    this.connection.setAllowUserInteraction(true);
                                                }
                                                if (!this.requestedBytes.isUniversal() && this.connection instanceof HttpURLConnection) {
                                                    this.connection.setRequestProperty("Range", this.requestedBytes.toRangeString());
                                                }
                                                this.connection.connect();
                                                this.substream = this.connection.getInputStream();
                                                break;
                                            }
                                            catch (IOException iOException) {
                                                if (n != 4) break block52;
                                                this.savedIOException = this.translateException(iOException);
                                                var6_4 = null;
                                                try {
                                                    if (this.substream != null) {
                                                        this.substream.close();
                                                    }
                                                }
                                                catch (IOException iOException2) {}
                                                if (this.connection instanceof HttpURLConnection) {
                                                    ((HttpURLConnection)this.connection).disconnect();
                                                }
                                                Object var3_16 = null;
                                                if (this.savedIOException != null) {
                                                    this.byteCache.setError(this.savedIOException);
                                                }
                                                this.closed = true;
                                                return;
                                            }
                                            catch (Exception exception) {
                                                if (n != 4) break block52;
                                                this.savedIOException = new URLByteArrayException("Error:File:FileNotFound", new Object[]{Util.decodeURL(uRL.toString())});
                                                var6_4 = null;
                                                try {}
                                                catch (IOException iOException) {}
                                                if (this.substream != null) {
                                                    this.substream.close();
                                                }
                                                if (this.connection instanceof HttpURLConnection) {
                                                    ((HttpURLConnection)this.connection).disconnect();
                                                }
                                                Object var3_17 = null;
                                                if (this.savedIOException != null) {
                                                    this.byteCache.setError(this.savedIOException);
                                                }
                                                this.closed = true;
                                                return;
                                            }
                                        }
                                        ++n;
                                    }
                                    this.isMultipart = false;
                                    this.realByteRange = ByteRange.getUniversalByteRange();
                                    if (this.connection instanceof HttpURLConnection) {
                                        object = (HttpURLConnection)this.connection;
                                        int n2 = ((HttpURLConnection)object).getResponseCode();
                                        Properties properties = this.parseContentType(this.connection.getContentType());
                                        if (n2 == 206) {
                                            String string = this.connection.getHeaderField("Content-range");
                                            if (string != null) {
                                                this.realByteRange = new ByteRange(this.parseContentRange(string));
                                            } else {
                                                this.partBoundary = properties.getProperty("boundary");
                                                if (this.partBoundary != null) {
                                                    this.partBoundary = "--" + this.partBoundary;
                                                    this.isMultipart = true;
                                                    this.realByteRange = this.requestedBytes;
                                                }
                                            }
                                            this.currByteRange = this.realByteRange;
                                        } else if (n2 != 200) {
                                            this.savedIOException = n2 == 404 ? new URLByteArrayException("Error:File:FileNotFound", new Object[]{Util.decodeURL(uRL.toString())}) : new URLByteArrayException("Error:HTTP:BadResponseCode", new Object[]{Util.decodeURL(uRL.toString()), Integer.toString(n2)});
                                            var6_4 = null;
                                            break block54;
                                        }
                                    }
                                    int n3 = 0;
                                    while (!this.closed && (this.partBR != null || this.parsePartBoundary(this.substream))) {
                                        int n4 = this.byteCache.addBytes(this, this.partBR);
                                        int n5 = this.partBR.getStart();
                                        if (n4 > 0) {
                                            n3 += n4;
                                            this.requestedBytes = this.requestedBytes.subtract(new ContiguousByteRange(n5, n5 + n4 - 1));
                                            this.partBR = this.partBR.decapitate(n5 + n4);
                                            continue;
                                        }
                                        this.urlByteArray.setLengthUpperBound(n5);
                                        this.requestedBytes = this.requestedBytes.truncate(n5);
                                        break block55;
                                    }
                                    break block55;
                                }
                                catch (IOException iOException) {
                                    this.savedIOException = this.translateException(iOException);
                                    var6_4 = null;
                                    try {}
                                    catch (IOException iOException3) {}
                                    if (this.substream != null) {
                                        this.substream.close();
                                    }
                                    if (this.connection instanceof HttpURLConnection) {
                                        ((HttpURLConnection)this.connection).disconnect();
                                    }
                                    Object var3_19 = null;
                                    if (this.savedIOException != null) {
                                        this.byteCache.setError(this.savedIOException);
                                    }
                                    this.closed = true;
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                var6_4 = null;
                                try {}
                                catch (IOException iOException) {}
                                if (this.substream != null) {
                                    this.substream.close();
                                }
                                if (!(this.connection instanceof HttpURLConnection)) throw throwable;
                                ((HttpURLConnection)this.connection).disconnect();
                                throw throwable;
                            }
                        }
                        try {}
                        catch (IOException iOException) {}
                        if (this.substream != null) {
                            this.substream.close();
                        }
                        if (this.connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)this.connection).disconnect();
                        }
                        Object var3_18 = null;
                        if (this.savedIOException != null) {
                            this.byteCache.setError(this.savedIOException);
                        }
                        this.closed = true;
                        return;
                    }
                    var6_4 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (this.substream != null) {
                        this.substream.close();
                    }
                    if (!(this.connection instanceof HttpURLConnection)) continue;
                    ((HttpURLConnection)this.connection).disconnect();
                }
            }
            catch (Exception exception) {
                Log.log("URLByteStream:UniversalConnectWithRedirect Refused: " + exception.toString());
                this.savedIOException = new URLByteArrayException("Error:HTTP:Unauthorized", null);
            }
        }
        catch (Throwable throwable) {
            Object var3_21 = null;
            if (this.savedIOException != null) {
                this.byteCache.setError(this.savedIOException);
            }
            this.closed = true;
            throw throwable;
        }
        Object var3_20 = null;
        if (this.savedIOException != null) {
            this.byteCache.setError(this.savedIOException);
        }
        this.closed = true;
    }

    private IOException translateException(IOException iOException) {
        if (iOException instanceof UnknownHostException) {
            iOException = new URLByteArrayException("Error:File:FileNotFound", new Object[]{Util.decodeURL(iOException.getLocalizedMessage())});
        } else if (iOException instanceof FileNotFoundException) {
            iOException = new URLByteArrayException("Error:File:FileNotFound", new Object[]{Util.decodeURL(iOException.getLocalizedMessage())});
        }
        return iOException;
    }
}

