/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.file;

import com.adobe.acrobat.bytearray.ByteCache;
import com.adobe.acrobat.bytearray.ByteRange;
import com.adobe.acrobat.bytearray.CachingByteArray;
import com.adobe.acrobat.file.URLByteArraySource;
import com.adobe.acrobat.file.URLByteStream;
import java.io.IOException;
import java.net.URL;

class URLByteArray
extends CachingByteArray {
    URLByteStream currByteStream = null;
    URL url;

    URLByteArray(URLByteArraySource uRLByteArraySource, URL uRL, byte[] byArray) throws IOException {
        super(uRLByteArraySource, byArray);
        this.url = uRL;
        this.setLengthUpperBound(uRLByteArraySource.getContentLength());
    }

    protected boolean canDoByteRanges() {
        return ((URLByteArraySource)this.getByteArraySource()).canDoByteRanges();
    }

    public synchronized void close() throws Exception {
        if (this.currByteStream != null && !this.currByteStream.isClosed()) {
            this.currByteStream.close();
        }
        this.currByteStream = null;
    }

    protected synchronized void requestBytes(ByteCache byteCache, ByteRange byteRange) throws IOException {
        Object object;
        ByteRange byteRange2 = byteCache.getCachedByteRange();
        byteRange = byteRange.truncate(this.getLengthUpperBound());
        if (this.currByteStream != null) {
            if (this.currByteStream.isClosed()) {
                this.currByteStream = null;
            } else if (((URLByteArraySource)this.getByteArraySource()).canDoByteRanges()) {
                object = this.currByteStream.getRealByteRange();
                ByteRange byteRange3 = byteRange2.union((ByteRange)object);
                ByteRange byteRange4 = ((ByteRange)object).intersect(byteRange);
                if (!byteRange3.contains(byteRange) || byteRange4.isEmpty() || ((ByteRange)object).byteIndex(byteRange4.getStart()) > 10000) {
                    this.currByteStream.close();
                    this.currByteStream = null;
                }
            }
        }
        if (this.currByteStream == null) {
            byteRange2 = byteCache.getCachedByteRange();
            if ((byteRange = byteRange.subtract(byteRange2)).isEmpty()) {
                return;
            }
            this.currByteStream = object = new URLByteStream(this, byteCache, byteRange);
        }
    }
}

