/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VStreamFactory;
import com.adobe.util.MemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextArea;
import java.io.InputStream;

class StreamInspectorView
extends TextArea
implements VObserver,
Runnable,
StrobeContainer {
    public static final int kBufSize = 2048;
    private VStreamFactory vStreamFactory;
    private StreamFactory streamFactory = null;
    private VStrobe strobe;
    private Thread ownerThread = null;

    StreamInspectorView(VStreamFactory vStreamFactory, int n, int n2) throws Exception {
        super("", 0, n, n2);
        this.setEditable(false);
        ((Component)this).setBackground(Color.white);
        this.vStreamFactory = vStreamFactory;
        this.strobe = new VStrobe(this);
    }

    protected void beginStream() {
    }

    public void change(Requester requester) {
        this.interruptOwnerThread();
        try {
            this.streamFactory = this.vStreamFactory.streamFactoryValue(requester);
        }
        catch (Exception exception) {
            this.streamFactory = null;
            Log.clog("StreamInspectorView.change: " + exception.toString());
        }
        if (this.streamFactory != null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    protected String endStream(Exception exception) {
        return exception == null ? "" : exception.toString();
    }

    private Thread getOwnerThread() {
        return this.ownerThread;
    }

    protected String handleBytes(byte[] byArray, int n) {
        return "";
    }

    private void interruptOwnerThread() {
        if (this.ownerThread != null) {
            this.ownerThread.interrupt();
        }
    }

    void killOwnerThread() {
        while (this.ownerThread != null && this.ownerThread.isAlive()) {
            this.ownerThread.interrupt();
            try {
                this.ownerThread.join(500L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void run() {
        try {
            try {
                this.setOwnerThread(Thread.currentThread());
                InputStream inputStream = this.streamFactory.getInputStream();
                byte[] byArray = MemUtil.allocByte(2048);
                boolean bl = false;
                int n = 0;
                this.setText("");
                this.beginStream();
                while (!bl) {
                    int n2;
                    int n3;
                    for (n2 = 0; n2 < byArray.length; n2 += n3) {
                        n3 = inputStream.read(byArray, n2, byArray.length - n2);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        if (n3 != -1) {
                            n += n3;
                            continue;
                        }
                        bl = true;
                        break;
                    }
                    this.append(this.handleBytes(byArray, n2));
                }
            }
            catch (InterruptedException interruptedException) {
                this.append("\n" + this.endStream(interruptedException));
            }
            catch (Exception exception) {
                this.append("\n" + this.endStream(exception));
            }
            Object var2_9 = null;
            this.append(this.endStream(null));
            this.unsetOwnerThread();
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            this.append(this.endStream(null));
            this.unsetOwnerThread();
            throw throwable;
        }
    }

    private void setOwnerThread(Thread thread) throws InterruptedException {
        this.killOwnerThread();
        this.ownerThread = thread;
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    private void unsetOwnerThread() {
        this.ownerThread = null;
    }
}

