/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.ArrayValuePanel;
import com.adobe.acrobat.debug.DictValuePanel;
import com.adobe.acrobat.debug.PDFReferenceInfoPanel;
import com.adobe.acrobat.debug.ScalarValuePanel;
import com.adobe.acrobat.debug.VResolvedChain;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Panel;

public class PDFObjInspectorPanel
extends Panel
implements VObserver,
StrobeContainer {
    private VPDFObj vObj;
    private VStrobe strobe;
    private VResolvedChain vChain;
    private PDFReferenceInfoPanel refPanel;
    private Panel cardPanel;
    private CardLayout cardLayout;

    public PDFObjInspectorPanel(VPDFObj vPDFObj, VPDFReference vPDFReference) throws Exception {
        this(vPDFObj, vPDFReference, null);
    }

    public PDFObjInspectorPanel(VPDFObj vPDFObj, VPDFReference vPDFReference, VResolvedChain vResolvedChain) throws Exception {
        this.vObj = vPDFObj;
        this.vChain = vResolvedChain;
        this.setLayout(new BorderLayout());
        this.refPanel = new PDFReferenceInfoPanel(vPDFObj);
        this.add((Component)this.refPanel, "North");
        this.cardPanel = new Panel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.add((Component)this.cardPanel, "Center");
        ScalarValuePanel scalarValuePanel = new ScalarValuePanel(vPDFObj);
        this.cardPanel.add((Component)scalarValuePanel, "Scalar");
        DictValuePanel dictValuePanel = new DictValuePanel(vPDFObj, vPDFReference, vResolvedChain);
        this.cardPanel.add((Component)dictValuePanel, "Dict");
        ArrayValuePanel arrayValuePanel = new ArrayValuePanel(vPDFObj);
        this.cardPanel.add((Component)arrayValuePanel, "Array");
        this.strobe = new VStrobe(this);
    }

    public PDFObjInspectorPanel(VPDFReference vPDFReference, VResolvedChain vResolvedChain) throws Exception {
        this(vResolvedChain.getVTail(), vPDFReference, vResolvedChain);
    }

    public void change(Requester requester) {
        try {
            PDFObj pDFObj = this.vObj.pdfObjValue(requester);
            int n = pDFObj.type(requester);
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.cardLayout.show(this.cardPanel, "Scalar");
                    break;
                }
                case 6: {
                    this.cardLayout.show(this.cardPanel, "Dict");
                    break;
                }
                case 7: {
                    this.cardLayout.show(this.cardPanel, "Array");
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            Log.clog("PDFObjInspectorPanel.change: " + exception.toString());
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

