/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.debug.PDFContentInspector;
import com.adobe.acrobat.debug.PDFStreamInspector;
import com.adobe.acrobat.debug.VResolvedChain;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.page.VFormContentArray;
import com.adobe.acrobat.page.VPageContentArray;
import com.adobe.acrobat.page.VXObjectFormProps;
import com.adobe.acrobat.pdf.PDFFont;
import com.adobe.acrobat.pdf.Pattern;
import com.adobe.acrobat.pdf.VContentsStreamFactory;
import com.adobe.acrobat.pdf.VPDFFont;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdf.VPattern;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.util.Log;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.util.PEUtil;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VStreamFactory;
import com.adobe.util.Assert;
import com.adobe.util.MemUtil;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DictValuePanel
extends Panel
implements VObserver,
ActionListener,
StrobeContainer {
    private static final String Type_K = "Type";
    private VStrobe strobe;
    private VPDFObj vObj;
    private VPDFReference vImpliedResources;
    private VResolvedChain vChain;
    private Button dumpFilteredButton;
    private Button dumpUnfilteredButton;
    private Button filteredSaveButton;
    private Button unfilteredSaveButton;
    private Button contentsButton;
    private VContentArray vContent;
    private VFloatRect vContentBounds;
    private VAffineTransform vContentTransform;
    private VStreamFactory vContentStreamFactory;
    private static final String Page_K = "Page";
    private static final String XObject_K = "XObject";
    private static final String Pattern_K = "Pattern";
    private static final String Subtype_K = "Subtype";
    private static final String Form_K = "Form";

    public DictValuePanel(VPDFObj vPDFObj, VPDFReference vPDFReference, VResolvedChain vResolvedChain) throws Exception {
        this.vObj = vPDFObj;
        this.vChain = vResolvedChain;
        this.vImpliedResources = vPDFReference;
        this.setLayout(new GridLayout(3, 2, 5, 50));
        this.dumpFilteredButton = new Button("Stream (filtered)");
        this.add(this.dumpFilteredButton);
        this.filteredSaveButton = new Button("Save");
        this.add(this.filteredSaveButton);
        this.dumpUnfilteredButton = new Button("Stream (unfiltered)");
        this.add(this.dumpUnfilteredButton);
        this.unfilteredSaveButton = new Button("Save");
        this.add(this.unfilteredSaveButton);
        this.contentsButton = new Button("Contents");
        this.add(this.contentsButton);
        this.dumpFilteredButton.addActionListener(this);
        this.dumpUnfilteredButton.addActionListener(this);
        this.filteredSaveButton.addActionListener(this);
        this.unfilteredSaveButton.addActionListener(this);
        this.contentsButton.addActionListener(this);
        this.strobe = new VStrobe(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.dumpFilteredButton || actionEvent.getSource() == this.dumpUnfilteredButton) {
                boolean bl = this.dumpFilteredButton == actionEvent.getSource();
                PDFObj pDFObj = this.vObj.pdfObjValue(null);
                if (pDFObj instanceof PDFReference) {
                    VStreamFactory vStreamFactory = bl ? ((PDFReference)pDFObj).getFilteredVStreamFactory() : ((PDFReference)pDFObj).getUnfilteredVStreamFactory();
                    Frame frame = PDFStreamInspector.createPDFStreamInspectorWindow(vStreamFactory, (PDFReference)pDFObj);
                    frame.show();
                }
            } else if (actionEvent.getSource() == this.unfilteredSaveButton) {
                PDFObj pDFObj = this.vObj.pdfObjValue(null);
                if (pDFObj instanceof PDFReference) {
                    VStreamFactory vStreamFactory = ((PDFReference)pDFObj).getUnfilteredVStreamFactory();
                    StreamFactory streamFactory = vStreamFactory.streamFactoryValue(null);
                    InputStream inputStream = streamFactory.getInputStream();
                    this.saveToFile(inputStream, false);
                }
            } else if (actionEvent.getSource() == this.filteredSaveButton) {
                PDFObj pDFObj = this.vObj.pdfObjValue(null);
                if (pDFObj instanceof PDFReference) {
                    VStreamFactory vStreamFactory = ((PDFReference)pDFObj).getFilteredVStreamFactory();
                    StreamFactory streamFactory = vStreamFactory.streamFactoryValue(null);
                    InputStream inputStream = streamFactory.getInputStream();
                    this.saveToFile(inputStream, true);
                }
            } else if (actionEvent.getSource() == this.contentsButton) {
                PDFContentInspector pDFContentInspector = new PDFContentInspector(this.vContent, this.vContentBounds, this.vContentTransform, this.vContentStreamFactory);
                pDFContentInspector.show();
            }
        }
        catch (Exception exception) {
            Log.clog("DictValuePanel.change " + exception.toString());
        }
    }

    public void change(Requester requester) throws WriteLockException {
        boolean bl;
        try {
            bl = false;
            PDFObj pDFObj = this.vObj.pdfObjValue(requester);
            int n = pDFObj.type(requester);
            if (n == 6) {
                Assert.notFalse(pDFObj instanceof PDFReference);
                PDFReference pDFReference = pDFObj.pdfReferenceValue(requester);
                PDFDict pDFDict = pDFObj.dictValue(requester);
                StreamFactory streamFactory = pDFReference.getUnfilteredVStreamFactory().streamFactoryValue(requester);
                if (streamFactory != null) {
                    bl = true;
                }
            }
            this.dumpFilteredButton.setEnabled(bl);
            this.dumpUnfilteredButton.setEnabled(bl);
            this.filteredSaveButton.setEnabled(bl);
            this.unfilteredSaveButton.setEnabled(bl);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            this.dumpFilteredButton.setEnabled(false);
            this.dumpUnfilteredButton.setEnabled(false);
            this.filteredSaveButton.setEnabled(false);
            this.unfilteredSaveButton.setEnabled(false);
        }
        try {
            bl = false;
            this.setUpVContentStuff(requester);
            bl = this.vContent != null;
            this.contentsButton.setEnabled(bl);
        }
        catch (WriteLockException writeLockException) {
            throw writeLockException;
        }
        catch (Exception exception) {
            this.contentsButton.setEnabled(false);
        }
    }

    public static int filterCRs(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = byArray[n3];
            switch ((char)n5) {
                case '\n': 
                case '\r': {
                    n4 = 10;
                    while (n3 < n - 1 && (byArray[n3 + 1] == 114 || byArray[n3 + 1] == 10)) {
                        ++n3;
                    }
                    break;
                }
                case '\u0000': {
                    n4 = 1;
                    break;
                }
                default: {
                    n4 = n5;
                }
            }
            byArray[n2++] = n4;
            ++n3;
        }
        return n2;
    }

    private void saveToFile(InputStream inputStream, boolean bl) throws IOException {
        FileDialog fileDialog = new FileDialog(PEUtil.getFrame(this), "Save Stream To File", 1);
        fileDialog.show();
        String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
        if (string != null && string.length() > 0) {
            int n;
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = MemUtil.allocByte(5120);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                if (!bl) continue;
                DictValuePanel.filterCRs(byArray, n);
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }

    private void setUpVContentStuff(Requester requester) throws Exception {
        StreamFactory streamFactory;
        PDFObj pDFObj;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PDFObj pDFObj2;
        this.vContent = null;
        this.vContentBounds = null;
        this.vContentTransform = null;
        this.vContentStreamFactory = null;
        PDFObj pDFObj3 = this.vObj.pdfObjValue(requester);
        if (!(pDFObj3 instanceof PDFReference)) {
            return;
        }
        PDFReference pDFReference = pDFObj3.pdfReferenceValue(requester);
        if (pDFObj3.type(requester) != 6) {
            return;
        }
        PDFDict pDFDict = pDFObj3.dictValue(requester);
        if (pDFDict.hasKey(Type_K) && (pDFObj2 = pDFDict.get(Type_K)).type(requester) == 5) {
            object4 = pDFObj2.nameValue(requester);
            if (((String)object4).equals(Page_K)) {
                this.vContent = VPageContentArray.getVPageContentArray(pDFReference);
                this.vContentBounds = VPageProps.getCropBox(pDFReference);
                this.vContentTransform = VPageProps.getDefaultTransform(pDFReference);
                this.vContentStreamFactory = VContentsStreamFactory.getVContentsStreamFactory(pDFReference);
                return;
            }
            if (((String)object4).equals(XObject_K)) {
                pDFObj2 = pDFDict.get(Subtype_K);
                if (pDFObj2.type(requester) == 5 && pDFObj2.nameValue(requester).equals(Form_K)) {
                    this.vContent = VFormContentArray.getVFormContentArray(pDFReference);
                    this.vContentBounds = VXObjectFormProps.getFormVBBox(pDFReference);
                    this.vContentTransform = new VFormTransform(pDFReference);
                    this.vContentStreamFactory = pDFReference.getFilteredVStreamFactory();
                    return;
                }
            } else if (((String)object4).equals(Pattern_K) && (object3 = ((Pattern)(object2 = ((VPattern)(object = VPattern.getVPattern(pDFReference, (PDFReference)(pDFObj = this.vImpliedResources.pdfReferenceValue(requester))))).patternValue(requester))).getContentArray()) != null) {
                this.vContent = new VContentArray(((Pattern)object2).getContentArray());
                this.vContentBounds = new VFloatRect(((Pattern)object2).getBBox());
                this.vContentTransform = new VAffineTransform(((Pattern)object2).getTransform());
                this.vContentStreamFactory = pDFReference.getFilteredVStreamFactory();
                return;
            }
        }
        if (this.vChain != null) {
            int n = this.vChain.getNumContainers(requester);
            if (n < 3) {
                return;
            }
            object4 = this.vChain.nthContainerRef(n - 1, requester);
            if (((PDFObj)object4).type(requester) != 6) {
                return;
            }
            pDFObj = this.vChain.nthContainer(n - 2, requester);
            if (pDFObj.type(requester) != 6) {
                return;
            }
            object = this.vChain.nthSelectedKey(n - 3, requester);
            if (object instanceof String && object.equals("CharProcs")) {
                object2 = this.vImpliedResources.pdfReferenceValue(requester);
                object3 = (String)this.vChain.nthSelectedKey(n - 2, requester);
                PDFReference pDFReference2 = this.vChain.nthContainerRef(n - 3, requester);
                PDFFont pDFFont = VPDFFont.getVPDFFont(pDFReference2, (PDFReference)object2).pdfFontValue(requester);
                this.vContent = new VContentArray(pDFFont.getCharProc((String)object3));
                this.vContentBounds = new VFloatRect(pDFFont.getFontBBox());
                this.vContentTransform = new VAffineTransform(AffineTransform.getIdentityMatrix());
                this.vContentStreamFactory = ((PDFObj)object4).pdfReferenceValue(requester).getFilteredVStreamFactory();
                return;
            }
        }
        if ((streamFactory = pDFReference.getFilteredVStreamFactory().streamFactoryValue(requester)) != null) {
            this.vContent = VFormContentArray.getVFormContentArray(pDFReference);
            this.vContentBounds = VXObjectFormProps.getFormVBBox(pDFReference);
            this.vContentTransform = new VFormTransform(pDFReference);
            this.vContentStreamFactory = pDFReference.getFilteredVStreamFactory();
        }
    }

    static class VFormTransform
    extends VAffineTransform {
        private PDFReference formRef;

        VFormTransform(PDFReference pDFReference) {
            this.formRef = pDFReference;
        }

        protected final AffineTransform computeAffineTransform(Requester requester) throws Exception {
            AffineTransform affineTransform = VXObjectFormProps.getFormVMatrix(this.formRef).affineTransformValue(requester);
            FloatRect floatRect = VXObjectFormProps.getFormVBBox(this.formRef).floatRectValue(requester);
            AffineTransform affineTransform2 = affineTransform.appendTransform(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, floatRect.getyMax()));
            return affineTransform2;
        }
    }
}

