/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.debug;

import com.adobe.acrobat.Viewer;
import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.debug.PDFContentInspector;
import com.adobe.acrobat.debug.PDFObjStoreInspector;
import com.adobe.acrobat.debug.PDFStreamInspector;
import com.adobe.acrobat.debug.PageFlipper;
import com.adobe.acrobat.debug.PageViewInspector;
import com.adobe.acrobat.gui.AcroViewContext;
import com.adobe.acrobat.gui.PageView;
import com.adobe.acrobat.gui.SimpleUIVerb;
import com.adobe.acrobat.page.VContentArray;
import com.adobe.acrobat.page.VPageContentArray;
import com.adobe.acrobat.pdf.VContentsStreamFactory;
import com.adobe.acrobat.pdf.VPageProps;
import com.adobe.acrobat.pdfobjstore.PDFArray;
import com.adobe.acrobat.pdfobjstore.PDFDict;
import com.adobe.acrobat.pdfobjstore.PDFDirectObj;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.PDFReal;
import com.adobe.acrobat.pdfobjstore.PDFReference;
import com.adobe.acrobat.pdfobjstore.VPDFReference;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.acrobat.vtypes.VAffineTransform;
import com.adobe.acrobat.vtypes.VFloatRect;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.debug.DependencyInspector;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.util.StreamFactory;
import com.adobe.pe.vtypes.VBoolean;
import com.adobe.pe.vtypes.VStreamFactory;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;

class DebugUIVerb
extends UIVerb {
    static final int kFlipPages = 1;
    static final int kInspectDocument = 2;
    static final int kInspectPage = 3;
    static final int kInspectContents = 4;
    static final int kInspectDependencies = 5;
    static final int kInspectDocStream = 6;
    static final int kInspectPageView = 7;
    static final int kGrowMediaBox = 8;
    AcroViewContext context;
    int selector;

    DebugUIVerb(AcroViewContext acroViewContext, int n) {
        this.context = acroViewContext;
        this.selector = n;
        DebugTransactor debugTransactor = new DebugTransactor();
        VDebugVerbEnabledBoolean vDebugVerbEnabledBoolean = new VDebugVerbEnabledBoolean();
        this.setAttributes(debugTransactor, vDebugVerbEnabledBoolean, null);
    }

    class DebugTransactor
    extends Transactor {
        DebugTransactor() {
        }

        public void buildChanges(Transaction transaction) throws Exception {
            switch (DebugUIVerb.this.selector) {
                case 1: {
                    this.togglePageFlipper(transaction);
                    break;
                }
                case 2: {
                    this.createPDFInspector(transaction, DebugUIVerb.this.context.getPDFObjStore(transaction).getTrailer());
                    break;
                }
                case 3: {
                    PageView pageView = DebugUIVerb.this.context.getPageView();
                    PDFReference pDFReference = pageView.getCurrentPageRef(transaction);
                    VPDFReference vPDFReference = new VPDFReference(pDFReference);
                    this.createPDFInspector(transaction, vPDFReference);
                    break;
                }
                case 4: {
                    this.inspectPageContents(transaction);
                    break;
                }
                case 5: {
                    this.showDependencyInspector(transaction);
                    break;
                }
                case 6: {
                    this.inspectDocStream(transaction);
                    break;
                }
                case 7: {
                    this.inspectPageView(transaction);
                    break;
                }
                case 8: {
                    this.growMediaBox(transaction);
                    break;
                }
            }
        }

        private void createPDFInspector(Transaction transaction, VPDFReference vPDFReference) throws Exception {
            PDFObjStoreInspector pDFObjStoreInspector = new PDFObjStoreInspector(vPDFReference, VPageProps.getResources(vPDFReference));
            pDFObjStoreInspector.show();
        }

        void growMediaBox(Transaction transaction) throws Exception {
            PDFObjStore pDFObjStore = DebugUIVerb.this.context.getPDFObjStore(transaction);
            PDFReference pDFReference = DebugUIVerb.this.context.getPageView().getCurrentPageRef(transaction);
            FloatRect floatRect = VPageProps.getMediaBox(pDFReference).floatRectValue(transaction);
            FloatRect floatRect2 = new FloatRect(floatRect.getxMin() - 25.0, floatRect.getyMin() - 25.0, floatRect.getxMax() + 25.0, floatRect.getyMax() + 25.0);
            PDFArray pDFArray = new PDFArray(new PDFObj[]{new PDFReal(floatRect2.getxMin()), new PDFReal(floatRect2.getyMin()), new PDFReal(floatRect2.getxMax()), new PDFReal(floatRect2.getyMax())});
            PDFDict pDFDict = pDFReference.dictValue(transaction);
            PDFDict pDFDict2 = new PDFDict(pDFDict, "MediaBox", new PDFDirectObj(pDFObjStore, pDFArray));
            pDFReference.setReferent(transaction, pDFDict2);
        }

        private void inspectDocStream(Transaction transaction) throws Exception {
            VByteArrayStreamFactory vByteArrayStreamFactory = new VByteArrayStreamFactory();
            Frame frame = PDFStreamInspector.createPDFStreamInspectorWindow(vByteArrayStreamFactory, null);
            frame.show();
        }

        private void inspectPageContents(Transaction transaction) throws Exception {
            PDFReference pDFReference = DebugUIVerb.this.context.getPageView().getCurrentPageRef(transaction);
            VContentArray vContentArray = VPageContentArray.getVPageContentArray(pDFReference);
            VFloatRect vFloatRect = VPageProps.getCropBox(pDFReference);
            VAffineTransform vAffineTransform = VPageProps.getDefaultTransform(pDFReference);
            VStreamFactory vStreamFactory = VContentsStreamFactory.getVContentsStreamFactory(pDFReference);
            PDFContentInspector pDFContentInspector = new PDFContentInspector(vContentArray, vFloatRect, vAffineTransform, vStreamFactory);
            pDFContentInspector.show();
        }

        void inspectPageView(Transaction transaction) throws Exception {
            Frame frame = PageViewInspector.createPageViewInspector(DebugUIVerb.this.context.getPageView());
            frame.show();
        }

        void showDependencyInspector(Transaction transaction) throws Exception {
            AcroViewContext acroViewContext = DebugUIVerb.this.context;
            DependencyInspector dependencyInspector = new DependencyInspector(acroViewContext.getVPDFObjStore());
            WindowAdapter windowAdapter = new WindowAdapter(dependencyInspector){
                private final /* synthetic */ DependencyInspector val$dependencyInspector;
                {
                    this.val$dependencyInspector = dependencyInspector;
                }

                public void windowDidClose(WindowEvent windowEvent) {
                    Viewer.unregisterViewerWindow(this.val$dependencyInspector);
                }
            };
            dependencyInspector.addWindowListener(windowAdapter);
            Viewer.registerViewerWindow(dependencyInspector);
            dependencyInspector.addRoot(acroViewContext.getVByteArraySource());
            dependencyInspector.addRoot(acroViewContext.getPageView().getVPainting());
            dependencyInspector.addRoot(acroViewContext.getPageView().getVMousePosition());
        }

        void togglePageFlipper(Transaction transaction) throws Exception {
            PageFlipper pageFlipper = PageFlipper.getPageFlipper(DebugUIVerb.this.context);
            pageFlipper.setStrobeActive(transaction, true);
            VBoolean vBoolean = PageFlipper.getFlippingVBoolean(DebugUIVerb.this.context);
            vBoolean.setBooleanValue(transaction, vBoolean.booleanValue(transaction) ^ true);
        }

        class ByteArrayStreamFactory
        extends StreamFactory {
            private ByteArray ba;

            ByteArrayStreamFactory(ByteArray byteArray) {
                this.ba = byteArray;
            }

            public InputStream getInputStream() throws Exception {
                return this.ba.getByteStream(0);
            }
        }

        class VByteArrayStreamFactory
        extends VStreamFactory {
            VByteArrayStreamFactory() {
            }

            protected final StreamFactory computeStreamFactory(Requester requester) throws Exception {
                PDFObjStore pDFObjStore = ((DebugTransactor)DebugTransactor.this).DebugUIVerb.this.context.getPDFObjStore(requester);
                ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
                return new ByteArrayStreamFactory(byteArray);
            }
        }
    }

    class VDebugVerbEnabledBoolean
    extends VBoolean {
        VDebugVerbEnabledBoolean() {
        }

        protected final boolean computeBoolean(Requester requester) throws Exception {
            switch (DebugUIVerb.this.selector) {
                case 5: {
                    return true;
                }
            }
            return SimpleUIVerb.getVDocIsOpenBoolean(DebugUIVerb.this.context).booleanValue(requester);
        }
    }
}

