/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.schematron;

import com.thaiopensource.relaxng.XMLReaderCreator;
import com.thaiopensource.relaxng.util.Sax2XMLReaderCreator;
import com.thaiopensource.relaxng.util.ValidationEngine;
import com.topologi.schematron.SchtrnValidator;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EmbRNGValidator {
    private SchtrnValidator schtrnValidator = null;
    private TransformerFactory theFactory = TransformerFactory.newInstance();
    private ValidationMonitor valMonitor;
    private StreamSource extractorStylesheet = null;
    private short validationOption = 0;
    public static final short BOTH = 0;
    public static final short ONLY_RNG = 1;
    public static final short ONLY_SCHTRN = 2;

    public EmbRNGValidator() {
        this.schtrnValidator = new SchtrnValidator();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Not enough arguments.");
            EmbRNGValidator.printUsage();
            System.exit(0);
        }
        String xml = args[0];
        String schema = args[1];
        EmbRNGValidator validator = new EmbRNGValidator();
        validator.getSchtrnValidator().setParams(SchtrnValidator.parseArgs(args));
        validator.setValidationOption((short)0);
        validator.setExtractorStylesheet("Scripts" + File.separator + "RNG2Schtrn.xsl");
        System.out.println(validator.validate(xml, schema));
    }

    private static void printUsage() {
        System.out.println("Usage: EmbRNGValidator 'xml' 'schema' {param=value}...\n\n<xml>       : The location of the XML instance document\n<schema>    : The location of the RELAX-NG schema\n\nSupported parameters:\n  diagnose  : <yes>|<no>  If yes then diagnostics will be \n               included in the result if specified in the Schematron\n               schema and supported by the engine stylesheet.\n  phase     :  The name of the phase that should be used for validation.\n               If unspecified then all phases will be used unless\n               the schema specifies the 'defaultPhase' attribute.");
    }

    public String validate(String xml, String schema) {
        String schemaURL;
        String xmlURL = SchtrnValidator.system_To_URL(xml);
        if (xmlURL == null) {
            System.out.println("The xml file location is not valid: " + xml);
            System.exit(0);
        }
        if ((schemaURL = SchtrnValidator.system_To_URL(schema)) == null) {
            System.out.println("The RELAX-NG schema location is not valid: " + schema);
            System.exit(0);
        }
        return this.validate(new StreamSource(xmlURL), new StreamSource(schemaURL));
    }

    public String validate(StreamSource xml, StreamSource schema) {
        StringBuffer results = new StringBuffer();
        this.valMonitor = new ValidationMonitor();
        if (this.validationOption == 1) {
            this.valMonitor.schtrnDone();
        } else if (this.validationOption == 2) {
            this.valMonitor.rngDone();
        }
        if (this.validationOption == 1) {
            this.performRNGValidation(xml, schema, results);
        } else if (this.validationOption == 2) {
            this.performSchtrnValidation(xml, schema, results);
        } else {
            this.performSchtrnValidation(xml, schema, results);
            this.performRNGValidation(xml, schema, results);
        }
        if (!this.valMonitor.waitForValidation()) {
            results.append("\n\nAn error occurred when waiting for the validation to finish.");
        }
        return results.toString();
    }

    private void performRNGValidation(final StreamSource xml, final StreamSource schema, final StringBuffer results) {
        Thread rngValidation = new Thread(){

            public void run() {
                String rngResults = EmbRNGValidator.this.executeRNGValidation(xml, schema);
                StringBuffer stringBuffer = results;
                synchronized (stringBuffer) {
                    results.append("Validation results from RELAX-NG:\n\n");
                    results.append(rngResults);
                    results.append("\n\n\n");
                }
                EmbRNGValidator.this.valMonitor.rngDone();
            }
        };
        rngValidation.start();
    }

    private String executeRNGValidation(StreamSource xml, StreamSource schema) {
        StringBuffer results = new StringBuffer();
        ValidationEngine engine = new ValidationEngine((XMLReaderCreator)new Sax2XMLReaderCreator("com.icl.saxon.aelfred.SAXDriver"), null, true);
        try {
            InputSource schemaSource = new InputSource(schema.getInputStream());
            schemaSource.setSystemId(schema.getSystemId());
            engine.loadSchema(schemaSource);
            InputSource xmlSource = new InputSource(xml.getInputStream());
            xmlSource.setSystemId(xml.getSystemId());
            engine.validate(xmlSource);
        }
        catch (SAXParseException se) {
            results.append(se.getSystemId()).append(":").append(se.getLineNumber());
            results.append(":").append(se.getColumnNumber()).append(":");
            results.append(se.getMessage()).append("\n");
        }
        catch (SAXException e) {
            results.append(e.getMessage()).append("\n");
        }
        catch (Exception e) {
            results.append(e.getMessage()).append("\n");
        }
        if (results.length() == 0) {
            results.append("RELAX-NG validation passed without errors.").append("\n");
        }
        return results.toString();
    }

    private void performSchtrnValidation(final StreamSource xml, final StreamSource schema, final StringBuffer results) {
        Thread schtrnValidation = new Thread(){

            public void run() {
                String schtrnResults;
                try {
                    StreamSource schtrnSchema = EmbRNGValidator.this.extractEmbeddedRules(schema);
                    schtrnSchema.setSystemId(schema.getSystemId());
                    EmbRNGValidator.this.schtrnValidator.setEngineStylesheet("Scripts" + File.separator + "schematron-diagnose.xsl");
                    schtrnResults = EmbRNGValidator.this.schtrnValidator.validate(xml, schtrnSchema);
                }
                catch (TransformerConfigurationException tce) {
                    schtrnResults = tce.getMessageAndLocation();
                }
                catch (TransformerException te) {
                    schtrnResults = te.getMessageAndLocation();
                }
                catch (Exception e) {
                    schtrnResults = e.getMessage();
                }
                StringBuffer stringBuffer = results;
                synchronized (stringBuffer) {
                    results.append("Validation results from embedded Schematron rules:");
                    results.append(schtrnResults);
                    results.append("\n\n\n");
                }
                EmbRNGValidator.this.valMonitor.schtrnDone();
            }
        };
        schtrnValidation.start();
    }

    private StreamSource extractEmbeddedRules(StreamSource schema) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = this.theFactory.newTransformer(this.extractorStylesheet);
        StringWriter result = new StringWriter();
        transformer.transform(schema, new StreamResult(result));
        return new StreamSource(new StringReader(result.toString()));
    }

    public StreamSource getExtractorStylesheet() {
        return this.extractorStylesheet;
    }

    public void setExtractorStylesheet(String extractorFile) {
        if (extractorFile != null) {
            this.extractorStylesheet = new StreamSource(SchtrnValidator.system_To_URL(extractorFile));
        }
    }

    public short getValidationOption() {
        return this.validationOption;
    }

    public void setValidationOption(short validationOption) {
        this.validationOption = validationOption;
    }

    public SchtrnValidator getSchtrnValidator() {
        return this.schtrnValidator;
    }

    public void setSchtrnValidator(SchtrnValidator schtrnValidator) {
        this.schtrnValidator = schtrnValidator;
    }

    private class ValidationMonitor {
        private boolean rngIsDone = false;
        private boolean schtrnIsDone = false;

        public synchronized boolean waitForValidation() {
            try {
                while (!this.rngIsDone || !this.schtrnIsDone) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        public synchronized void schtrnDone() {
            this.schtrnIsDone = true;
            this.notifyAll();
        }

        public synchronized void rngDone() {
            this.rngIsDone = true;
            this.notifyAll();
        }
    }
}

