/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.schematron;

import com.topologi.schematron.SchtrnParams;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class SchtrnValidator {
    private SchtrnParams params;
    private TransformerFactory theFactory = TransformerFactory.newInstance();
    private StreamSource engineStylesheet = null;
    private boolean baseIsXML = true;

    public void setParams(SchtrnParams sp) {
        this.params = sp;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Not enough arguments.");
            SchtrnValidator.printUsage();
            System.exit(0);
        }
        String xml = args[0];
        String schema = args[1];
        SchtrnValidator validator = new SchtrnValidator();
        validator.setEngineStylesheet("Scripts" + File.separator + "schematron-diagnose.xsl");
        validator.setParams(SchtrnValidator.parseArgs(args));
        validator.setBaseXML(true);
        try {
            System.out.println(validator.validate(xml, schema));
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("Configuration error: " + tce.getMessageAndLocation());
        }
        catch (TransformerException te) {
            System.out.println("Transformation error: " + te.getMessageAndLocation());
        }
        catch (Exception e) {
            System.out.println("An error occurred: " + e.getMessage() + "\n" + e);
        }
    }

    static SchtrnParams parseArgs(String[] args) {
        SchtrnParams sp = new SchtrnParams();
        int i = 2;
        while (i < args.length) {
            int eq = args[i].indexOf(61);
            if (eq < 0) {
                System.out.println("In illegal argument was specified.");
                SchtrnValidator.printUsage();
                System.exit(0);
            }
            sp.setParam(args[i].substring(0, eq), args[i].substring(eq + 1));
            ++i;
        }
        return sp;
    }

    private static void printUsage() {
        System.out.println("Usage: SchtrnValidator <xml> <schema> {param=value}...\n\n<xml>       : The location of the XML instance document\n<schema>    : The location of the Schematron schema\n\nSupported parameters:\n  diagnose  : <yes>|<no>  If yes then diagnostics will be \n               included in the result if specified in the Schematron\n               schema and supported by the engine stylesheet.\n  phase     :  The name of the phase that should be used for validation.\n               If unspecified then all phases will be used unless\n               the schema specifies the 'defaultPhase' attribute.");
    }

    public String validate(String xml, String schema) throws TransformerConfigurationException, TransformerException, Exception {
        String xmlURL = SchtrnValidator.system_To_URL(xml);
        if (xmlURL == null) {
            throw new Exception("The xml file location is not valid: " + xml);
        }
        String schemaURL = SchtrnValidator.system_To_URL(schema);
        if (schemaURL == null) {
            throw new Exception("The Schematron schema location is not valid: " + schema);
        }
        return this.validate(new StreamSource(xmlURL), new StreamSource(schemaURL));
    }

    public String validate(StreamSource xml, StreamSource schema) throws TransformerConfigurationException, TransformerException {
        StreamSource validationStylesheet = this.getValidationStylesheet(schema, this.getEngineStylesheet());
        if (this.baseIsXML) {
            validationStylesheet.setSystemId(xml.getSystemId());
        } else {
            validationStylesheet.setSystemId(schema.getSystemId());
        }
        return this.transform(xml, validationStylesheet, null);
    }

    public String validate(StreamSource xml, StreamSource schema, StreamSource validator) throws TransformerConfigurationException, TransformerException {
        if (this.baseIsXML) {
            validator.setSystemId(xml.getSystemId());
        } else {
            validator.setSystemId(schema.getSystemId());
        }
        return this.transform(xml, validator, null);
    }

    public StreamSource getValidationStylesheet(StreamSource schema, StreamSource engine) throws TransformerConfigurationException, TransformerException {
        return new StreamSource(new StringReader(this.transform(schema, engine, this.params)));
    }

    private String transform(StreamSource target, StreamSource stylesheet, Map parameters) throws TransformerConfigurationException, TransformerException {
        Transformer transformer = this.theFactory.newTransformer(stylesheet);
        if (parameters != null) {
            Iterator iter = parameters.keySet().iterator();
            while (iter.hasNext()) {
                String param = (String)iter.next();
                transformer.setParameter(param, (String)this.params.get(param));
            }
        }
        StringWriter result = new StringWriter();
        transformer.transform(target, new StreamResult(result));
        return result.toString();
    }

    public void setBaseXML(boolean useXML) {
        this.baseIsXML = useXML;
    }

    static String system_To_URL(String path) {
        if (path.startsWith("file:")) {
            return path;
        }
        try {
            URL url = new File(path).toURL();
            return url.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public StreamSource getEngineStylesheet() {
        return this.engineStylesheet;
    }

    public void setEngineStylesheet(String enginePath) {
        if (enginePath != null) {
            this.engineStylesheet = new StreamSource(SchtrnValidator.system_To_URL(enginePath));
        }
    }
}

