/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisAtomizingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;

public final class Atomizer
extends UnaryExpression {
    private boolean untyped;
    private boolean singleValued;
    private Configuration config;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public Atomizer(Expression sequence, Configuration config) {
        super(sequence);
        this.config = config;
        if (config != null) {
            this.untyped = config.areAllNodesUntyped();
            this.computeSingleValued(config.getTypeHierarchy());
        }
        sequence.setFlattened(true);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.config = visitor.getConfiguration();
        this.untyped = this.config.areAllNodesUntyped();
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal) {
            Item i;
            Value val = ((Literal)this.operand).getValue();
            if (val instanceof AtomicValue) {
                return this.operand;
            }
            SequenceIterator iter = val.iterate();
            do {
                if ((i = iter.next()) != null) continue;
                return this.operand;
            } while (!(i instanceof NodeInfo));
            return this;
        }
        if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
            return ((ValueOf)this.operand).convertToStringJoin(visitor.getStaticContext());
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.computeSingleValued(th);
        visitor.resetStaticProperties();
        if (th.isSubType(this.operand.getItemType(th), BuiltInAtomicType.ANY_ATOMIC)) {
            return this.operand;
        }
        this.operand.setFlattened(true);
        return this;
    }

    private void computeSingleValued(TypeHierarchy th) {
        SchemaType st;
        ItemType nodeType;
        this.singleValued = this.untyped;
        if (!this.singleValued && (nodeType = this.operand.getItemType(th)) instanceof NodeTest && ((st = ((NodeTest)nodeType).getContentType()) == AnyType.getInstance() || st.isAtomicType())) {
            this.singleValued = true;
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.operand.getItemType(th), BuiltInAtomicType.ANY_ATOMIC)) {
                return this.operand;
            }
            if (this.operand instanceof ValueOf && (((ValueOf)this.operand).getOptions() & 1) == 0) {
                return ((ValueOf)this.operand).convertToStringJoin(visitor.getStaticContext());
            }
        }
        return exp;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new Atomizer(this.getBaseExpression().copy(), this.config);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        return Atomizer.getAtomizingIterator(base);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item i = this.operand.evaluateItem(context);
        if (i == null) {
            return null;
        }
        if (i instanceof NodeInfo) {
            SequenceIterator it = i.getTypedValue();
            return it.next();
        }
        return i;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return Atomizer.getAtomizedItemType(this.operand, this.untyped, th);
    }

    public static ItemType getAtomizedItemType(Expression operand, boolean alwaysUntyped, TypeHierarchy th) {
        ItemType in = operand.getItemType(th);
        if (in.isAtomicType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            if (in instanceof EmptySequenceTest) {
                return in;
            }
            int kinds = ((NodeTest)in).getNodeKindMask();
            if (alwaysUntyped) {
                if ((kinds | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((kinds | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((kinds | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        SchemaType schemaType;
        if (this.untyped || this.singleValued) {
            return this.operand.getCardinality();
        }
        if (Cardinality.allowsMany(this.operand.getCardinality())) {
            return 57344;
        }
        if (this.config == null) {
            return 57344;
        }
        ItemType in = this.operand.getItemType(this.config.getTypeHierarchy());
        if (in.isAtomicType()) {
            return this.operand.getCardinality();
        }
        if (in instanceof NodeTest && (schemaType = ((NodeTest)in).getContentType()).isAtomicType()) {
            return this.operand.getCardinality();
        }
        return 57344;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = this.operand.addToPathMap(pathMap, pathMapNodeSet);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    public static SequenceIterator getAtomizingIterator(SequenceIterator base) {
        if (base instanceof AxisIterator) {
            return new AxisAtomizingIterator((AxisIterator)base);
        }
        return new MappingIterator(base, AtomizingFunction.getInstance());
    }

    public String displayExpressionName() {
        return "atomize";
    }

    public static class AtomizingFunction
    implements MappingFunction {
        private static final AtomizingFunction theInstance = new AtomizingFunction();

        private AtomizingFunction() {
        }

        public static AtomizingFunction getInstance() {
            return theInstance;
        }

        public SequenceIterator map(Item item) throws XPathException {
            if (item instanceof NodeInfo) {
                return item.getTypedValue();
            }
            return SingletonIterator.makeIterator(item);
        }
    }
}

