/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.util;

import com.adobe.util.Log;
import com.adobe.util.WeakRef;
import java.lang.reflect.Array;

public class MemUtil {
    public static byte[] allocByte(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(n);
            byArray = new byte[n];
        }
        return byArray;
    }

    public static char[] allocChar(int n) {
        char[] cArray = null;
        try {
            cArray = new char[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(2 * n);
            cArray = new char[n];
        }
        return cArray;
    }

    public static double[] allocDouble(int n) {
        double[] dArray = null;
        try {
            dArray = new double[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(8 * n);
            dArray = new double[n];
        }
        return dArray;
    }

    public static float[] allocFloat(int n) {
        float[] fArray = null;
        try {
            fArray = new float[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(4 * n);
            fArray = new float[n];
        }
        return fArray;
    }

    public static int[] allocInt(int n) {
        int[] nArray = null;
        try {
            nArray = new int[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(4 * n);
            nArray = new int[n];
        }
        return nArray;
    }

    public static long[] allocLong(int n) {
        long[] lArray = null;
        try {
            lArray = new long[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(8 * n);
            lArray = new long[n];
        }
        return lArray;
    }

    public static Object[] allocObject(int n) {
        Object[] objectArray = null;
        try {
            objectArray = new Object[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(4 * n);
            objectArray = new Object[n];
        }
        return objectArray;
    }

    public static short[] allocShort(int n) {
        short[] sArray = null;
        try {
            sArray = new short[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(2 * n);
            sArray = new short[n];
        }
        return sArray;
    }

    public static StringBuffer allocStringBuffer(int n) {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemUtil.collectMemory(2 * n);
            stringBuffer = new StringBuffer(n);
        }
        return stringBuffer;
    }

    public static void arraySet(Object object, int n, int n2, Object object2) {
        Array.set(object, n, object2);
        int n3 = 1;
        while (n3 < n2) {
            int n4 = Math.min(n3 + n3, n2);
            System.arraycopy(object, n, object, n + n3, n4 - n3);
            n3 = n4;
        }
    }

    public static void arraySet(Object object, Object object2) {
        MemUtil.arraySet(object, 0, Array.getLength(object), object2);
    }

    public static void collectMemory() {
        MemUtil.collectMemory(0);
    }

    public static void collectMemory(int n) {
        Runtime runtime = Runtime.getRuntime();
        Log.clog("Need " + n + " bytes. Free memory: " + runtime.freeMemory());
        WeakRef.gc();
        System.gc();
        Log.clog(" -> " + runtime.freeMemory() + "\n");
    }

    public static StringBuffer ensureStringBufferCapacity(StringBuffer stringBuffer, int n) {
        if (stringBuffer.capacity() < n) {
            int n2 = Math.max(n + 2, stringBuffer.capacity() + 1024);
            StringBuffer stringBuffer2 = null;
            try {
                stringBuffer2 = new StringBuffer(n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                MemUtil.collectMemory(2 * n2);
                stringBuffer2 = new StringBuffer(n2);
            }
            int n3 = stringBuffer.length();
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer2.append(stringBuffer.charAt(n4));
                ++n4;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer;
    }
}

