/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.vtypes;

import com.adobe.pe.notify.ComputeSettableException;
import com.adobe.pe.notify.DependencyInspectorFriend;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VChange;
import com.adobe.pe.notify.VValue;
import com.adobe.pe.notify.WriteLockException;

public class VFloat
extends VValue
implements DependencyInspectorFriend {
    float value;

    protected VFloat() {
    }

    public VFloat(float f) {
        this.value = f;
        this.initializeSettable();
    }

    protected final void compute(Requester requester) throws Exception {
        this.value = this.computeFloat(requester);
    }

    protected float computeFloat(Requester requester) throws Exception {
        throw new ComputeSettableException();
    }

    public float floatValue(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.value;
    }

    public String getInfo(int n) {
        if (n == 3) {
            return Float.toString(this.value);
        }
        return super.getInfo(n);
    }

    public void setFloatValue(Transaction transaction, float f) throws WriteLockException {
        transaction.registerChange(new VFloatChange(f, this));
    }

    class VFloatChange
    extends VChange {
        private float newValue;
        private float oldValue;

        VFloatChange(float f, VFloat vFloat2) {
            super(vFloat2);
            this.oldValue = vFloat2.value;
            this.newValue = f;
        }

        public void apply() {
            VFloat.this.value = this.newValue;
        }

        public boolean isNoOp() {
            return this.oldValue == this.newValue;
        }

        public void repeal() {
            VFloat.this.value = this.oldValue;
        }
    }
}

