/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.vtypes;

import com.adobe.pe.notify.ComputeSettableException;
import com.adobe.pe.notify.DependencyInspectorFriend;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.VChange;
import com.adobe.pe.notify.VValue;
import com.adobe.pe.notify.WriteLockException;

public class VDouble
extends VValue
implements DependencyInspectorFriend {
    double value;

    protected VDouble() {
    }

    public VDouble(double d) {
        this.value = d;
        this.initializeSettable();
    }

    protected final void compute(Requester requester) throws Exception {
        this.value = this.computeDouble(requester);
    }

    protected double computeDouble(Requester requester) throws Exception {
        throw new ComputeSettableException();
    }

    public double doubleValue(Requester requester) throws Exception {
        this.handleRequest(requester);
        return this.value;
    }

    public String getInfo(int n) {
        if (n == 3) {
            return Double.toString(this.value);
        }
        return super.getInfo(n);
    }

    public void setDoubleValue(Transaction transaction, double d) throws WriteLockException {
        transaction.registerChange(new VDoubleChange(d, this));
    }

    class VDoubleChange
    extends VChange {
        private double newValue;
        private double oldValue;

        VDoubleChange(double d, VDouble vDouble2) {
            super(vDouble2);
            this.oldValue = vDouble2.value;
            this.newValue = d;
        }

        public void apply() {
            VDouble.this.value = this.newValue;
        }

        public boolean isNoOp() {
            return this.oldValue == this.newValue;
        }

        public void repeal() {
            VDouble.this.value = this.oldValue;
        }
    }
}

