/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.notify;

import com.adobe.pe.notify.ChangeFinishedTransactionException;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.VChange;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VValue;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.util.Assert;
import java.util.Vector;

public class Transaction
extends Requester {
    private WriteLockException writeLockException = null;
    private Thread executionThread = null;
    private Vector alreadyReportedErrors = null;
    private Vector pendingChanges = new Vector();
    private boolean inRegisterChange = false;
    private boolean walkingStrobeList = false;
    private Vector unnotifiedStrobes = new Vector();
    private Vector notifyingStrobes = new Vector();
    private Vector notifiedStrobes = new Vector();
    int writeCycle = 0;
    private TransactionExecutionContext exContext;
    private Vector changes = new Vector();
    private boolean doneChanging = false;
    private boolean doneSynchronizing = false;

    public void abort(Throwable throwable) {
        if (!this.doneChanging) {
            block3: {
                try {
                    this.repealChanges();
                    if (this.exContext == null) break block3;
                    this.exContext.reportError(this, throwable, this.silenced(throwable));
                    this.exContext.abortTransaction(this);
                }
                catch (Throwable throwable2) {
                    Object var3_3 = null;
                    this.finish();
                    throw throwable2;
                }
            }
            Object var3_2 = null;
            this.finish();
        }
    }

    public void begin(TransactionExecutionContext transactionExecutionContext) {
        this.exContext = transactionExecutionContext;
        if (transactionExecutionContext != null) {
            transactionExecutionContext.beginTransaction(this);
        }
        this.executionThread = Thread.currentThread();
    }

    public void errorAlreadyReported(Throwable throwable) {
        if (this.alreadyReportedErrors == null) {
            this.alreadyReportedErrors = new Vector();
        }
        this.alreadyReportedErrors.addElement(throwable);
    }

    public void finish() {
        if (!this.doneChanging) {
            this.setDoneChanging();
            this.releaseRequestees();
            this.notifyStrobes();
            if (this.exContext != null) {
                this.exContext.endTransaction(this);
            }
        }
    }

    public TransactionExecutionContext getExecutionContext() {
        return this.exContext;
    }

    Transaction getOwnerTransaction() {
        return this;
    }

    int getOwnerTransactionWriteCycle() {
        return this.writeCycle;
    }

    WriteLockException getWriteLockException() {
        return new WriteLockException(this);
    }

    public boolean isDoneChanging() {
        return this.doneChanging;
    }

    private void mergeChange(VChange vChange) {
        int n = this.changes.size() - 1;
        while (n >= 0) {
            VChange vChange2 = (VChange)this.changes.elementAt(n);
            if (vChange2.getChanger() == vChange.getChanger()) {
                VChange vChange3 = vChange.mergeChange(vChange2);
                if (vChange3 == null) break;
                this.changes.setElementAt(vChange3, n);
                return;
            }
            --n;
        }
        this.changes.addElement(vChange);
        Assert.notFalse(this.changes.size() < 50);
    }

    void notifyStrobe(VStrobe vStrobe) {
        this.notifyingStrobes.addElement(vStrobe);
        try {
            vStrobe.notify(this);
        }
        catch (WriteLockException writeLockException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyStrobes() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (this.walkingStrobeList) {
                return;
            }
            this.walkingStrobeList = true;
        }
        try {
            while (true) {
                VStrobe vStrobe;
                block12: {
                    Transaction transaction2 = this;
                    synchronized (transaction2) {
                        block11: {
                            if (this.unnotifiedStrobes.size() == 0) {
                                Object var5_8 = null;
                                break block11;
                            }
                            vStrobe = (VStrobe)this.unnotifiedStrobes.firstElement();
                            this.unnotifiedStrobes.removeElement(vStrobe);
                            break block12;
                        }
                    }
                    Object var2_4 = null;
                    this.walkingStrobeList = false;
                    return;
                }
                this.notifyStrobe(vStrobe);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this.walkingStrobeList = false;
            throw throwable;
        }
    }

    public void registerChange(VChange vChange) throws WriteLockException, ChangeFinishedTransactionException {
        if (this.isDoneChanging()) {
            throw new ChangeFinishedTransactionException(this);
        }
        if (vChange.isNoOp()) {
            return;
        }
        this.pendingChanges.addElement(vChange);
        if (this.inRegisterChange) {
            return;
        }
        this.inRegisterChange = true;
        try {
            while (this.pendingChanges.size() != 0) {
                VChange vChange2 = (VChange)this.pendingChanges.firstElement();
                this.pendingChanges.removeElementAt(0);
                VValue vValue = vChange2.getChanger();
                vValue.prepareWrite(this);
                vChange2.apply();
                this.mergeChange(vChange2);
            }
        }
        finally {
            Object var3_4 = null;
            this.inRegisterChange = false;
        }
    }

    void registerStrobe(VStrobe vStrobe) {
        Vector vector = this.unnotifiedStrobes;
        synchronized (vector) {
            if (!this.unnotifiedStrobes.contains(vStrobe)) {
                this.unnotifiedStrobes.addElement(vStrobe);
            }
        }
        if (this.doneChanging) {
            this.notifyStrobes();
        }
    }

    private void repealChanges() {
        VValue vValue;
        int n = this.changes.size() - 1;
        while (n >= 0) {
            VChange vChange = (VChange)this.changes.elementAt(n);
            vValue = vChange.getChanger();
            try {
                vValue.prepareWrite(this);
            }
            catch (WriteLockException writeLockException) {
                Assert.notFalse(false);
            }
            vChange.repeal();
            --n;
        }
        int n2 = 0;
        while (n2 < this.notifiedStrobes.size()) {
            vValue = (VStrobe)this.notifiedStrobes.elementAt(n2);
            if (!this.unnotifiedStrobes.contains(vValue)) {
                this.unnotifiedStrobes.addElement(vValue);
            }
            ++n2;
        }
        this.notifiedStrobes.setSize(0);
    }

    public void requestInterrupt() {
    }

    private synchronized void setDoneChanging() {
        this.doneChanging = true;
        this.notifyAll();
        this.changes = null;
    }

    private boolean silenced(Throwable throwable) {
        return this.alreadyReportedErrors != null && this.alreadyReportedErrors.contains(throwable);
    }

    synchronized void strobeFinished(VStrobe vStrobe) {
        Assert.notFalse(this.notifyingStrobes.contains(vStrobe));
        Assert.notFalse(this.notifiedStrobes.contains(vStrobe) ^ true);
        this.notifyingStrobes.removeElement(vStrobe);
        this.notifiedStrobes.addElement(vStrobe);
        if (this.notifyingStrobes.size() == 0 && this.unnotifiedStrobes.size() == 0) {
            this.doneSynchronizing = true;
        }
    }
}

