/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.VDimension;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VInt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class VScrollbar
extends Scrollbar
implements AdjustmentListener,
ComponentListener,
VObserver,
StrobeContainer {
    private boolean horizontal;
    private VStrobe strobe;
    private ScrollerLogic logic;
    private VInt vInValue;
    private VInt vOutValue;
    private VDimension vAperture;
    private VInt vContainee;
    private int realVal;
    private int realVis;
    private int realMin;
    private int realMax;

    public VScrollbar(ScrollerLogic scrollerLogic, int n) {
        super(n);
        this.logic = scrollerLogic;
        this.horizontal = n == 0;
        this.vInValue = this.horizontal ? scrollerLogic.vHInValue : scrollerLogic.vVInValue;
        this.vOutValue = this.horizontal ? scrollerLogic.vHOutValue : scrollerLogic.vVOutValue;
        this.vAperture = scrollerLogic.vAperture;
        this.vContainee = this.horizontal ? scrollerLogic.vContaineeWidth : scrollerLogic.vContaineeHeight;
        this.setVisible(false);
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.setUnitIncrement(15);
        this.addComponentListener(this);
        this.addAdjustmentListener(this);
        this.strobe = new VStrobe(this);
        this.setBackground(SystemColor.scrollbar);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = Math.min(this.realMax - this.realVis, adjustmentEvent.getValue());
        n = Math.max(this.realMin, n);
        final int n2 = Math.min(this.realMax - this.realVis, this.getValue());
        if (n2 != this.getValue()) {
            this.setValue(n2);
        }
        if (n != n2) {
            return;
        }
        Transactor transactor = new Transactor(){

            public void buildChanges(Transaction transaction) throws Exception {
                VScrollbar.this.vInValue.setIntValue(transaction, n2);
            }
        };
        try {
            transactor.commit();
        }
        catch (Exception exception) {
            Log.clog("VScrollbar.adjustmentValueChanged: " + exception.toString());
        }
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            try {
                int n;
                int n2 = n = this.horizontal ? this.logic.getHScrollMax(requester) : this.logic.getVScrollMax(requester);
                if (n <= 0) {
                    this.setValues(0, 0, 0, 0);
                    Object var3_4 = null;
                    this.invalidate();
                    this.validate();
                    return;
                }
                int n3 = this.vOutValue.intValue(requester);
                Dimension dimension = this.vAperture.dimensionValue(requester);
                int n4 = this.horizontal ? dimension.width : dimension.height;
                this.realVal = n3;
                this.realVis = n4;
                this.realMin = 0;
                this.realMax = n + n4;
                this.setBlockIncrement(Math.max(2, n4 - 12));
                this.setFromRealValues();
            }
            catch (WriteLockException writeLockException) {
                throw writeLockException;
            }
            catch (Exception exception) {
                this.setValues(0, 0, 0, 0);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.invalidate();
            this.validate();
            throw throwable;
        }
        Object var3_5 = null;
        this.invalidate();
        this.validate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setFromRealValues();
    }

    public Dimension getSize() {
        Dimension dimension = super.getSize();
        if (dimension.width == 0) {
            dimension.width = 15;
        }
        if (dimension.height == 0) {
            dimension.height = 15;
        }
        return dimension;
    }

    public void setBlockIncrement(int n) {
        if (n < 1) {
            n = 1;
        }
        super.setBlockIncrement(n);
    }

    private void setFromRealValues() {
        this.setValues(this.realVal, this.realVis, this.realMin, this.realMax);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

