/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.ScrollerLogic;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.Transactor;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VInt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class VScrollPane
extends ScrollPane
implements VObserver,
AdjustmentListener,
ComponentListener,
StrobeContainer {
    private boolean alreadyChanging = false;
    private VSynchronizer scrollPaneSynchronizer = new VSynchronizer(true);
    private ScrollerLogic logic;
    private Component containee;
    private VStrobe strobe;

    public VScrollPane(ScrollerLogic scrollerLogic) {
        this(scrollerLogic, null);
    }

    public VScrollPane(ScrollerLogic scrollerLogic, Component component) {
        super(0);
        this.logic = scrollerLogic;
        this.addComponentListener(this);
        this.getHAdjustable().setUnitIncrement(15);
        this.getVAdjustable().setUnitIncrement(15);
        this.getHAdjustable().addAdjustmentListener(this);
        this.getVAdjustable().addAdjustmentListener(this);
        this.strobe = new VStrobe(this);
        if (component != null) {
            this.setContainee(component);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.alreadyChanging) {
            return;
        }
        final VInt vInt = adjustmentEvent.getSource() == this.getHAdjustable() ? this.logic.vHInValue : this.logic.vVInValue;
        final int n = adjustmentEvent.getValue();
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                vInt.setIntValue(transaction, n);
            }
        };
        this.scrollPaneSynchronizer.setTransactor(null, transactor);
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            block12: {
                try {
                    int n;
                    int n2 = this.logic.vHOutValue == null ? 0 : this.logic.vHOutValue.intValue(requester);
                    int n3 = this.logic.vVOutValue == null ? 0 : this.logic.vVOutValue.intValue(requester);
                    boolean bl = this.logic.vContaineeWidth != null;
                    boolean bl2 = this.logic.vContaineeHeight != null;
                    Dimension dimension = this.logic.vInterior.dimensionValue(requester);
                    int n4 = dimension.width;
                    int n5 = dimension.height;
                    int n6 = bl ? this.logic.vContaineeWidth.intValue(requester) : n4;
                    int n7 = n = bl2 ? this.logic.vContaineeHeight.intValue(requester) : n5;
                    if (bl && !bl2) {
                        if (n6 > n4) {
                            n -= 15;
                        }
                    } else if (bl2 && !bl && n > n5) {
                        n6 -= 15;
                    }
                    if (this.containee == null) break block12;
                    this.containee.setSize(n6, n);
                    this.alreadyChanging = true;
                    try {
                        this.setScrollPosition(n2, n3);
                    }
                    finally {
                        Object var14_13 = null;
                        this.alreadyChanging = false;
                    }
                }
                catch (WriteLockException writeLockException) {
                    throw writeLockException;
                }
                catch (Exception exception) {
                    Log.clog("VScrollPane.change: " + exception.toString());
                }
            }
            Object var3_16 = null;
            this.invalidate();
            this.validate();
        }
        catch (Throwable throwable) {
            Object var3_17 = null;
            this.invalidate();
            this.validate();
            throw throwable;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Transactor transactor = new Transactor(){

            protected final void buildChanges(Transaction transaction) throws Exception {
                ((VScrollPane)VScrollPane.this).logic.vScrollPaneInsets.setInsetsValue(transaction, VScrollPane.this.getInsets());
                ((VScrollPane)VScrollPane.this).logic.vScrollPaneSize.setDimensionValue(transaction, VScrollPane.this.getSize());
            }
        };
        try {
            transactor.commit();
        }
        catch (Exception exception) {
            Log.clog("VScrollPane.componentResized: " + exception.toString());
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setContainee(Component component) {
        this.containee = component;
        this.add(component);
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

