/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pe.awt;

import com.adobe.acrobat.util.Log;
import com.adobe.pe.awt.StrobeContainer;
import com.adobe.pe.awt.UIVerb;
import com.adobe.pe.notify.Requester;
import com.adobe.pe.notify.Transaction;
import com.adobe.pe.notify.TransactionExecutionContext;
import com.adobe.pe.notify.VObserver;
import com.adobe.pe.notify.VStrobe;
import com.adobe.pe.notify.VSynchronizer;
import com.adobe.pe.notify.WriteLockException;
import com.adobe.pe.vtypes.VString;
import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class VButton
extends Button
implements ActionListener,
VObserver,
StrobeContainer {
    private boolean selfCancel = false;
    private TransactionExecutionContext exContext;
    private UIVerb uiVerb;
    private VString vTitle;
    private VSynchronizer vSynchronizer;
    private VStrobe strobe;

    public VButton(TransactionExecutionContext transactionExecutionContext, UIVerb uIVerb, VString vString) {
        this(transactionExecutionContext, uIVerb, vString, new VSynchronizer(), false);
    }

    public VButton(TransactionExecutionContext transactionExecutionContext, UIVerb uIVerb, VString vString, VSynchronizer vSynchronizer, boolean bl) {
        this.exContext = transactionExecutionContext;
        this.uiVerb = uIVerb;
        this.vTitle = vString;
        this.vSynchronizer = vSynchronizer;
        this.selfCancel = bl;
        this.addActionListener(this);
        this.strobe = new VStrobe(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.perform();
    }

    public void change(Requester requester) throws WriteLockException {
        try {
            String string = this.vTitle.stringValue(requester);
            this.setLabel(string);
            boolean bl = this.uiVerb.enabled(requester);
            this.setEnabled(bl);
        }
        catch (WriteLockException writeLockException) {
            this.setEnabled(false);
            this.setLabel("");
            throw writeLockException;
        }
        catch (Exception exception) {
            this.setEnabled(false);
            this.setLabel("");
            Log.clog("VButton.change: " + exception.toString());
        }
    }

    public void perform() {
        if (this.selfCancel && this.vSynchronizer.cancel()) {
            return;
        }
        this.vSynchronizer.setTransactor(this.exContext, this.uiVerb.getTransactor());
    }

    public void setStrobeActive(Transaction transaction, boolean bl) {
        this.strobe.setActive(transaction, bl);
    }
}

