/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.EncodingVector;
import com.adobe.acrobat.util.FontCache;
import com.adobe.util.MemUtil;
import com.adobe.util.WeakRef;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeTransliterater {
    public static String Japan1 = "Japan1";
    public static String Korea1 = "Korea1";
    public static String GB1 = "GB1";
    public static String CNS1 = "CNS1";
    public static String Identity = "Identity";
    private WeakRef translationTable = new WeakRef();
    private static WeakRef simpleTable = new WeakRef();
    private String FontSubdirectory_K = "Fonts";
    private String type;
    private boolean isMode0;

    UnicodeTransliterater(String string, boolean bl) throws IOException {
        this.type = string;
        this.isMode0 = bl;
        this.translationTable.purge();
    }

    synchronized void compute() throws IOException {
        if (this.type.equals(Japan1) || this.type.equals(Korea1) || this.type.equals(GB1) || this.type.equals(CNS1)) {
            String string;
            String string2 = string = this.isMode0 ? "-H.lin" : "-V.lin";
            String string3 = this.type.equals(Japan1) ? "UniJIS-UCS2" + string : (this.type.equals(Korea1) ? "UniKS-UCS2" + string : (this.type.equals(GB1) ? "UniGB-UCS2" + string : "UniCNS-UCS2" + string));
            InputStream inputStream = FontCache.getTheFontCache().findFont(string3);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            char[] cArray = MemUtil.allocChar(n);
            int n2 = 0;
            while (n2 < n) {
                cArray[n2] = dataInputStream.readChar();
                ++n2;
            }
            this.translationTable.set(cArray);
        } else {
            char[] cArray;
            char[] cArray2 = (char[])simpleTable.get();
            if (cArray2 == null) {
                int n = this.maxRemapCode() + 1;
                cArray = MemUtil.allocChar(n);
                int n3 = 0;
                while (n3 < n) {
                    cArray[n3] = (char)n3;
                    ++n3;
                }
                this.remapOther(cArray);
                simpleTable.set(cArray);
                simpleTable.unlock();
            } else {
                cArray = cArray2;
            }
            simpleTable.unlock();
            this.translationTable.set(cArray);
        }
        this.translationTable.unlock();
    }

    int maxRemapCode() {
        return this.remapOther(null);
    }

    int remapCode(char[] cArray, char c, String string) {
        int n = EncodingVector.hostGlyphs.getInt(string);
        if (cArray != null) {
            cArray[n] = c;
        }
        return n;
    }

    int remapOther(char[] cArray) {
        int n = this.remapCode(cArray, '0', "zerooldstyle");
        n = Math.max(n, this.remapCode(cArray, '1', "oneoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '2', "twooldstyle"));
        n = Math.max(n, this.remapCode(cArray, '3', "threeoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '4', "fouroldstyle"));
        n = Math.max(n, this.remapCode(cArray, '5', "fiveoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '6', "sixoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '7', "sevenoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '8', "eightoldstyle"));
        n = Math.max(n, this.remapCode(cArray, '9', "nineoldstyle"));
        n = Math.max(n, this.remapCode(cArray, 'r', "rsuperior"));
        n = Math.max(n, this.remapCode(cArray, 's', "ssuperior"));
        n = Math.max(n, this.remapCode(cArray, 't', "tsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'A', "Asmall"));
        n = Math.max(n, this.remapCode(cArray, 'B', "Bsmall"));
        n = Math.max(n, this.remapCode(cArray, 'C', "Csmall"));
        n = Math.max(n, this.remapCode(cArray, 'D', "Dsmall"));
        n = Math.max(n, this.remapCode(cArray, 'E', "Esmall"));
        n = Math.max(n, this.remapCode(cArray, 'F', "Fsmall"));
        n = Math.max(n, this.remapCode(cArray, 'G', "Gsmall"));
        n = Math.max(n, this.remapCode(cArray, 'H', "Hsmall"));
        n = Math.max(n, this.remapCode(cArray, 'I', "Ismall"));
        n = Math.max(n, this.remapCode(cArray, 'J', "Jsmall"));
        n = Math.max(n, this.remapCode(cArray, 'K', "Ksmall"));
        n = Math.max(n, this.remapCode(cArray, 'L', "Lsmall"));
        n = Math.max(n, this.remapCode(cArray, 'M', "Msmall"));
        n = Math.max(n, this.remapCode(cArray, 'N', "Nsmall"));
        n = Math.max(n, this.remapCode(cArray, 'O', "Osmall"));
        n = Math.max(n, this.remapCode(cArray, 'P', "Psmall"));
        n = Math.max(n, this.remapCode(cArray, 'Q', "Qsmall"));
        n = Math.max(n, this.remapCode(cArray, 'R', "Rsmall"));
        n = Math.max(n, this.remapCode(cArray, 'S', "Ssmall"));
        n = Math.max(n, this.remapCode(cArray, 'T', "Tsmall"));
        n = Math.max(n, this.remapCode(cArray, 'U', "Usmall"));
        n = Math.max(n, this.remapCode(cArray, 'V', "Vsmall"));
        n = Math.max(n, this.remapCode(cArray, 'W', "Wsmall"));
        n = Math.max(n, this.remapCode(cArray, 'X', "Xsmall"));
        n = Math.max(n, this.remapCode(cArray, 'Y', "Ysmall"));
        n = Math.max(n, this.remapCode(cArray, 'Z', "Zsmall"));
        n = Math.max(n, this.remapCode(cArray, 'a', "asuperior"));
        n = Math.max(n, this.remapCode(cArray, '8', "eightsuperior"));
        n = Math.max(n, this.remapCode(cArray, '4', "fourinferior"));
        n = Math.max(n, this.remapCode(cArray, '3', "threeinferior"));
        n = Math.max(n, this.remapCode(cArray, '6', "sixinferior"));
        n = Math.max(n, this.remapCode(cArray, '8', "eightinferior"));
        n = Math.max(n, this.remapCode(cArray, '7', "seveninferior"));
        n = Math.max(n, this.remapCode(cArray, '2', "twoinferior"));
        n = Math.max(n, this.remapCode(cArray, 'o', "osuperior"));
        n = Math.max(n, this.remapCode(cArray, '5', "fiveinferior"));
        n = Math.max(n, this.remapCode(cArray, '9', "nineinferior"));
        n = Math.max(n, this.remapCode(cArray, '0', "zeroinferior"));
        n = Math.max(n, this.remapCode(cArray, '1', "oneinferior"));
        n = Math.max(n, this.remapCode(cArray, '0', "zerosuperior"));
        n = Math.max(n, this.remapCode(cArray, '3', "threesuperior"));
        n = Math.max(n, this.remapCode(cArray, '4', "foursuperior"));
        n = Math.max(n, this.remapCode(cArray, '5', "fivesuperior"));
        n = Math.max(n, this.remapCode(cArray, '6', "sixsuperior"));
        n = Math.max(n, this.remapCode(cArray, '7', "sevensuperior"));
        n = Math.max(n, this.remapCode(cArray, '9', "ninesuperior"));
        n = Math.max(n, this.remapCode(cArray, '0', "zerosuperior"));
        n = Math.max(n, this.remapCode(cArray, 'r', "esuperior"));
        n = Math.max(n, this.remapCode(cArray, 't', "rsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'y', "tsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'i', "isuperior"));
        n = Math.max(n, this.remapCode(cArray, 's', "ssuperior"));
        n = Math.max(n, this.remapCode(cArray, 'd', "dsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'l', "lsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'b', "bsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'n', "nsuperior"));
        n = Math.max(n, this.remapCode(cArray, 'm', "msuperior"));
        n = Math.max(n, this.remapCode(cArray, '*', "asteriskmath"));
        n = Math.max(n, this.remapCode(cArray, '\u00ae', "registerserif"));
        n = Math.max(n, this.remapCode(cArray, '\u00a9', "copyrightserif"));
        n = Math.max(n, this.remapCode(cArray, '\u2122', "trademarkserif"));
        n = Math.max(n, this.remapCode(cArray, '\u00ae', "registersans"));
        n = Math.max(n, this.remapCode(cArray, '\u00a9', "copyrightsans"));
        n = Math.max(n, this.remapCode(cArray, '\u2122', "trademarksans"));
        return n;
    }

    public StringBuffer transliterateString(String string) throws IOException {
        StringBuffer stringBuffer = MemUtil.allocStringBuffer(string.length());
        stringBuffer.append(string);
        char[] cArray = (char[])this.translationTable.get();
        if (!this.translationTable.isValid()) {
            this.compute();
            cArray = (char[])this.translationTable.get();
            this.translationTable.unlock();
        }
        this.translationTable.unlock();
        if (cArray != null) {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                char c = stringBuffer.charAt(n2);
                if (c < n) {
                    stringBuffer.setCharAt(n2, cArray[c]);
                }
                ++n2;
            }
        }
        return stringBuffer;
    }
}

