/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import java.awt.Color;

public class SidecarColor
extends Color {
    int value;

    public SidecarColor(float f, float f2, float f3) {
        super(f, f2, f3);
        this.value = super.getRGB();
    }

    public SidecarColor(float f, float f2, float f3, float f4) {
        super(f2, f3, f4);
        this.value = ((int)(f * 255.0f) << 24) + (super.getRGB() & 0xFFFFFF);
        SidecarColor.testAlphaValueRange(f);
    }

    public SidecarColor(int n) {
        super(n);
        this.value = n;
    }

    public SidecarColor(int n, int n2, int n3) {
        super(n, n2, n3);
        this.value = super.getRGB();
    }

    public SidecarColor(int n, int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.value = (n << 24) + (super.getRGB() & 0xFFFFFF);
        SidecarColor.testAlphaValueRange(n);
    }

    public Color brighter() {
        int n = this.value & 0xFF000000;
        return new SidecarColor(n + (super.brighter().getRGB() & 0xFFFFFF));
    }

    public Color darker() {
        int n = this.value & 0xFF000000;
        return new SidecarColor(n + (super.darker().getRGB() & 0xFFFFFF));
    }

    public int getAlpha() {
        return this.value >>> 24;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int hashCode() {
        return this.value;
    }

    private static void testAlphaValueRange(float f) {
        if ((double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("Color parameter outside of expected range: Alpha");
        }
    }

    private static void testAlphaValueRange(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Color parameter outside of expected range: Alpha");
        }
    }
}

