/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.sidecar;

import com.adobe.acrobat.sidecar.AffineTransform;
import com.adobe.acrobat.sidecar.FloatRect;
import com.adobe.util.MemUtil;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PolygonADV
implements Cloneable {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    private Polygon poly = null;
    private FloatRect boundingBox = null;

    public PolygonADV() {
        this(0);
    }

    public PolygonADV(int n) {
        if (n <= 0) {
            n = 128;
        }
        this.xpoints = MemUtil.allocDouble(n);
        this.ypoints = MemUtil.allocDouble(n);
        this.npoints = 0;
    }

    public PolygonADV(FloatRect floatRect) {
        this(5);
        this.npoints = 5;
        this.xpoints[0] = floatRect.getxMin();
        this.ypoints[0] = floatRect.getyMin();
        this.xpoints[1] = floatRect.getxMax();
        this.ypoints[1] = this.ypoints[0];
        this.xpoints[2] = this.xpoints[1];
        this.ypoints[2] = floatRect.getyMax();
        this.xpoints[3] = this.xpoints[0];
        this.ypoints[3] = this.ypoints[2];
        this.xpoints[4] = this.xpoints[0];
        this.ypoints[4] = this.ypoints[0];
    }

    public PolygonADV(Polygon polygon) {
        this.npoints = Math.min(polygon.npoints, Math.min(polygon.xpoints.length, polygon.ypoints.length));
        this.xpoints = MemUtil.allocDouble(this.npoints);
        this.ypoints = MemUtil.allocDouble(this.npoints);
        int n = 0;
        while (n < this.npoints) {
            this.xpoints[n] = polygon.xpoints[n];
            this.ypoints[n] = polygon.ypoints[n];
            ++n;
        }
    }

    public PolygonADV(Rectangle rectangle) {
        this(5);
        this.npoints = 5;
        this.xpoints[0] = rectangle.x;
        this.ypoints[0] = rectangle.y;
        this.xpoints[1] = rectangle.x + rectangle.width;
        this.ypoints[1] = rectangle.y;
        this.xpoints[2] = rectangle.x + rectangle.width;
        this.ypoints[2] = rectangle.y + rectangle.height;
        this.xpoints[3] = rectangle.x;
        this.ypoints[3] = rectangle.y + rectangle.height;
        this.xpoints[4] = this.xpoints[0];
        this.ypoints[4] = this.ypoints[0];
    }

    public PolygonADV(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, Math.min(dArray.length, dArray2.length));
    }

    public PolygonADV(double[] dArray, double[] dArray2, int n) {
        this.npoints = Math.min(n, Math.min(dArray.length, dArray2.length));
        this.xpoints = MemUtil.allocDouble(this.npoints);
        this.ypoints = MemUtil.allocDouble(this.npoints);
        System.arraycopy(dArray, 0, this.xpoints, 0, this.npoints);
        System.arraycopy(dArray2, 0, this.ypoints, 0, this.npoints);
    }

    public PolygonADV(double[] dArray, double[] dArray2, int n, int n2) {
        this.npoints = Math.min(n, Math.min(dArray.length, dArray2.length));
        n2 = Math.max(this.npoints, n2);
        this.xpoints = MemUtil.allocDouble(n2);
        this.ypoints = MemUtil.allocDouble(n2);
        System.arraycopy(dArray, 0, this.xpoints, 0, this.npoints);
        System.arraycopy(dArray2, 0, this.ypoints, 0, this.npoints);
    }

    public PolygonADV(int[] nArray, int[] nArray2, int n) {
        this.npoints = Math.min(n, Math.min(nArray.length, nArray2.length));
        this.xpoints = MemUtil.allocDouble(this.npoints);
        this.ypoints = MemUtil.allocDouble(this.npoints);
        int n2 = 0;
        while (n2 < this.npoints) {
            this.xpoints[n2] = nArray[n2];
            this.ypoints[n2] = nArray2[n2];
            ++n2;
        }
    }

    public void addPoint(double d, double d2) {
        this.makeRoom(1);
        this.xpoints[this.npoints] = d;
        this.ypoints[this.npoints] = d2;
        ++this.npoints;
        this.poly = null;
        this.boundingBox = null;
    }

    public Object clone() {
        PolygonADV polygonADV = new PolygonADV(this.npoints);
        System.arraycopy(this.xpoints, 0, polygonADV.xpoints, 0, this.npoints);
        System.arraycopy(this.ypoints, 0, polygonADV.ypoints, 0, this.npoints);
        polygonADV.npoints = this.npoints;
        return polygonADV;
    }

    public void close() {
        if (!this.isClosed() && this.npoints > 1) {
            this.addPoint(this.xpoints[0], this.ypoints[0]);
        }
    }

    public PolygonADV compact() {
        if (this.xpoints.length - this.npoints > 16) {
            double[] dArray = MemUtil.allocDouble(this.npoints);
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = MemUtil.allocDouble(this.npoints);
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        return this;
    }

    public int countEdges() {
        return this.npoints - 1;
    }

    public FloatRect getBoundingBox() {
        if (this.boundingBox == null) {
            if (this.npoints > 0) {
                double d;
                double d2;
                double d3 = d2 = this.xpoints[0];
                double d4 = d = this.ypoints[0];
                int n = 1;
                while (n < this.npoints) {
                    double d5 = this.xpoints[n];
                    if (d5 < d3) {
                        d3 = d5;
                    } else if (d5 > d2) {
                        d2 = d5;
                    }
                    d5 = this.ypoints[n];
                    if (d5 < d4) {
                        d4 = d5;
                    } else if (d5 > d) {
                        d = d5;
                    }
                    ++n;
                }
                this.boundingBox = new FloatRect(d3, d4, d2, d);
            } else {
                this.boundingBox = FloatRect.getEmptyRect();
            }
        }
        return this.boundingBox;
    }

    public void insertPoint(int n, double d, double d2) {
        if (n >= this.npoints - 1) {
            this.addPoint(d, d2);
        } else {
            this.makeRoom(1);
            System.arraycopy(this.xpoints, n + 1, this.xpoints, n + 2, this.npoints - n - 1);
            System.arraycopy(this.ypoints, n + 1, this.ypoints, n + 2, this.npoints - n - 1);
            this.xpoints[n + 1] = d;
            this.ypoints[n + 1] = d2;
            ++this.npoints;
            this.poly = null;
            this.boundingBox = null;
        }
    }

    public void insertPoints(int n, double[] dArray, double[] dArray2, int n2) {
        if (n >= this.npoints - 1) {
            n = this.npoints - 1;
        }
        this.makeRoom(n2);
        System.arraycopy(this.xpoints, n + 1, this.xpoints, n + 1 + n2, this.npoints - n - 1);
        System.arraycopy(this.ypoints, n + 1, this.ypoints, n + 1 + n2, this.npoints - n - 1);
        int n3 = 0;
        while (n3 < n2) {
            this.xpoints[n + 1 + n3] = dArray[n3];
            this.ypoints[n + 1 + n3] = dArray2[n3];
            ++n3;
        }
        this.npoints += n2;
        this.poly = null;
        this.boundingBox = null;
    }

    public boolean isClosed() {
        return this.npoints > 1 && this.xpoints[this.npoints - 1] == this.xpoints[0] && this.ypoints[this.npoints - 1] == this.ypoints[0];
    }

    public boolean isRectangular() {
        if (this.npoints < 4 || this.npoints > 5) {
            return false;
        }
        if (this.npoints == 5 && !this.isClosed()) {
            return false;
        }
        if (this.xpoints[0] == this.xpoints[1] && this.ypoints[1] == this.ypoints[2] && this.xpoints[2] == this.xpoints[3] && this.ypoints[3] == this.ypoints[0]) {
            return true;
        }
        return this.ypoints[0] == this.ypoints[1] && this.xpoints[1] == this.xpoints[2] && this.ypoints[2] == this.ypoints[3] && this.xpoints[3] == this.xpoints[0];
    }

    private void makeRoom(int n) {
        if (this.npoints + n > this.xpoints.length) {
            n = n - (this.xpoints.length - this.npoints) + 512;
            double[] dArray = MemUtil.allocDouble(this.npoints + n);
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = MemUtil.allocDouble(this.npoints + n);
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
    }

    public void replacePoint(int n, double d, double d2) {
        this.xpoints[n] = d;
        this.ypoints[n] = d2;
        this.poly = null;
        this.boundingBox = null;
    }

    public void reset() {
        this.npoints = 0;
        this.xpoints = new double[5];
        this.ypoints = new double[5];
    }

    public Polygon toPolygon() {
        if (this.poly == null) {
            int[] nArray = MemUtil.allocInt(this.npoints);
            int[] nArray2 = MemUtil.allocInt(this.npoints);
            int n = 0;
            while (n < this.npoints) {
                nArray[n] = (int)this.xpoints[n];
                nArray2[n] = (int)this.ypoints[n];
                ++n;
            }
            this.poly = new Polygon(nArray, nArray2, this.npoints);
        }
        return this.poly;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transformPoints(this.xpoints, this.ypoints, this.npoints);
        this.boundingBox = null;
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.xpoints[n2] = this.xpoints[n2] + d;
            int n3 = n++;
            this.ypoints[n3] = this.ypoints[n3] + d2;
        }
        if (this.boundingBox != null) {
            this.boundingBox = new FloatRect(this.boundingBox.getxMin() + d, this.boundingBox.getyMin() + d2, this.boundingBox.getxMax() + d, this.boundingBox.getyMax() + d2);
        }
    }
}

