/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore.security;

import com.adobe.acrobat.pdfobjstore.security.ConstantPDFObjStorePerms;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStoreCryptKey;

public class PDFObjStorePerms {
    public static final String Read_K = "Read";
    public static final String Print_K = "Print";
    public static final String Change_K = "Change";
    public static final String Copy_K = "Copy";
    public static final String Annotate_K = "Annotate";
    private static final int Print_B = 4;
    private static final int Change_B = 8;
    private static final int Copy_B = 16;
    private static final int Annotate_B = 32;
    private static PDFObjStorePerms gZeroPDFObjStorePerms = new ConstantPDFObjStorePerms(null, false, false, false);
    private PDFObjStoreCryptKey cryptKey;
    private String[] keys;
    private boolean haveOwner;
    private boolean haveUser;

    public PDFObjStorePerms(int n, PDFObjStoreCryptKey pDFObjStoreCryptKey, boolean bl, boolean bl2) {
        this(pDFObjStoreCryptKey, bl, bl2);
        int n2 = 1;
        if ((n & 4) != 0) {
            ++n2;
        }
        if ((n & 8) != 0) {
            ++n2;
        }
        if ((n & 0x10) != 0) {
            ++n2;
        }
        if ((n & 0x20) != 0) {
            ++n2;
        }
        this.keys = new String[n2];
        this.keys[0] = Read_K;
        n2 = 1;
        if ((n & 4) != 0) {
            this.keys[n2++] = Print_K;
        }
        if ((n & 8) != 0) {
            this.keys[n2++] = Change_K;
        }
        if ((n & 0x10) != 0) {
            this.keys[n2++] = Copy_K;
        }
        if ((n & 0x20) != 0) {
            this.keys[n2++] = Annotate_K;
        }
    }

    public PDFObjStorePerms(PDFObjStoreCryptKey pDFObjStoreCryptKey, boolean bl, boolean bl2) {
        this.cryptKey = pDFObjStoreCryptKey;
        this.keys = null;
        this.haveOwner = bl;
        this.haveUser = bl2;
    }

    public PDFObjStorePerms(String[] stringArray, PDFObjStoreCryptKey pDFObjStoreCryptKey, boolean bl, boolean bl2) {
        this(pDFObjStoreCryptKey, bl, bl2);
        this.keys = stringArray;
    }

    public boolean canAnnotate() {
        return this.get(Annotate_K);
    }

    public boolean canChange() {
        return this.get(Change_K);
    }

    public boolean canCopy() {
        return this.get(Copy_K);
    }

    public boolean canPrint() {
        return this.get(Print_K);
    }

    public boolean canRead() {
        return this.get(Read_K);
    }

    public boolean get(String string) {
        if (this.keys != null) {
            int n = this.keys.length;
            while (n-- > 0) {
                if (!this.keys[n].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public PDFObjStoreCryptKey getCryptKey() {
        return this.cryptKey;
    }

    public static PDFObjStorePerms getFullPDFObjStorePerms(PDFObjStoreCryptKey pDFObjStoreCryptKey, boolean bl, boolean bl2) {
        return new ConstantPDFObjStorePerms(pDFObjStoreCryptKey, true, bl, bl2);
    }

    public static PDFObjStorePerms getZeroPDFObjStorePerms() {
        return gZeroPDFObjStorePerms;
    }

    public boolean haveOwner() {
        return this.haveOwner;
    }

    public boolean haveUser() {
        return this.haveUser;
    }
}

