/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acrobat.pdfobjstore;

import com.adobe.acrobat.bytearray.ByteArray;
import com.adobe.acrobat.pdfobjstore.IndirectObjectNFExc;
import com.adobe.acrobat.pdfobjstore.PDFIndirectObj;
import com.adobe.acrobat.pdfobjstore.PDFNull;
import com.adobe.acrobat.pdfobjstore.PDFObj;
import com.adobe.acrobat.pdfobjstore.PDFObjMap;
import com.adobe.acrobat.pdfobjstore.PDFObjParser;
import com.adobe.acrobat.pdfobjstore.PDFObjStore;
import com.adobe.acrobat.pdfobjstore.VPDFObj;
import com.adobe.acrobat.pdfobjstore.security.PDFObjCryptKey;
import com.adobe.acrobat.pdfobjstore.security.PDFObjStoreCryptKey;
import com.adobe.acrobat.pdfobjstore.security.SecurityHandler;
import com.adobe.acrobat.tokenize.Tokenizer;
import com.adobe.pe.notify.DependencyInspectorFriend;
import com.adobe.pe.notify.Requester;
import java.io.InputStream;

class VIndirectObjResolution
extends VPDFObj
implements DependencyInspectorFriend {
    private static final String endobj_K = "endobj";
    private static final String obj_K = "obj";
    private PDFIndirectObj ref;

    VIndirectObjResolution(PDFIndirectObj pDFIndirectObj) {
        this.ref = pDFIndirectObj;
    }

    protected final PDFObj computePDFObj(Requester requester) throws Exception {
        PDFObj pDFObj;
        PDFObjStoreCryptKey pDFObjStoreCryptKey;
        short s;
        int n;
        PDFObjStore pDFObjStore = this.ref.store;
        PDFObjMap pDFObjMap = pDFObjStore.getMap(requester);
        int n2 = pDFObjMap.getIndirectObjectOffset(n = this.ref.getID(), s = this.ref.getGeneration());
        if (n2 == -1) {
            return PDFNull.getPDFNull();
        }
        if (pDFObjMap.shouldResistDecryption(n)) {
            pDFObjStoreCryptKey = null;
        } else {
            boolean bl = SecurityHandler.getPasswordCorrectBoolean(pDFObjStore).booleanValue(requester);
            if (!bl) {
                throw new Exception("Incorrect password");
            }
            pDFObjStoreCryptKey = pDFObjStore.getVPDFObjStoreCryptKey().peObjStoreCryptKeyValue(requester);
        }
        PDFObjCryptKey pDFObjCryptKey = null;
        ByteArray byteArray = pDFObjStore.getVByteArray().byteArrayValue(requester);
        int n3 = pDFObjMap.getIndirectObjectLength(n, s);
        if (pDFObjStoreCryptKey != null) {
            pDFObjCryptKey = new PDFObjCryptKey(pDFObjStoreCryptKey, n, s);
        }
        InputStream inputStream = byteArray.getByteStream(n2, n3);
        Tokenizer tokenizer = new Tokenizer(inputStream);
        try {
            tokenizer.nextToken();
            if (tokenizer.type() != 2 || tokenizer.integerValue() != n) {
                throw new IndirectObjectNFExc();
            }
            tokenizer.nextToken();
            if (tokenizer.type() != 2 || tokenizer.integerValue() != s) {
                throw new IndirectObjectNFExc();
            }
            tokenizer.nextToken();
            if (tokenizer.type() != 5 || !tokenizer.literalValue().equals(obj_K)) {
                throw new IndirectObjectNFExc();
            }
            tokenizer.nextToken();
            PDFObjParser pDFObjParser = new PDFObjParser(pDFObjStore, tokenizer, byteArray, n2, false, pDFObjCryptKey);
            PDFObj pDFObj2 = pDFObjParser.read();
            boolean bl = tokenizer.type() != 5 || !tokenizer.literalValue().equals(endobj_K);
            pDFObj = pDFObj2;
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            tokenizer.close();
            throw throwable;
        }
        tokenizer.close();
        return pDFObj;
    }

    public String getInfo(int n) {
        String string = super.getInfo(n);
        if (n == 1) {
            string = String.valueOf(string) + "[" + this.ref.getID() + ", " + this.ref.getGeneration() + "]";
        }
        return string;
    }
}

